/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.thrift;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.thrift.ThriftCoder;
import org.apache.beam.sdk.io.thrift.ThriftSchema;
import org.apache.beam.sdk.schemas.RowMessages;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.sdk.schemas.transforms.Cast;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TProtocolFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@AutoService(value={PayloadSerializerProvider.class})
public class ThriftPayloadSerializerProvider
implements PayloadSerializerProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "thrift";
    }

    private static @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TBase> getMessageClass(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> tableParams) {
        String thriftClassName = Preconditions.checkArgumentNotNull((Object)tableParams.get("thriftClass")).toString();
        try {
            Class<?> thriftClass = Class.forName(thriftClassName);
            return thriftClass.asSubclass(TBase.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Incorrect thrift class provided: " + thriftClassName, e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized TProtocolFactory getProtocolFactory(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> tableParams) {
        String thriftFactoryClassName = Preconditions.checkArgumentNotNull((Object)tableParams.get("thriftProtocolFactoryClass")).toString();
        try {
            Class<?> thriftClass = Class.forName(thriftFactoryClassName);
            return thriftClass.asSubclass(TProtocolFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Incorrect thrift protocol factory class provided: " + thriftFactoryClassName, e);
        }
    }

    private static void inferAndVerifySchema(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> thriftClass, @UnknownKeyFor @NonNull @Initialized Schema requiredSchema) {
        TypeDescriptor typeDescriptor = TypeDescriptor.of(thriftClass);
        Schema schema = (Schema)Preconditions.checkArgumentNotNull((Object)ThriftSchema.provider().schemaFor(typeDescriptor));
        if (!schema.assignableTo(requiredSchema)) {
            throw new IllegalArgumentException(String.format("Given message schema: '%s'%ndoes not match schema inferred from thrift class.%nThrift class: '%s'%nInferred schema: '%s'", requiredSchema, thriftClass.getName(), schema));
        }
    }

    private static <T extends TBase> @UnknownKeyFor @NonNull @Initialized PayloadSerializer getPayloadSerializer(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TProtocolFactory protocolFactory, @UnknownKeyFor @NonNull @Initialized Class<T> thriftClass) {
        ThriftCoder<T> coder = ThriftCoder.of(thriftClass, protocolFactory);
        TypeDescriptor descriptor = TypeDescriptor.of(thriftClass);
        SimpleFunction toRowFn = RowMessages.bytesToRowFn((SchemaProvider)ThriftSchema.provider(), (TypeDescriptor)descriptor, coder);
        return PayloadSerializer.of((SerializableFunction)RowMessages.rowToBytesFn((SchemaProvider)ThriftSchema.provider(), (TypeDescriptor)descriptor, coder), (SerializableFunction & Serializable)bytes -> {
            Row rawRow = (Row)toRowFn.apply(bytes);
            return Cast.castRow((Row)rawRow, (Schema)rawRow.getSchema(), (Schema)schema);
        });
    }

    public @UnknownKeyFor @NonNull @Initialized PayloadSerializer getSerializer(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> tableParams) {
        Class<? extends TBase> thriftClass = ThriftPayloadSerializerProvider.getMessageClass(tableParams);
        TProtocolFactory protocolFactory = ThriftPayloadSerializerProvider.getProtocolFactory(tableParams);
        ThriftPayloadSerializerProvider.inferAndVerifySchema(thriftClass, schema);
        return ThriftPayloadSerializerProvider.getPayloadSerializer(schema, protocolFactory, thriftClass);
    }
}

