/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.thrift;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProviderV2;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ThriftSchema
extends GetterBasedSchemaProviderV2 {
    private static final @UnknownKeyFor @NonNull @Initialized ThriftSchema defaultProvider = new ThriftSchema(Collections.emptyMap());
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType> typedefs;

    private ThriftSchema(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType> typedefs) {
        this.typedefs = typedefs;
    }

    public static @NonNull @UnknownKeyFor @Initialized SchemaProvider provider() {
        return defaultProvider;
    }

    public static @NonNull @UnknownKeyFor @Initialized Customizer custom() {
        return new Customizer();
    }

    public <T> @NonNull @UnknownKeyFor @Initialized Schema schemaFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        return this.schemaFor(typeDescriptor.getRawType());
    }

    private @UnknownKeyFor @NonNull @Initialized Schema schemaFor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass) {
        if (!TBase.class.isAssignableFrom(targetClass)) {
            throw new IllegalArgumentException("Expected thrift class but got: " + targetClass);
        }
        Stream<Schema.Field> fields = ThriftSchema.thriftFieldDescriptors(targetClass).values().stream().map(this::beamField);
        if (TUnion.class.isAssignableFrom(targetClass)) {
            return OneOfType.create(fields.collect(Collectors.toList())).getOneOfSchema();
        }
        return fields.reduce(Schema.builder(), Schema.Builder::addField, ThriftSchema::throwingCombiner).build();
    }

    private static <X> X throwingCombiner(X lhs, X rhs) {
        throw new IllegalStateException();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field beamField(@UnknownKeyFor @NonNull @Initialized FieldMetaData fieldDescriptor) {
        try {
            Schema.FieldType type = this.beamType(fieldDescriptor.valueMetaData);
            switch (fieldDescriptor.requirementType) {
                case 1: {
                    return Schema.Field.of((String)fieldDescriptor.fieldName, (Schema.FieldType)type);
                }
            }
            return Schema.Field.nullable((String)fieldDescriptor.fieldName, (Schema.FieldType)type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not infer beam type for thrift field: " + fieldDescriptor.fieldName, e);
        }
    }

    public @NonNull @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @NonNull @UnknownKeyFor @Initialized Schema schema) {
        return this.schemaFieldDescriptors(targetTypeDescriptor.getRawType(), schema).keySet().stream().map(x$0 -> new FieldExtractor((TFieldIdEnum)x$0, null)).collect(Collectors.toList());
    }

    public @NonNull @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @NonNull @UnknownKeyFor @Initialized Schema schema) {
        return this.schemaFieldDescriptors(targetTypeDescriptor.getRawType(), schema).values().stream().map(descriptor -> this.fieldValueTypeInfo(targetTypeDescriptor.getRawType(), descriptor.fieldName)).collect(Collectors.toList());
    }

    private static <FieldT extends TFieldIdEnum, T extends TBase<T, FieldT>> @UnknownKeyFor @NonNull @Initialized Map<FieldT, @UnknownKeyFor @NonNull @Initialized FieldMetaData> thriftFieldDescriptors(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass) {
        return FieldMetaData.getStructMetaDataMap(targetClass);
    }

    private @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation fieldValueTypeInfo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized String fieldName) {
        if (TUnion.class.isAssignableFrom(type)) {
            List factoryMethods = Stream.of(type.getDeclaredMethods()).filter(m -> m.getName().equals(fieldName)).filter(m -> m.getModifiers() == 9).filter(m -> m.getParameterCount() == 1).filter(m -> m.getReturnType() == type).collect(Collectors.toList());
            if (factoryMethods.isEmpty()) {
                throw new IllegalArgumentException(String.format("No suitable static factory method: %s.%s(...)", type.getName(), fieldName));
            }
            if (factoryMethods.size() > 1) {
                throw new IllegalStateException("Overloaded factory methods: " + factoryMethods);
            }
            return FieldValueTypeInformation.forSetter((Method)((Method)factoryMethods.get(0)), (String)"");
        }
        try {
            return FieldValueTypeInformation.forField((Field)type.getDeclaredField(fieldName), (int)0);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public @NonNull @UnknownKeyFor @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @NonNull @UnknownKeyFor @Initialized Schema schema) {
        Map<TFieldIdEnum, FieldMetaData> fieldDescriptors = this.schemaFieldDescriptors(targetTypeDescriptor.getRawType(), schema);
        return (SchemaUserTypeCreator & Serializable)params -> this.restoreThriftObject(targetTypeDescriptor.getRawType(), fieldDescriptors, params);
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TFieldIdEnum, @UnknownKeyFor @NonNull @Initialized FieldMetaData> schemaFieldDescriptors(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Map fieldDescriptors = ThriftSchema.thriftFieldDescriptors(targetClass);
        Map fields = fieldDescriptors.keySet().stream().collect(Collectors.toMap(TFieldIdEnum::getFieldName, Function.identity()));
        return schema.getFields().stream().map(Schema.Field::getName).map(fields::get).collect(Collectors.toMap(Function.identity(), fieldDescriptors::get, ThriftSchema::throwingCombiner, LinkedHashMap::new));
    }

    private <FieldT extends TFieldIdEnum, T extends TBase<T, FieldT>> T restoreThriftObject(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass, @UnknownKeyFor @NonNull @Initialized Map<FieldT, @UnknownKeyFor @NonNull @Initialized FieldMetaData> fields, @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] params) {
        if (params.length != fields.size()) {
            throw new IllegalArgumentException(String.format("The parameter list: %s does not match the expected fields: %s", Arrays.toString(params), fields.keySet()));
        }
        try {
            TBase thrift = (TBase)targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Iterator iter = fields.entrySet().iterator();
            Stream.of(params).forEach(param -> this.setThriftField(thrift, (Map.Entry)iter.next(), param));
            return (T)thrift;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private <FieldT extends TFieldIdEnum, T extends TBase<T, FieldT>> void setThriftField(T thrift, @UnknownKeyFor @NonNull @Initialized Map.Entry<FieldT, @UnknownKeyFor @NonNull @Initialized FieldMetaData> fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
        TFieldIdEnum field = (TFieldIdEnum)fieldDescriptor.getKey();
        FieldMetaData descriptor = fieldDescriptor.getValue();
        if (value != null) {
            TEnum actualValue;
            switch (descriptor.valueMetaData.type) {
                case 14: {
                    actualValue = StreamSupport.stream(((Iterable)value).spliterator(), false).collect(Collectors.toSet());
                    break;
                }
                case 16: {
                    Class enumClass = ((EnumMetaData)descriptor.valueMetaData).enumClass;
                    TEnum[] enumConstants = (TEnum[])enumClass.getEnumConstants();
                    actualValue = enumConstants[(Integer)value];
                    break;
                }
                default: {
                    actualValue = value;
                }
            }
            thrift.setFieldValue(field, (Object)actualValue);
        }
    }

    private <EnumT extends Enum<EnumT>> // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamType(@UnknownKeyFor @NonNull @Initialized FieldValueMetaData metadata) {
        Schema.FieldType beamType;
        if (metadata.isTypedef() && (beamType = this.typedefs.get(metadata.getTypedefName())) != null) {
            return beamType;
        }
        switch (metadata.type) {
            case 2: {
                return Schema.FieldType.BOOLEAN;
            }
            case 3: {
                return Schema.FieldType.BYTE;
            }
            case 6: {
                return Schema.FieldType.INT16;
            }
            case 8: {
                return Schema.FieldType.INT32;
            }
            case 10: {
                return Schema.FieldType.INT64;
            }
            case 4: {
                return Schema.FieldType.DOUBLE;
            }
            case 11: {
                return metadata.isBinary() ? Schema.FieldType.BYTES : Schema.FieldType.STRING;
            }
            case 14: {
                FieldValueMetaData setElemMetadata = ((SetMetaData)metadata).elemMetaData;
                return Schema.FieldType.iterable((Schema.FieldType)this.beamType(setElemMetadata));
            }
            case 15: {
                FieldValueMetaData listElemMetadata = ((ListMetaData)metadata).elemMetaData;
                return Schema.FieldType.array((Schema.FieldType)this.beamType(listElemMetadata));
            }
            case 13: {
                MapMetaData mapMetadata = (MapMetaData)metadata;
                return Schema.FieldType.map((Schema.FieldType)this.beamType(mapMetadata.keyMetaData), (Schema.FieldType)this.beamType(mapMetadata.valueMetaData));
            }
            case 12: {
                StructMetaData structMetadata = (StructMetaData)metadata;
                return Schema.FieldType.row((Schema)this.schemaFor(structMetadata.structClass));
            }
            case 16: {
                Class enumClass = ((EnumMetaData)metadata).enumClass;
                Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
                String[] enumValues = (String[])Stream.of(enumConstants).map(rec$ -> ((Enum)rec$).name()).toArray(String[]::new);
                return Schema.FieldType.logicalType((Schema.LogicalType)EnumerationType.create((String[])enumValues));
            }
        }
        throw new IllegalArgumentException("Unsupported thrift type code: " + metadata.type);
    }

    private static class FieldExtractor<@UnknownKeyFor FieldT extends @UnknownKeyFor @NonNull @Initialized TFieldIdEnum, @UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized TBase<T, FieldT>>
    implements FieldValueGetter<T, Object> {
        private final FieldT field;

        private FieldExtractor(FieldT field) {
            this.field = field;
        }

        public @Nullable @UnknownKeyFor @Initialized Object get(T thrift) {
            if (!(thrift instanceof TUnion) || thrift.isSet(this.field)) {
                Object value = thrift.getFieldValue(this.field);
                if (value instanceof Enum) {
                    return ((Enum)value).ordinal();
                }
                return value;
            }
            return null;
        }

        public @NonNull @UnknownKeyFor @Initialized String name() {
            return this.field.getFieldName();
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.name();
        }

        /* synthetic */ FieldExtractor(TFieldIdEnum x0, 1 x1) {
            this(x0);
        }
    }

    public static final class Customizer {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType> typedefs = new HashMap<String, Schema.FieldType>();

        private Customizer() {
        }

        public @NonNull @UnknownKeyFor @Initialized Customizer typedef(@NonNull @UnknownKeyFor @Initialized String thriftTypedefName, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull @UnknownKeyFor @Initialized Schema.FieldType beamType) {
            this.typedefs.put(thriftTypedefName, beamType);
            return this;
        }

        public @NonNull @UnknownKeyFor @Initialized SchemaProvider provider() {
            if (this.typedefs.isEmpty()) {
                return defaultProvider;
            }
            return new ThriftSchema(Collections.unmodifiableMap(new HashMap<String, Schema.FieldType>(this.typedefs)));
        }
    }
}

