/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.thrift;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ThriftCoder<@UnknownKeyFor T>
extends CustomCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized Class<T> type;
    private final @UnknownKeyFor @NonNull @Initialized TProtocolFactory protocolFactory;

    protected ThriftCoder(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized TProtocolFactory protocolFactory) {
        this.type = type;
        this.protocolFactory = protocolFactory;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ThriftCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized TProtocolFactory protocolFactory) {
        return new ThriftCoder<T>(clazz, protocolFactory);
    }

    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TProtocol protocol = this.protocolFactory.getProtocol((TTransport)new TIOStreamTransport((OutputStream)baos));
        try {
            TBase tBase = (TBase)value;
            tBase.write(protocol);
        }
        catch (Exception te) {
            throw new CoderException("Could not write value. Error: " + te.getMessage());
        }
        outStream.write(baos.toByteArray());
    }

    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)new TIOStreamTransport(inStream));
            TBase value = (TBase)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            value.read(protocol);
            return (T)value;
        }
        catch (Exception te) {
            throw new CoderException("Could not read value. Error: " + te.getMessage());
        }
    }
}

