/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface SnowflakePipelineOptions
extends PipelineOptions,
StreamingOptions {
    public static final @UnknownKeyFor @NonNull @Initialized String BASIC_CONNECTION_INFO_VALIDATION_GROUP = "BASIC_CONNECTION_INFO_GROUP";
    public static final @UnknownKeyFor @NonNull @Initialized String AUTH_VALIDATION_GROUP = "AUTH_VALIDATION_GROUP";

    @Description(value="Snowflake's JDBC-like url including account name and region without any parameters.")
    @Validation.Required(groups={"BASIC_CONNECTION_INFO_GROUP"})
    public @UnknownKeyFor @NonNull @Initialized String getUrl();

    public void setUrl(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Server Name - full server name with account, zone and domain.")
    @Validation.Required(groups={"BASIC_CONNECTION_INFO_GROUP"})
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getServerName();

    public void setServerName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Username. Required for username/password and Private Key authentication.")
    @Validation.Required(groups={"AUTH_VALIDATION_GROUP"})
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getUsername();

    public void setUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="OAuth token. Required for OAuth authentication only.")
    @Validation.Required(groups={"AUTH_VALIDATION_GROUP"})
    public @UnknownKeyFor @NonNull @Initialized String getOauthToken();

    public void setOauthToken(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Password. Required for username/password authentication only.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getPassword();

    public void setPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Path to Private Key file. Required for Private Key authentication only.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized String getPrivateKeyPath();

    public void setPrivateKeyPath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Private key. Required for Private Key authentication only.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getRawPrivateKey();

    public void setRawPrivateKey(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Private Key's passphrase. Required for Private Key authentication only.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getPrivateKeyPassphrase();

    public void setPrivateKeyPassphrase(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Warehouse to use. Optional.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getWarehouse();

    public void setWarehouse(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Database name to connect to. Optional.")
    @Default.String(value="")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getDatabase();

    public void setDatabase(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Schema to use. Optional.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getSchema();

    public void setSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Table to use. Optional.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTable();

    public void setTable(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Query to use. Optional.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery();

    public void setQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Role to use. Optional.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getRole();

    public void setRole(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Authenticator to use. Optional.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized String getAuthenticator();

    public void setAuthenticator(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Port number. Optional.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized String getPortNumber();

    public void setPortNumber(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Login timeout. Optional.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized String getLoginTimeout();

    public void setLoginTimeout(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Temporary GCS bucket name.")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getStagingBucketName();

    public void setStagingBucketName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Storage integration name")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getStorageIntegrationName();

    public void setStorageIntegrationName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="SnowPipe name. Optional.")
    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getSnowPipe();

    public void setSnowPipe(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);
}

