/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.data.text;

import java.io.Serializable;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SnowflakeVarchar
implements SnowflakeDataType,
Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized Long MAX_LENGTH = 0x1000000L;
    private @UnknownKeyFor @NonNull @Initialized Long length;

    public static @UnknownKeyFor @NonNull @Initialized SnowflakeVarchar of() {
        return new SnowflakeVarchar();
    }

    public static @UnknownKeyFor @NonNull @Initialized SnowflakeVarchar of(@UnknownKeyFor @NonNull @Initialized long length) {
        return new SnowflakeVarchar(length);
    }

    public SnowflakeVarchar() {
    }

    public SnowflakeVarchar(@UnknownKeyFor @NonNull @Initialized long length) {
        if (length > MAX_LENGTH) {
            throw new IllegalArgumentException(String.format("Provided length %s is bigger than max length %s ", length, MAX_LENGTH));
        }
        this.length = length;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String sql() {
        if (this.length != null) {
            return String.format("VARCHAR(%d)", this.length);
        }
        return "VARCHAR";
    }

    public @UnknownKeyFor @NonNull @Initialized Long getLength() {
        return this.length;
    }

    public void setLength(@UnknownKeyFor @NonNull @Initialized Long length) {
        this.length = length;
    }
}

