/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KeyPairUtils {
    public static @UnknownKeyFor @NonNull @Initialized PrivateKey preparePrivateKey(@UnknownKeyFor @NonNull @Initialized String privateKey, @UnknownKeyFor @NonNull @Initialized String privateKeyPassphrase) {
        privateKey = privateKey.replace("-----BEGIN ENCRYPTED PRIVATE KEY-----", "");
        privateKey = privateKey.replace("-----END ENCRYPTED PRIVATE KEY-----", "");
        try {
            EncryptedPrivateKeyInfo pkInfo = new EncryptedPrivateKeyInfo(Base64.getMimeDecoder().decode(privateKey));
            PBEKeySpec keySpec = new PBEKeySpec(privateKeyPassphrase.toCharArray());
            SecretKeyFactory pbeKeyFactory = SecretKeyFactory.getInstance(pkInfo.getAlgName());
            PKCS8EncodedKeySpec encodedKeySpec = pkInfo.getKeySpec(pbeKeyFactory.generateSecret(keySpec));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(encodedKeySpec);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Can't create private key");
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String readPrivateKeyFile(@UnknownKeyFor @NonNull @Initialized String privateKeyPath) {
        try {
            byte[] keyBytes = Files.readAllBytes(Paths.get(privateKeyPath, new String[0]));
            return new String(keyBytes, Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read private key from provided path");
        }
    }
}

