/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.credentials;

import org.apache.beam.sdk.io.snowflake.SnowflakePipelineOptions;
import org.apache.beam.sdk.io.snowflake.credentials.KeyPairSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.OAuthTokenSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.SnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.UsernamePasswordSnowflakeCredentials;

public class SnowflakeCredentialsFactory {
    public static SnowflakeCredentials of(SnowflakePipelineOptions options) {
        if (SnowflakeCredentialsFactory.oauthOptionsAvailable(options)) {
            return new OAuthTokenSnowflakeCredentials(options.getOauthToken());
        }
        if (SnowflakeCredentialsFactory.usernamePasswordOptionsAvailable(options)) {
            return new UsernamePasswordSnowflakeCredentials(options.getUsername(), options.getPassword());
        }
        if (SnowflakeCredentialsFactory.keyPairOptionsAvailable(options)) {
            return new KeyPairSnowflakeCredentials(options.getUsername(), options.getPrivateKeyPath(), options.getPrivateKeyPassphrase());
        }
        throw new RuntimeException("Can't get credentials from Options");
    }

    private static boolean oauthOptionsAvailable(SnowflakePipelineOptions options) {
        return options.getOauthToken() != null && !options.getOauthToken().isEmpty();
    }

    private static boolean usernamePasswordOptionsAvailable(SnowflakePipelineOptions options) {
        return options.getUsername() != null && !options.getUsername().isEmpty() && !options.getPassword().isEmpty();
    }

    private static boolean keyPairOptionsAvailable(SnowflakePipelineOptions options) {
        return options.getUsername() != null && !options.getUsername().isEmpty() && !options.getPrivateKeyPath().isEmpty() && !options.getPrivateKeyPassphrase().isEmpty();
    }
}

