/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import org.apache.beam.sdk.io.redis.RedisConnectionConfiguration;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_RedisConnectionConfiguration
extends RedisConnectionConfiguration {
    private final ValueProvider<String> host;
    private final ValueProvider<Integer> port;
    private final @Nullable ValueProvider<String> auth;
    private final ValueProvider<Integer> timeout;
    private final ValueProvider<Boolean> ssl;

    private AutoValue_RedisConnectionConfiguration(ValueProvider<String> host, ValueProvider<Integer> port, @Nullable ValueProvider<String> auth, ValueProvider<Integer> timeout, ValueProvider<Boolean> ssl) {
        this.host = host;
        this.port = port;
        this.auth = auth;
        this.timeout = timeout;
        this.ssl = ssl;
    }

    @Override
    ValueProvider<String> host() {
        return this.host;
    }

    @Override
    ValueProvider<Integer> port() {
        return this.port;
    }

    @Override
    @Nullable ValueProvider<String> auth() {
        return this.auth;
    }

    @Override
    ValueProvider<Integer> timeout() {
        return this.timeout;
    }

    @Override
    ValueProvider<Boolean> ssl() {
        return this.ssl;
    }

    public String toString() {
        return "RedisConnectionConfiguration{host=" + this.host + ", port=" + this.port + ", auth=" + this.auth + ", timeout=" + this.timeout + ", ssl=" + this.ssl + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RedisConnectionConfiguration) {
            RedisConnectionConfiguration that = (RedisConnectionConfiguration)o;
            return this.host.equals(that.host()) && this.port.equals(that.port()) && (this.auth == null ? that.auth() == null : this.auth.equals(that.auth())) && this.timeout.equals(that.timeout()) && this.ssl.equals(that.ssl());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.host.hashCode();
        h$ *= 1000003;
        h$ ^= this.port.hashCode();
        h$ *= 1000003;
        h$ ^= this.auth == null ? 0 : this.auth.hashCode();
        h$ *= 1000003;
        h$ ^= this.timeout.hashCode();
        h$ *= 1000003;
        return h$ ^= this.ssl.hashCode();
    }

    @Override
    RedisConnectionConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends RedisConnectionConfiguration.Builder {
        private ValueProvider<String> host;
        private ValueProvider<Integer> port;
        private @Nullable ValueProvider<String> auth;
        private ValueProvider<Integer> timeout;
        private ValueProvider<Boolean> ssl;

        Builder() {
        }

        private Builder(RedisConnectionConfiguration source) {
            this.host = source.host();
            this.port = source.port();
            this.auth = source.auth();
            this.timeout = source.timeout();
            this.ssl = source.ssl();
        }

        @Override
        RedisConnectionConfiguration.Builder setHost(ValueProvider<String> host) {
            if (host == null) {
                throw new NullPointerException("Null host");
            }
            this.host = host;
            return this;
        }

        @Override
        RedisConnectionConfiguration.Builder setPort(ValueProvider<Integer> port) {
            if (port == null) {
                throw new NullPointerException("Null port");
            }
            this.port = port;
            return this;
        }

        @Override
        RedisConnectionConfiguration.Builder setAuth(ValueProvider<String> auth) {
            this.auth = auth;
            return this;
        }

        @Override
        RedisConnectionConfiguration.Builder setTimeout(ValueProvider<Integer> timeout) {
            if (timeout == null) {
                throw new NullPointerException("Null timeout");
            }
            this.timeout = timeout;
            return this;
        }

        @Override
        RedisConnectionConfiguration.Builder setSsl(ValueProvider<Boolean> ssl) {
            if (ssl == null) {
                throw new NullPointerException("Null ssl");
            }
            this.ssl = ssl;
            return this;
        }

        @Override
        RedisConnectionConfiguration build() {
            if (this.host == null || this.port == null || this.timeout == null || this.ssl == null) {
                StringBuilder missing = new StringBuilder();
                if (this.host == null) {
                    missing.append(" host");
                }
                if (this.port == null) {
                    missing.append(" port");
                }
                if (this.timeout == null) {
                    missing.append(" timeout");
                }
                if (this.ssl == null) {
                    missing.append(" ssl");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RedisConnectionConfiguration(this.host, this.port, this.auth, this.timeout, this.ssl);
        }
    }
}

