/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;

final class AutoValue_ParquetIO_Parse<T>
extends ParquetIO.Parse<T> {
    private final ValueProvider<String> filepattern;
    private final SerializableFunction<GenericRecord, T> parseFn;
    private final SerializableConfiguration configuration;
    private final boolean splittable;

    private AutoValue_ParquetIO_Parse(@Nullable ValueProvider<String> filepattern, SerializableFunction<GenericRecord, T> parseFn, @Nullable SerializableConfiguration configuration, boolean splittable) {
        this.filepattern = filepattern;
        this.parseFn = parseFn;
        this.configuration = configuration;
        this.splittable = splittable;
    }

    @Override
    @Nullable
    ValueProvider<String> getFilepattern() {
        return this.filepattern;
    }

    @Override
    SerializableFunction<GenericRecord, T> getParseFn() {
        return this.parseFn;
    }

    @Override
    @Nullable
    SerializableConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    boolean isSplittable() {
        return this.splittable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParquetIO.Parse) {
            ParquetIO.Parse that = (ParquetIO.Parse)((Object)o);
            return (this.filepattern == null ? that.getFilepattern() == null : this.filepattern.equals(that.getFilepattern())) && this.parseFn.equals(that.getParseFn()) && (this.configuration == null ? that.getConfiguration() == null : this.configuration.equals(that.getConfiguration())) && this.splittable == that.isSplittable();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filepattern == null ? 0 : this.filepattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.parseFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.configuration == null ? 0 : this.configuration.hashCode();
        h$ *= 1000003;
        return h$ ^= this.splittable ? 1231 : 1237;
    }

    @Override
    ParquetIO.Parse.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends ParquetIO.Parse.Builder<T> {
        private ValueProvider<String> filepattern;
        private SerializableFunction<GenericRecord, T> parseFn;
        private SerializableConfiguration configuration;
        private Boolean splittable;

        Builder() {
        }

        private Builder(ParquetIO.Parse<T> source) {
            this.filepattern = source.getFilepattern();
            this.parseFn = source.getParseFn();
            this.configuration = source.getConfiguration();
            this.splittable = source.isSplittable();
        }

        @Override
        ParquetIO.Parse.Builder<T> setFilepattern(ValueProvider<String> filepattern) {
            this.filepattern = filepattern;
            return this;
        }

        @Override
        ParquetIO.Parse.Builder<T> setParseFn(SerializableFunction<GenericRecord, T> parseFn) {
            if (parseFn == null) {
                throw new NullPointerException("Null parseFn");
            }
            this.parseFn = parseFn;
            return this;
        }

        @Override
        ParquetIO.Parse.Builder<T> setConfiguration(SerializableConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        ParquetIO.Parse.Builder<T> setSplittable(boolean splittable) {
            this.splittable = splittable;
            return this;
        }

        @Override
        ParquetIO.Parse<T> build() {
            String missing = "";
            if (this.parseFn == null) {
                missing = missing + " parseFn";
            }
            if (this.splittable == null) {
                missing = missing + " splittable";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ParquetIO_Parse(this.filepattern, this.parseFn, this.configuration, this.splittable);
        }
    }
}

