/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.options.ValueProvider;

final class AutoValue_ParquetIO_Read
extends ParquetIO.Read {
    private final ValueProvider<String> filepattern;
    private final Schema schema;
    private final Schema projectionSchema;
    private final Schema encoderSchema;
    private final GenericData avroDataModel;
    private final boolean splittable;

    private AutoValue_ParquetIO_Read(@Nullable ValueProvider<String> filepattern, @Nullable Schema schema, @Nullable Schema projectionSchema, @Nullable Schema encoderSchema, @Nullable GenericData avroDataModel, boolean splittable) {
        this.filepattern = filepattern;
        this.schema = schema;
        this.projectionSchema = projectionSchema;
        this.encoderSchema = encoderSchema;
        this.avroDataModel = avroDataModel;
        this.splittable = splittable;
    }

    @Override
    @Nullable
    ValueProvider<String> getFilepattern() {
        return this.filepattern;
    }

    @Override
    @Nullable
    Schema getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    Schema getProjectionSchema() {
        return this.projectionSchema;
    }

    @Override
    @Nullable
    Schema getEncoderSchema() {
        return this.encoderSchema;
    }

    @Override
    @Nullable
    GenericData getAvroDataModel() {
        return this.avroDataModel;
    }

    @Override
    boolean isSplittable() {
        return this.splittable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParquetIO.Read) {
            ParquetIO.Read that = (ParquetIO.Read)((Object)o);
            return (this.filepattern == null ? that.getFilepattern() == null : this.filepattern.equals(that.getFilepattern())) && (this.schema == null ? that.getSchema() == null : this.schema.equals((Object)that.getSchema())) && (this.projectionSchema == null ? that.getProjectionSchema() == null : this.projectionSchema.equals((Object)that.getProjectionSchema())) && (this.encoderSchema == null ? that.getEncoderSchema() == null : this.encoderSchema.equals((Object)that.getEncoderSchema())) && (this.avroDataModel == null ? that.getAvroDataModel() == null : this.avroDataModel.equals(that.getAvroDataModel())) && this.splittable == that.isSplittable();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filepattern == null ? 0 : this.filepattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema == null ? 0 : this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectionSchema == null ? 0 : this.projectionSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.encoderSchema == null ? 0 : this.encoderSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.avroDataModel == null ? 0 : this.avroDataModel.hashCode();
        h$ *= 1000003;
        return h$ ^= this.splittable ? 1231 : 1237;
    }

    @Override
    ParquetIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ParquetIO.Read.Builder {
        private ValueProvider<String> filepattern;
        private Schema schema;
        private Schema projectionSchema;
        private Schema encoderSchema;
        private GenericData avroDataModel;
        private Boolean splittable;

        Builder() {
        }

        private Builder(ParquetIO.Read source) {
            this.filepattern = source.getFilepattern();
            this.schema = source.getSchema();
            this.projectionSchema = source.getProjectionSchema();
            this.encoderSchema = source.getEncoderSchema();
            this.avroDataModel = source.getAvroDataModel();
            this.splittable = source.isSplittable();
        }

        @Override
        ParquetIO.Read.Builder setFilepattern(ValueProvider<String> filepattern) {
            this.filepattern = filepattern;
            return this;
        }

        @Override
        ParquetIO.Read.Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        ParquetIO.Read.Builder setProjectionSchema(Schema projectionSchema) {
            this.projectionSchema = projectionSchema;
            return this;
        }

        @Override
        ParquetIO.Read.Builder setEncoderSchema(Schema encoderSchema) {
            this.encoderSchema = encoderSchema;
            return this;
        }

        @Override
        ParquetIO.Read.Builder setAvroDataModel(GenericData avroDataModel) {
            this.avroDataModel = avroDataModel;
            return this;
        }

        @Override
        ParquetIO.Read.Builder setSplittable(boolean splittable) {
            this.splittable = splittable;
            return this;
        }

        @Override
        ParquetIO.Read build() {
            String missing = "";
            if (this.splittable == null) {
                missing = missing + " splittable";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ParquetIO_Read(this.filepattern, this.schema, this.projectionSchema, this.encoderSchema, this.avroDataModel, this.splittable);
        }
    }
}

