/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.parquet.GenericRecordReadConverter;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

@Internal
public class ParquetSchemaIOProvider
implements SchemaIOProvider {
    public String identifier() {
        return "parquet";
    }

    public Schema configurationSchema() {
        return Schema.builder().build();
    }

    public ParquetSchemaIO from(String location, Row configuration, Schema dataSchema) {
        return new ParquetSchemaIO(location, dataSchema);
    }

    public boolean requiresDataSchema() {
        return true;
    }

    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    private static class ParquetSchemaIO
    implements SchemaIO,
    Serializable {
        protected final Schema dataSchema;
        protected final String location;

        private ParquetSchemaIO(String location, Schema dataSchema) {
            this.dataSchema = dataSchema;
            this.location = location;
        }

        public Schema schema() {
            return this.dataSchema;
        }

        public PTransform<PBegin, PCollection<Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public PCollection<Row> expand(PBegin begin) {
                    GenericRecordReadConverter readConverter = GenericRecordReadConverter.builder().beamSchema(dataSchema).build();
                    return (PCollection)((PCollection)begin.apply("ParquetIORead", (PTransform)ParquetIO.read(AvroUtils.toAvroSchema((Schema)dataSchema)).from(location))).apply("GenericRecordToRow", (PTransform)readConverter);
                }
            };
        }

        public PTransform<PCollection<Row>, POutput> buildWriter() {
            throw new UnsupportedOperationException("Writing to a Parquet file is not supported");
        }
    }
}

