/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import com.mongodb.util.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbGridFSIO_ConnectionConfiguration;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbGridFSIO_Read;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbGridFSIO_Write;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.bson.types.ObjectId;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class MongoDbGridFSIO {
    private static final @UnknownKeyFor @NonNull @Initialized Parser<@UnknownKeyFor @NonNull @Initialized String> TEXT_PARSER = (input, callback) -> {
        Instant time = new Instant(input.getUploadDate().getTime());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input.getInputStream(), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                callback.output(line, time);
                line = reader.readLine();
            }
        }
    };

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized String> read() {
        return new AutoValue_MongoDbGridFSIO_Read.Builder<String>().setParser(TEXT_PARSER).setCoder((Coder<String>)StringUtf8Coder.of()).setConnectionConfiguration(ConnectionConfiguration.create()).setSkew(Duration.ZERO).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized String> write() {
        return new AutoValue_MongoDbGridFSIO_Write.Builder().setConnectionConfiguration(ConnectionConfiguration.create()).setWriteFn((output, outStream) -> {
            outStream.write(output.getBytes(StandardCharsets.UTF_8));
            outStream.write(10);
        }).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write(@UnknownKeyFor @NonNull @Initialized WriteFn<T> fn) {
        return new AutoValue_MongoDbGridFSIO_Write.Builder<T>().setWriteFn(fn).setConnectionConfiguration(ConnectionConfiguration.create()).build();
    }

    private static class GridFsWriteFn<@UnknownKeyFor T>
    extends DoFn<T, Void> {
        private final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
        private transient @Nullable @UnknownKeyFor @Initialized MongoClient mongo;
        private transient @Nullable @UnknownKeyFor @Initialized GridFS gridfs;
        private transient @Nullable @UnknownKeyFor @Initialized GridFSInputFile gridFsFile;
        private transient @Nullable @UnknownKeyFor @Initialized OutputStream outputStream;

        public GridFsWriteFn(@UnknownKeyFor @NonNull @Initialized Write<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.mongo = this.spec.connectionConfiguration().setupMongo();
            this.gridfs = this.spec.connectionConfiguration().setupGridFS(this.mongo);
        }

        @DoFn.StartBundle
        public void startBundle() {
            GridFS gridfs = (GridFS)Preconditions.checkStateNotNull((Object)this.gridfs);
            String filename = (String)Preconditions.checkStateNotNull((Object)this.spec.filename());
            this.gridFsFile = gridfs.createFile(filename);
            if (this.spec.chunkSize() != null) {
                this.gridFsFile.setChunkSize(this.spec.chunkSize().longValue());
            }
            this.outputStream = this.gridFsFile.getOutputStream();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkStateNotNull((Object)this.outputStream);
            Object record = context.element();
            this.spec.writeFn().write(record, this.outputStream);
        }

        @DoFn.FinishBundle
        public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.gridFsFile != null) {
                this.gridFsFile = null;
            }
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            try {
                if (this.outputStream != null) {
                    this.outputStream.flush();
                    this.outputStream.close();
                    this.outputStream = null;
                }
                if (this.gridFsFile != null) {
                    this.gridFsFile = null;
                }
            }
            finally {
                if (this.mongo != null) {
                    this.mongo.close();
                    this.mongo = null;
                    this.gridfs = null;
                }
            }
        }
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized Long chunkSize();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized WriteFn<T> writeFn();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized String filename();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> withUri(@UnknownKeyFor @NonNull @Initialized String uri) {
            Preconditions.checkArgumentNotNull((Object)uri);
            ConnectionConfiguration config = ConnectionConfiguration.create(uri, this.connectionConfiguration().database(), this.connectionConfiguration().bucket());
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
            Preconditions.checkArgumentNotNull((Object)database);
            ConnectionConfiguration config = ConnectionConfiguration.create(this.connectionConfiguration().uri(), database, this.connectionConfiguration().bucket());
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withBucket(@UnknownKeyFor @NonNull @Initialized String bucket) {
            Preconditions.checkArgumentNotNull((Object)bucket);
            ConnectionConfiguration config = ConnectionConfiguration.create(this.connectionConfiguration().uri(), this.connectionConfiguration().database(), bucket);
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFilename(@UnknownKeyFor @NonNull @Initialized String filename) {
            Preconditions.checkArgumentNotNull((Object)filename);
            return this.toBuilder().setFilename(filename).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withChunkSize(@UnknownKeyFor @NonNull @Initialized Long chunkSize) {
            Preconditions.checkArgumentNotNull((Object)chunkSize);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((chunkSize > 1L ? 1 : 0) != 0, (String)"Chunk Size must be greater than 1", (Object)chunkSize);
            return this.toBuilder().setChunkSize(chunkSize).build();
        }

        public void validate(T input) {
            Preconditions.checkArgumentNotNull((Object)this.filename(), (Object)"filename");
            Preconditions.checkArgumentNotNull(this.writeFn(), (Object)"writeFn");
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"uri", (String)this.connectionConfiguration().uri()));
            builder.addIfNotNull(DisplayData.item((String)"database", (String)this.connectionConfiguration().database()));
            builder.addIfNotNull(DisplayData.item((String)"bucket", (String)this.connectionConfiguration().bucket()));
            builder.addIfNotNull(DisplayData.item((String)"chunkSize", (Long)this.chunkSize()));
            builder.addIfNotNull(DisplayData.item((String)"filename", (String)this.filename()));
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            input.apply((PTransform)ParDo.of(new GridFsWriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFilename(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setChunkSize(@UnknownKeyFor @NonNull @Initialized Long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteFn(@UnknownKeyFor @NonNull @Initialized WriteFn<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }

    public static interface WriteFn<@UnknownKeyFor T>
    extends Serializable {
        public void write(T var1, @UnknownKeyFor @NonNull @Initialized OutputStream var2) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized Parser<T> parser();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> coder();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized Duration skew();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized String filter();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> withUri(@UnknownKeyFor @NonNull @Initialized String uri) {
            Preconditions.checkArgumentNotNull((Object)uri);
            ConnectionConfiguration config = ConnectionConfiguration.create(uri, this.connectionConfiguration().database(), this.connectionConfiguration().bucket());
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
            Preconditions.checkArgumentNotNull((Object)database);
            ConnectionConfiguration config = ConnectionConfiguration.create(this.connectionConfiguration().uri(), database, this.connectionConfiguration().bucket());
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withBucket(@UnknownKeyFor @NonNull @Initialized String bucket) {
            Preconditions.checkArgumentNotNull((Object)bucket);
            ConnectionConfiguration config = ConnectionConfiguration.create(this.connectionConfiguration().uri(), this.connectionConfiguration().database(), bucket);
            return this.toBuilder().setConnectionConfiguration(config).build();
        }

        public <X> @UnknownKeyFor @NonNull @Initialized Read<X> withParser(@UnknownKeyFor @NonNull @Initialized Parser<X> parser) {
            Preconditions.checkArgumentNotNull(parser);
            Builder<X> builder = this.toBuilder();
            return builder.setParser(parser).setCoder(null).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(coder);
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withSkew(@UnknownKeyFor @NonNull @Initialized Duration skew) {
            return this.toBuilder().setSkew(skew == null ? Duration.ZERO : skew).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withFilter(@UnknownKeyFor @NonNull @Initialized String filter) {
            return this.toBuilder().setFilter(filter).build();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"uri", (String)this.connectionConfiguration().uri()));
            builder.addIfNotNull(DisplayData.item((String)"database", (String)this.connectionConfiguration().database()));
            builder.addIfNotNull(DisplayData.item((String)"bucket", (String)this.connectionConfiguration().bucket()));
            builder.addIfNotNull(DisplayData.item((String)"parser", (String)(this.parser() == null ? "null" : this.parser().getClass().getName())));
            builder.addIfNotNull(DisplayData.item((String)"coder", (String)(this.coder() == null ? "null" : this.coder().getClass().getName())));
            builder.addIfNotNull(DisplayData.item((String)"skew", (Duration)this.skew()));
            builder.addIfNotNull(DisplayData.item((String)"filter", (String)this.filter()));
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            final BoundedGridFSSource source = new BoundedGridFSSource(this, null);
            Read.Bounded objectIds = org.apache.beam.sdk.io.Read.from((BoundedSource)source);
            PCollection output = (PCollection)((PCollection)input.getPipeline().apply((PTransform)objectIds)).apply((PTransform)ParDo.of((DoFn)new DoFn<ObjectId, T>(){
                @Nullable @UnknownKeyFor @Initialized MongoClient mongo;
                @Nullable @UnknownKeyFor @Initialized GridFS gridfs;

                @DoFn.Setup
                public void setup() {
                    this.mongo = source.spec.connectionConfiguration().setupMongo();
                    this.gridfs = source.spec.connectionConfiguration().setupGridFS(this.mongo);
                }

                @DoFn.Teardown
                public void teardown() {
                    if (this.mongo != null) {
                        this.mongo.close();
                        this.mongo = null;
                    }
                }

                @DoFn.ProcessElement
                public void processElement(final /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                    Preconditions.checkStateNotNull((Object)this.gridfs);
                    ObjectId oid = (ObjectId)c.element();
                    GridFSDBFile file = this.gridfs.find(oid);
                    Parser parser = (Parser)Preconditions.checkStateNotNull(this.parser());
                    parser.parse(file, new ParserCallback<T>(){

                        @Override
                        public void output(T output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                            Preconditions.checkArgumentNotNull((Object)timestamp);
                            c.outputWithTimestamp(output, timestamp);
                        }

                        @Override
                        public void output(T output) {
                            c.output(output);
                        }
                    });
                }

                public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
                    if (this.skew() != null) {
                        return this.skew();
                    }
                    return Duration.ZERO;
                }
            }));
            if (this.coder() != null) {
                output.setCoder(this.coder());
            }
            return output;
        }

        protected static class BoundedGridFSSource
        extends BoundedSource<ObjectId> {
            private /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> spec;
            private @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized ObjectId> objectIds;

            BoundedGridFSSource(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> spec, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized ObjectId> objectIds) {
                this.spec = spec;
                this.objectIds = objectIds;
            }

            private @UnknownKeyFor @NonNull @Initialized DBCursor createCursor(@UnknownKeyFor @NonNull @Initialized GridFS gridfs) {
                if (this.spec.filter() != null) {
                    DBObject query = (DBObject)JSON.parse((String)this.spec.filter());
                    return gridfs.getFileList(query);
                }
                return gridfs.getFileList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized ObjectId>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
                try (MongoClient mongo = this.spec.connectionConfiguration().setupMongo();){
                    GridFS gridfs = this.spec.connectionConfiguration().setupGridFS(mongo);
                    DBCursor cursor = this.createCursor(gridfs);
                    long size = 0L;
                    ArrayList<BoundedGridFSSource> list = new ArrayList<BoundedGridFSSource>();
                    ArrayList<Object> objects = new ArrayList<ObjectId>();
                    while (cursor.hasNext()) {
                        GridFSDBFile file = (GridFSDBFile)cursor.next();
                        long len = file.getLength();
                        if (size + len > desiredBundleSizeBytes && !objects.isEmpty()) {
                            list.add(new BoundedGridFSSource(this.spec, objects));
                            size = 0L;
                            objects = new ArrayList();
                        }
                        objects.add((ObjectId)file.getId());
                        size += len;
                    }
                    if (!objects.isEmpty() || list.isEmpty()) {
                        list.add(new BoundedGridFSSource(this.spec, objects));
                    }
                    ArrayList<BoundedGridFSSource> arrayList = list;
                    return arrayList;
                }
            }

            /*
             * Exception decompiling
             */
            public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized ObjectId> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return new GridFSReader(this, this.objectIds);
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                this.spec.populateDisplayData(builder);
            }

            public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ObjectId> getOutputCoder() {
                return SerializableCoder.of(ObjectId.class);
            }

            private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
                if (x0 != null) {
                    try {
                        x1.close();
                    }
                    catch (Throwable throwable) {
                        x0.addSuppressed(throwable);
                    }
                } else {
                    x1.close();
                }
            }

            static class GridFSReader
            extends BoundedSource.BoundedReader<ObjectId> {
                final @UnknownKeyFor @NonNull @Initialized BoundedGridFSSource source;
                final @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized ObjectId> objects;
                @Nullable @UnknownKeyFor @Initialized MongoClient mongo;
                @Nullable @UnknownKeyFor @Initialized DBCursor cursor;
                @Nullable @UnknownKeyFor @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ObjectId> iterator;
                @Nullable @UnknownKeyFor @Initialized ObjectId current;

                GridFSReader(@UnknownKeyFor @NonNull @Initialized BoundedGridFSSource source, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized ObjectId> objects) {
                    this.source = source;
                    this.objects = objects;
                }

                public @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized ObjectId> getCurrentSource() {
                    return this.source;
                }

                public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    if (this.objects == null) {
                        this.mongo = this.source.spec.connectionConfiguration().setupMongo();
                        GridFS gridfs = this.source.spec.connectionConfiguration().setupGridFS(this.mongo);
                        this.cursor = this.source.createCursor(gridfs);
                    } else {
                        this.iterator = this.objects.iterator();
                    }
                    return this.advance();
                }

                public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        this.current = this.iterator.next();
                        return true;
                    }
                    if (this.cursor != null && this.cursor.hasNext()) {
                        GridFSDBFile file = (GridFSDBFile)this.cursor.next();
                        this.current = (ObjectId)file.getId();
                        return true;
                    }
                    this.current = null;
                    return false;
                }

                public @UnknownKeyFor @NonNull @Initialized ObjectId getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    return this.current;
                }

                public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    long time = this.current.getTimestamp();
                    return new Instant(time *= 1000L);
                }

                public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    if (this.mongo != null) {
                        this.mongo.close();
                    }
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParser(@UnknownKeyFor @NonNull @Initialized Parser<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@Nullable @UnknownKeyFor @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSkew(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFilter(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }

    @AutoValue
    public static abstract class ConnectionConfiguration
    implements Serializable {
        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized String uri();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized String database();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized String bucket();

        static @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration create() {
            return new AutoValue_MongoDbGridFSIO_ConnectionConfiguration(null, null, null);
        }

        static @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration create(@Nullable @UnknownKeyFor @Initialized String uri, @Nullable @UnknownKeyFor @Initialized String database, @Nullable @UnknownKeyFor @Initialized String bucket) {
            return new AutoValue_MongoDbGridFSIO_ConnectionConfiguration(uri, database, bucket);
        }

        @UnknownKeyFor @NonNull @Initialized MongoClient setupMongo() {
            return this.uri() == null ? new MongoClient() : new MongoClient(new MongoClientURI(this.uri()));
        }

        @UnknownKeyFor @NonNull @Initialized GridFS setupGridFS(@UnknownKeyFor @NonNull @Initialized MongoClient mongo) {
            DB db = this.database() == null ? mongo.getDB("gridfs") : mongo.getDB(this.database());
            return this.bucket() == null ? new GridFS(db) : new GridFS(db, this.bucket());
        }
    }

    public static interface Parser<@UnknownKeyFor T>
    extends Serializable {
        public void parse(@UnknownKeyFor @NonNull @Initialized GridFSDBFile var1, @UnknownKeyFor @NonNull @Initialized ParserCallback<T> var2) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    public static interface ParserCallback<@UnknownKeyFor T>
    extends Serializable {
        public void output(T var1);

        public void output(T var1, @UnknownKeyFor @NonNull @Initialized Instant var2);
    }
}

