/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.common.base.Preconditions;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.util.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbGridFSIO_Read;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.bson.types.ObjectId;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class MongoDbGridFSIO {
    private static final Parser<String> TEXT_PARSER = new Parser<String>(){

        @Override
        public void parse(GridFSDBFile input, ParserCallback<String> callback) throws IOException {
            Instant time = new Instant(input.getUploadDate().getTime());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    callback.output(line, time);
                    line = reader.readLine();
                }
            }
        }
    };

    public static Read<String> read() {
        return new AutoValue_MongoDbGridFSIO_Read.Builder().build().withParser(TEXT_PARSER).withCoder((Coder<String>)StringUtf8Coder.of());
    }

    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract String uri();

        @Nullable
        abstract String database();

        @Nullable
        abstract String bucket();

        @Nullable
        abstract Parser<T> parser();

        @Nullable
        abstract Coder<T> coder();

        @Nullable
        abstract Duration skew();

        @Nullable
        abstract String filter();

        abstract Builder<T> toBuilder();

        public Read<T> withUri(String uri) {
            Preconditions.checkNotNull((Object)uri);
            return this.toBuilder().setUri(uri).build();
        }

        public Read<T> withDatabase(String database) {
            Preconditions.checkNotNull((Object)database);
            return this.toBuilder().setDatabase(database).build();
        }

        public Read<T> withBucket(String bucket) {
            Preconditions.checkNotNull((Object)bucket);
            return this.toBuilder().setBucket(bucket).build();
        }

        public <X> Read<X> withParser(Parser<X> parser) {
            Preconditions.checkNotNull(parser);
            Builder<X> builder = this.toBuilder();
            return builder.setParser(parser).setCoder(null).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkNotNull(coder);
            return this.toBuilder().setCoder(coder).build();
        }

        public Read<T> withSkew(Duration skew) {
            return this.toBuilder().setSkew(skew == null ? Duration.ZERO : skew).build();
        }

        public Read<T> withFilter(String filter) {
            return this.toBuilder().setFilter(filter).build();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"uri", (String)this.uri()));
            builder.addIfNotNull(DisplayData.item((String)"database", (String)this.database()));
            builder.addIfNotNull(DisplayData.item((String)"bucket", (String)this.bucket()));
            builder.addIfNotNull(DisplayData.item((String)"parser", (String)this.parser().getClass().getName()));
            builder.addIfNotNull(DisplayData.item((String)"coder", (String)this.coder().getClass().getName()));
            builder.addIfNotNull(DisplayData.item((String)"skew", (Duration)this.skew()));
            builder.addIfNotNull(DisplayData.item((String)"filter", (String)this.filter()));
        }

        public PCollection<T> apply(PBegin input) {
            final BoundedGridFSSource source = new BoundedGridFSSource(this, null);
            Read.Bounded objectIds = org.apache.beam.sdk.io.Read.from((BoundedSource)source);
            PCollection output = (PCollection)((PCollection)input.getPipeline().apply((PTransform)objectIds)).apply((PTransform)ParDo.of((DoFn)new DoFn<ObjectId, T>(){
                Mongo mongo;
                GridFS gridfs;

                @DoFn.Setup
                public void setup() {
                    this.mongo = source.setupMongo();
                    this.gridfs = source.setupGridFS(this.mongo);
                }

                @DoFn.Teardown
                public void teardown() {
                    this.mongo.close();
                }

                @DoFn.ProcessElement
                public void processElement(final DoFn.ProcessContext c) throws IOException {
                    ObjectId oid = (ObjectId)c.element();
                    GridFSDBFile file = this.gridfs.find(oid);
                    Read.this.parser().parse(file, new ParserCallback<T>(){

                        @Override
                        public void output(T output, Instant timestamp) {
                            Preconditions.checkNotNull((Object)timestamp);
                            c.outputWithTimestamp(output, timestamp);
                        }

                        @Override
                        public void output(T output) {
                            c.output(output);
                        }
                    });
                }

                public Duration getAllowedTimestampSkew() {
                    return Read.this.skew();
                }
            }));
            if (this.coder() != null) {
                output.setCoder(this.coder());
            }
            return output;
        }

        protected static class BoundedGridFSSource
        extends BoundedSource<ObjectId> {
            private Read spec;
            @Nullable
            private List<ObjectId> objectIds;

            BoundedGridFSSource(Read spec, List<ObjectId> objectIds) {
                this.spec = spec;
                this.objectIds = objectIds;
            }

            private Mongo setupMongo() {
                return this.spec.uri() == null ? new Mongo() : new Mongo(new MongoURI(this.spec.uri()));
            }

            private GridFS setupGridFS(Mongo mongo) {
                DB db = this.spec.database() == null ? mongo.getDB("gridfs") : mongo.getDB(this.spec.database());
                return this.spec.bucket() == null ? new GridFS(db) : new GridFS(db, this.spec.bucket());
            }

            private DBCursor createCursor(GridFS gridfs) {
                if (this.spec.filter() != null) {
                    DBObject query = (DBObject)JSON.parse((String)this.spec.filter());
                    return gridfs.getFileList(query).sort(null);
                }
                return gridfs.getFileList().sort(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<? extends BoundedSource<ObjectId>> splitIntoBundles(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
                try (Mongo mongo = this.setupMongo();){
                    GridFS gridfs = this.setupGridFS(mongo);
                    DBCursor cursor = this.createCursor(gridfs);
                    long size = 0L;
                    ArrayList<BoundedGridFSSource> list = new ArrayList<BoundedGridFSSource>();
                    ArrayList<Object> objects = new ArrayList<ObjectId>();
                    while (cursor.hasNext()) {
                        GridFSDBFile file = (GridFSDBFile)cursor.next();
                        long len = file.getLength();
                        if (size + len > desiredBundleSizeBytes && !objects.isEmpty()) {
                            list.add(new BoundedGridFSSource(this.spec, objects));
                            size = 0L;
                            objects = new ArrayList();
                        }
                        objects.add((ObjectId)file.getId());
                        size += len;
                    }
                    if (!objects.isEmpty() || list.isEmpty()) {
                        list.add(new BoundedGridFSSource(this.spec, objects));
                    }
                    ArrayList<BoundedGridFSSource> arrayList = list;
                    return arrayList;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
                try (Mongo mongo = this.setupMongo();){
                    GridFS gridfs = this.setupGridFS(mongo);
                    DBCursor cursor = this.createCursor(gridfs);
                    long size = 0L;
                    while (cursor.hasNext()) {
                        GridFSDBFile file = (GridFSDBFile)cursor.next();
                        size += file.getLength();
                    }
                    long l = size;
                    return l;
                }
            }

            public boolean producesSortedKeys(PipelineOptions options) throws Exception {
                return false;
            }

            public BoundedSource.BoundedReader<ObjectId> createReader(PipelineOptions options) throws IOException {
                return new GridFSReader(this, this.objectIds);
            }

            public void validate() {
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                this.spec.populateDisplayData(builder);
            }

            public Coder<ObjectId> getDefaultOutputCoder() {
                return SerializableCoder.of(ObjectId.class);
            }

            static class GridFSReader
            extends BoundedSource.BoundedReader<ObjectId> {
                final BoundedGridFSSource source;
                @Nullable
                final List<ObjectId> objects;
                Mongo mongo;
                DBCursor cursor;
                Iterator<ObjectId> iterator;
                ObjectId current;

                GridFSReader(BoundedGridFSSource source, List<ObjectId> objects) {
                    this.source = source;
                    this.objects = objects;
                }

                public BoundedSource<ObjectId> getCurrentSource() {
                    return this.source;
                }

                public boolean start() throws IOException {
                    if (this.objects == null) {
                        this.mongo = this.source.setupMongo();
                        GridFS gridfs = this.source.setupGridFS(this.mongo);
                        this.cursor = this.source.createCursor(gridfs);
                    } else {
                        this.iterator = this.objects.iterator();
                    }
                    return this.advance();
                }

                public boolean advance() throws IOException {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        this.current = this.iterator.next();
                        return true;
                    }
                    if (this.cursor != null && this.cursor.hasNext()) {
                        GridFSDBFile file = (GridFSDBFile)this.cursor.next();
                        this.current = (ObjectId)file.getId();
                        return true;
                    }
                    this.current = null;
                    return false;
                }

                public ObjectId getCurrent() throws NoSuchElementException {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    return this.current;
                }

                public Instant getCurrentTimestamp() throws NoSuchElementException {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    long time = this.current.getTimestamp();
                    return new Instant(time *= 1000L);
                }

                public void close() throws IOException {
                    if (this.mongo != null) {
                        this.mongo.close();
                    }
                }
            }
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setUri(String var1);

            abstract Builder<T> setDatabase(String var1);

            abstract Builder<T> setBucket(String var1);

            abstract Builder<T> setParser(Parser<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setSkew(Duration var1);

            abstract Builder<T> setFilter(String var1);

            abstract Read<T> build();
        }
    }

    public static interface Parser<T>
    extends Serializable {
        public void parse(GridFSDBFile var1, ParserCallback<T> var2) throws IOException;
    }

    public static interface ParserCallback<T>
    extends Serializable {
        public void output(T var1);

        public void output(T var1, Instant var2);
    }
}

