/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.beam.sdk.io.kafka.KafkaSourceDescriptor;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class KafkaIOUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Random RANDOM = new Random();
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> DEFAULT_CONSUMER_PROPERTIES = ImmutableMap.of((Object)"key.deserializer", (Object)ByteArrayDeserializer.class.getName(), (Object)"value.deserializer", (Object)ByteArrayDeserializer.class.getName(), (Object)"receive.buffer.bytes", (Object)524288, (Object)"auto.offset.reset", (Object)"latest", (Object)"enable.auto.commit", (Object)false);
    public static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> DISALLOWED_CONSUMER_PROPERTIES = ImmutableMap.of((Object)"key.deserializer", (Object)"Set keyDeserializer instead", (Object)"value.deserializer", (Object)"Set valueDeserializer instead");
    static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> KAFKA_CONSUMER_FACTORY_FN = KafkaConsumer::new;

    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> updateKafkaProperties(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> currentConfig, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> updates) {
        for (String key : updates.keySet()) {
            Preconditions.checkArgument((!DISALLOWED_CONSUMER_PROPERTIES.containsKey(key) ? 1 : 0) != 0, (String)"No need to configure '%s'. %s", (Object)key, (Object)DISALLOWED_CONSUMER_PROPERTIES.get(key));
        }
        HashMap<String, Object> config = new HashMap<String, Object>(currentConfig);
        config.putAll(updates);
        return config;
    }

    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getOffsetConsumerConfig(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> offsetConfig, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> consumerConfig) {
        HashMap<String, Object> offsetConsumerConfig = new HashMap<String, Object>(consumerConfig);
        offsetConsumerConfig.put("enable.auto.commit", false);
        Object groupId = consumerConfig.get("group.id");
        String offsetGroupId = String.format("%s_offset_consumer_%d_%s", name, RANDOM.nextInt(Integer.MAX_VALUE), groupId == null ? "none" : groupId);
        offsetConsumerConfig.put("group.id", offsetGroupId);
        if (offsetConfig != null) {
            offsetConsumerConfig.putAll(offsetConfig);
        }
        offsetConsumerConfig.put("isolation.level", "read_uncommitted");
        return offsetConsumerConfig;
    }

    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> overrideBootstrapServersConfig(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> currentConfig, @UnknownKeyFor @NonNull @Initialized KafkaSourceDescriptor description) {
        Preconditions.checkState((currentConfig.containsKey("bootstrap.servers") || description.getBootStrapServers() != null ? 1 : 0) != 0);
        HashMap<String, Object> config = new HashMap<String, Object>(currentConfig);
        if (description.getBootStrapServers() != null && description.getBootStrapServers().size() > 0) {
            config.put("bootstrap.servers", String.join((CharSequence)",", description.getBootStrapServers()));
        }
        return config;
    }

    static final class OffsetBasedDeduplication {
        OffsetBasedDeduplication() {
        }

        static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodeOffset(@UnknownKeyFor @NonNull @Initialized long offset) {
            return Longs.toByteArray((long)offset);
        }

        static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getUniqueId(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized int partition, @UnknownKeyFor @NonNull @Initialized long offset) {
            return (topic + "-" + partition + "-" + offset).getBytes(StandardCharsets.UTF_8);
        }
    }

    public static final class MovingAvg {
        private static final @UnknownKeyFor @NonNull @Initialized AtomicLongFieldUpdater<@UnknownKeyFor @NonNull @Initialized MovingAvg> AVG = AtomicLongFieldUpdater.newUpdater(MovingAvg.class, "avg");
        private static final @UnknownKeyFor @NonNull @Initialized int MOVING_AVG_WINDOW = 1000;
        private volatile @UnknownKeyFor @NonNull @Initialized long avg;
        private @UnknownKeyFor @NonNull @Initialized long numUpdates;

        private @UnknownKeyFor @NonNull @Initialized double getAvg() {
            return Double.longBitsToDouble(this.avg);
        }

        private void setAvg(@UnknownKeyFor @NonNull @Initialized double value) {
            AVG.lazySet(this, Double.doubleToRawLongBits(value));
        }

        private @UnknownKeyFor @NonNull @Initialized long incrementAndGetNumUpdates() {
            long nextNumUpdates;
            this.numUpdates = nextNumUpdates = Math.min(1000L, this.numUpdates + 1L);
            return nextNumUpdates;
        }

        public void update(@UnknownKeyFor @NonNull @Initialized double quantity) {
            double prevAvg = this.getAvg();
            long nextNumUpdates = this.incrementAndGetNumUpdates();
            double nextAvg = prevAvg + (quantity - prevAvg) / (double)nextNumUpdates;
            this.setAvg(nextAvg);
        }

        public @UnknownKeyFor @NonNull @Initialized double get() {
            return this.getAvg();
        }
    }
}

