/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsumerSpEL {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ConsumerSpEL.class);
    private static @UnknownKeyFor @NonNull @Initialized boolean hasRecordTimestamp;
    private static @UnknownKeyFor @NonNull @Initialized boolean hasHeaders;
    private static @UnknownKeyFor @NonNull @Initialized boolean hasOffsetsForTimes;
    private static @UnknownKeyFor @NonNull @Initialized boolean deserializerSupportsHeaders;

    ConsumerSpEL() {
    }

    public static @UnknownKeyFor @NonNull @Initialized long getRecordTimestamp(@UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord) {
        if (hasRecordTimestamp) {
            return rawRecord.timestamp();
        }
        return -1L;
    }

    public static @UnknownKeyFor @NonNull @Initialized KafkaTimestampType getRecordTimestampType(@UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord) {
        if (hasRecordTimestamp) {
            return KafkaTimestampType.forOrdinal(rawRecord.timestampType().ordinal());
        }
        return KafkaTimestampType.NO_TIMESTAMP_TYPE;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasOffsetsForTimes() {
        return hasOffsetsForTimes;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasHeaders() {
        return hasHeaders;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean deserializerSupportsHeaders() {
        return deserializerSupportsHeaders;
    }

    public static <T> T deserializeKey(@UnknownKeyFor @NonNull @Initialized Deserializer<T> deserializer, @UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord) {
        if (deserializerSupportsHeaders) {
            return (T)deserializer.deserialize(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.key());
        }
        return (T)deserializer.deserialize(rawRecord.topic(), (byte[])rawRecord.key());
    }

    public static <T> T deserializeValue(@UnknownKeyFor @NonNull @Initialized Deserializer<T> deserializer, @UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord) {
        if (deserializerSupportsHeaders) {
            return (T)deserializer.deserialize(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.value());
        }
        return (T)deserializer.deserialize(rawRecord.topic(), (byte[])rawRecord.value());
    }

    public static @UnknownKeyFor @NonNull @Initialized long offsetForTime(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> consumer, @UnknownKeyFor @NonNull @Initialized TopicPartition topicPartition, @UnknownKeyFor @NonNull @Initialized Instant time) {
        Preconditions.checkArgument((boolean)hasOffsetsForTimes, (Object)"This Kafka Client must support Consumer.OffsetsForTimes().");
        OffsetAndTimestamp offsetAndTimestamp = (OffsetAndTimestamp)Iterables.getOnlyElement(consumer.offsetsForTimes((Map)ImmutableMap.of((Object)topicPartition, (Object)time.getMillis())).values());
        if (offsetAndTimestamp == null) {
            throw new RuntimeException("There are no messages has a timestamp that is greater than or equals to the target time or the message format version in this partition is before 0.10.0, topicPartition is: " + topicPartition);
        }
        return offsetAndTimestamp.offset();
    }

    static {
        try {
            hasRecordTimestamp = ConsumerRecord.class.getMethod("timestamp", null).getReturnType().equals(Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Timestamp for Kafka message is not available.");
        }
        try {
            hasHeaders = "org.apache.kafka.common.header.Headers".equals(ConsumerRecord.class.getMethod("headers", null).getReturnType().getName());
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Headers is not available");
        }
        try {
            hasOffsetsForTimes = Consumer.class.getMethod("offsetsForTimes", Map.class).getReturnType().equals(Map.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("OffsetsForTimes is not available.");
        }
        try {
            deserializerSupportsHeaders = "T".equals(Deserializer.class.getDeclaredMethod("deserialize", String.class, Headers.class, byte[].class).getGenericReturnType().getTypeName());
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Deserializer interface does not support Kafka headers");
        }
    }
}

