/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.checkerframework.checker.nullness.qual.Nullable;

final class KafkaIOUtils {
    static final Map<String, Object> DEFAULT_CONSUMER_PROPERTIES = ImmutableMap.of((Object)"key.deserializer", (Object)ByteArrayDeserializer.class.getName(), (Object)"value.deserializer", (Object)ByteArrayDeserializer.class.getName(), (Object)"receive.buffer.bytes", (Object)524288, (Object)"auto.offset.reset", (Object)"latest", (Object)"enable.auto.commit", (Object)false);
    static final Map<String, String> DISALLOWED_CONSUMER_PROPERTIES = ImmutableMap.of((Object)"key.deserializer", (Object)"Set keyDeserializer instead", (Object)"value.deserializer", (Object)"Set valueDeserializer instead");
    static final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> KAFKA_CONSUMER_FACTORY_FN = KafkaConsumer::new;

    KafkaIOUtils() {
    }

    static Map<String, Object> updateKafkaProperties(Map<String, Object> currentConfig, Map<String, Object> updates) {
        for (String key : updates.keySet()) {
            Preconditions.checkArgument((!DISALLOWED_CONSUMER_PROPERTIES.containsKey(key) ? 1 : 0) != 0, (String)"No need to configure '%s'. %s", (Object)key, (Object)DISALLOWED_CONSUMER_PROPERTIES.get(key));
        }
        HashMap<String, Object> config = new HashMap<String, Object>(currentConfig);
        config.putAll(updates);
        return config;
    }

    static Map<String, Object> getOffsetConsumerConfig(String name, @Nullable Map<String, Object> offsetConfig, Map<String, Object> consumerConfig) {
        HashMap<String, Object> offsetConsumerConfig = new HashMap<String, Object>(consumerConfig);
        offsetConsumerConfig.put("enable.auto.commit", false);
        Object groupId = consumerConfig.get("group.id");
        String offsetGroupId = String.format("%s_offset_consumer_%d_%s", name, new Random().nextInt(Integer.MAX_VALUE), groupId == null ? "none" : groupId);
        offsetConsumerConfig.put("group.id", offsetGroupId);
        if (offsetConfig != null) {
            offsetConsumerConfig.putAll(offsetConfig);
        }
        offsetConsumerConfig.put("isolation.level", "read_uncommitted");
        return offsetConsumerConfig;
    }

    static class MovingAvg {
        private static final int MOVING_AVG_WINDOW = 1000;
        private double avg = 0.0;
        private long numUpdates = 0L;

        MovingAvg() {
        }

        void update(double quantity) {
            ++this.numUpdates;
            this.avg += (quantity - this.avg) / (double)Math.min(1000L, this.numUpdates);
        }

        double get() {
            return this.avg;
        }
    }
}

