/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;

final class AutoValue_KafkaIO_Write<K, V>
extends KafkaIO.Write<K, V> {
    private final String topic;
    private final Map<String, Object> producerConfig;
    private final SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn;
    private final Class<? extends Serializer<K>> keySerializer;
    private final Class<? extends Serializer<V>> valueSerializer;
    private final boolean EOS;
    private final String sinkGroupId;
    private final int numShards;
    private final SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn;

    private AutoValue_KafkaIO_Write(@Nullable String topic, Map<String, Object> producerConfig, @Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn, @Nullable Class<? extends Serializer<K>> keySerializer, @Nullable Class<? extends Serializer<V>> valueSerializer, boolean EOS, @Nullable String sinkGroupId, int numShards, @Nullable SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn) {
        this.topic = topic;
        this.producerConfig = producerConfig;
        this.producerFactoryFn = producerFactoryFn;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.EOS = EOS;
        this.sinkGroupId = sinkGroupId;
        this.numShards = numShards;
        this.consumerFactoryFn = consumerFactoryFn;
    }

    @Override
    @Nullable
    String getTopic() {
        return this.topic;
    }

    @Override
    Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    @Override
    @Nullable
    SerializableFunction<Map<String, Object>, Producer<K, V>> getProducerFactoryFn() {
        return this.producerFactoryFn;
    }

    @Override
    @Nullable
    Class<? extends Serializer<K>> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    @Nullable
    Class<? extends Serializer<V>> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    boolean isEOS() {
        return this.EOS;
    }

    @Override
    @Nullable
    String getSinkGroupId() {
        return this.sinkGroupId;
    }

    @Override
    int getNumShards() {
        return this.numShards;
    }

    @Override
    @Nullable
    SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> getConsumerFactoryFn() {
        return this.consumerFactoryFn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaIO.Write) {
            KafkaIO.Write that = (KafkaIO.Write)((Object)o);
            return (this.topic == null ? that.getTopic() == null : this.topic.equals(that.getTopic())) && this.producerConfig.equals(that.getProducerConfig()) && (this.producerFactoryFn == null ? that.getProducerFactoryFn() == null : this.producerFactoryFn.equals(that.getProducerFactoryFn())) && (this.keySerializer == null ? that.getKeySerializer() == null : this.keySerializer.equals(that.getKeySerializer())) && (this.valueSerializer == null ? that.getValueSerializer() == null : this.valueSerializer.equals(that.getValueSerializer())) && this.EOS == that.isEOS() && (this.sinkGroupId == null ? that.getSinkGroupId() == null : this.sinkGroupId.equals(that.getSinkGroupId())) && this.numShards == that.getNumShards() && (this.consumerFactoryFn == null ? that.getConsumerFactoryFn() == null : this.consumerFactoryFn.equals(that.getConsumerFactoryFn()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.topic == null ? 0 : this.topic.hashCode();
        h *= 1000003;
        h ^= this.producerConfig.hashCode();
        h *= 1000003;
        h ^= this.producerFactoryFn == null ? 0 : this.producerFactoryFn.hashCode();
        h *= 1000003;
        h ^= this.keySerializer == null ? 0 : this.keySerializer.hashCode();
        h *= 1000003;
        h ^= this.valueSerializer == null ? 0 : this.valueSerializer.hashCode();
        h *= 1000003;
        h ^= this.EOS ? 1231 : 1237;
        h *= 1000003;
        h ^= this.sinkGroupId == null ? 0 : this.sinkGroupId.hashCode();
        h *= 1000003;
        h ^= this.numShards;
        h *= 1000003;
        return h ^= this.consumerFactoryFn == null ? 0 : this.consumerFactoryFn.hashCode();
    }

    @Override
    KafkaIO.Write.Builder<K, V> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<K, V>
    extends KafkaIO.Write.Builder<K, V> {
        private String topic;
        private Map<String, Object> producerConfig;
        private SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn;
        private Class<? extends Serializer<K>> keySerializer;
        private Class<? extends Serializer<V>> valueSerializer;
        private Boolean EOS;
        private String sinkGroupId;
        private Integer numShards;
        private SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn;

        Builder() {
        }

        private Builder(KafkaIO.Write<K, V> source) {
            this.topic = source.getTopic();
            this.producerConfig = source.getProducerConfig();
            this.producerFactoryFn = source.getProducerFactoryFn();
            this.keySerializer = source.getKeySerializer();
            this.valueSerializer = source.getValueSerializer();
            this.EOS = source.isEOS();
            this.sinkGroupId = source.getSinkGroupId();
            this.numShards = source.getNumShards();
            this.consumerFactoryFn = source.getConsumerFactoryFn();
        }

        @Override
        KafkaIO.Write.Builder<K, V> setTopic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setProducerConfig(Map<String, Object> producerConfig) {
            if (producerConfig == null) {
                throw new NullPointerException("Null producerConfig");
            }
            this.producerConfig = producerConfig;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setProducerFactoryFn(@Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn) {
            this.producerFactoryFn = producerFactoryFn;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setKeySerializer(@Nullable Class<? extends Serializer<K>> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setValueSerializer(@Nullable Class<? extends Serializer<V>> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setEOS(boolean EOS) {
            this.EOS = EOS;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setSinkGroupId(@Nullable String sinkGroupId) {
            this.sinkGroupId = sinkGroupId;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setNumShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setConsumerFactoryFn(@Nullable SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn) {
            this.consumerFactoryFn = consumerFactoryFn;
            return this;
        }

        @Override
        KafkaIO.Write<K, V> build() {
            String missing = "";
            if (this.producerConfig == null) {
                missing = missing + " producerConfig";
            }
            if (this.EOS == null) {
                missing = missing + " EOS";
            }
            if (this.numShards == null) {
                missing = missing + " numShards";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaIO_Write(this.topic, this.producerConfig, this.producerFactoryFn, this.keySerializer, this.valueSerializer, this.EOS, this.sinkGroupId, this.numShards, this.consumerFactoryFn);
        }
    }
}

