/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.kafka.common.serialization.Deserializer;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ConfluentSchemaRegistryDeserializerProvider<T>
implements DeserializerProvider<T> {
    private final SerializableFunction<Void, SchemaRegistryClient> schemaRegistryClientProviderFn;
    private final String schemaRegistryUrl;
    private final String subject;
    private final @Nullable Integer version;

    @VisibleForTesting
    ConfluentSchemaRegistryDeserializerProvider(SerializableFunction<Void, SchemaRegistryClient> schemaRegistryClientProviderFn, String schemaRegistryUrl, String subject, @Nullable Integer version) {
        Preconditions.checkArgument((schemaRegistryClientProviderFn != null ? 1 : 0) != 0, (Object)"You should provide a schemaRegistryClientProviderFn.");
        Preconditions.checkArgument((schemaRegistryUrl != null ? 1 : 0) != 0, (Object)"You should provide a schemaRegistryUrl.");
        Preconditions.checkArgument((subject != null ? 1 : 0) != 0, (Object)"You should provide a subject to fetch the schema from.");
        this.schemaRegistryClientProviderFn = schemaRegistryClientProviderFn;
        this.schemaRegistryUrl = schemaRegistryUrl;
        this.subject = subject;
        this.version = version;
    }

    public static <T> ConfluentSchemaRegistryDeserializerProvider<T> of(String schemaRegistryUrl, String subject) {
        return ConfluentSchemaRegistryDeserializerProvider.of(schemaRegistryUrl, subject, null);
    }

    public static <T> ConfluentSchemaRegistryDeserializerProvider<T> of(String schemaRegistryUrl, String subject, @Nullable Integer version) {
        return new ConfluentSchemaRegistryDeserializerProvider<T>((SerializableFunction<Void, SchemaRegistryClient>)(SerializableFunction & Serializable)input -> new CachedSchemaRegistryClient(schemaRegistryUrl, Integer.MAX_VALUE), schemaRegistryUrl, subject, version);
    }

    @Override
    public Deserializer<T> getDeserializer(Map<String, ?> configs, boolean isKey) {
        ImmutableMap csrConfig = ImmutableMap.builder().putAll(configs).put((Object)"schema.registry.url", (Object)this.schemaRegistryUrl).build();
        KafkaAvroDeserializer deserializer = new KafkaAvroDeserializer(this.getSchemaRegistryClient());
        deserializer.configure((Map)csrConfig, isKey);
        return deserializer;
    }

    @Override
    public Coder<T> getCoder(CoderRegistry coderRegistry) {
        Schema avroSchema = new Schema.Parser().parse(this.getSchemaMetadata().getSchema());
        return AvroCoder.of((Schema)avroSchema);
    }

    private SchemaMetadata getSchemaMetadata() {
        try {
            return this.version == null ? this.getSchemaRegistryClient().getLatestSchemaMetadata(this.subject) : this.getSchemaRegistryClient().getSchemaMetadata(this.subject, this.version.intValue());
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException("Unable to get latest schema metadata for subject: " + this.subject, e);
        }
    }

    private SchemaRegistryClient getSchemaRegistryClient() {
        return (SchemaRegistryClient)this.schemaRegistryClientProviderFn.apply(null);
    }
}

