/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.sdk.values.KV;

public class KafkaRecord<K, V>
implements Serializable {
    private final String topic;
    private final int partition;
    private final long offset;
    private final KV<K, V> kv;
    private final long timestamp;

    public KafkaRecord(String topic, int partition, long offset, long timestamp, K key, V value) {
        this(topic, partition, offset, timestamp, KV.of(key, value));
    }

    public KafkaRecord(String topic, int partition, long offset, long timestamp, KV<K, V> kv) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
        this.kv = kv;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public KV<K, V> getKV() {
        return this.kv;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.topic, this.partition, this.offset, this.timestamp, this.kv});
    }

    public boolean equals(Object obj) {
        if (obj instanceof KafkaRecord) {
            KafkaRecord other = (KafkaRecord)obj;
            return this.topic.equals(other.topic) && this.partition == other.partition && this.offset == other.offset && this.timestamp == other.timestamp && this.kv.equals(other.kv);
        }
        return false;
    }
}

