/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kafka.KafkaUnboundedReader;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Joiner;

@DefaultCoder(value=AvroCoder.class)
public class KafkaCheckpointMark
implements UnboundedSource.CheckpointMark {
    private List<PartitionMark> partitions;
    @AvroIgnore
    private Optional<KafkaUnboundedReader<?, ?>> reader;

    private KafkaCheckpointMark() {
    }

    public KafkaCheckpointMark(List<PartitionMark> partitions, Optional<KafkaUnboundedReader<?, ?>> reader) {
        this.partitions = partitions;
        this.reader = reader;
    }

    public List<PartitionMark> getPartitions() {
        return this.partitions;
    }

    public void finalizeCheckpoint() {
        this.reader.ifPresent(r -> r.finalizeCheckpointMarkAsync(this));
    }

    public String toString() {
        return "KafkaCheckpointMark{partitions=" + Joiner.on((String)",").join(this.partitions) + '}';
    }

    public static class PartitionMark
    implements Serializable {
        private static final long MIN_WATERMARK_MILLIS = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        private String topic;
        private int partition;
        private long nextOffset;
        private long watermarkMillis = MIN_WATERMARK_MILLIS;

        private PartitionMark() {
        }

        public PartitionMark(String topic, int partition, long offset, long watermarkMillis) {
            this.topic = topic;
            this.partition = partition;
            this.nextOffset = offset;
            this.watermarkMillis = watermarkMillis;
        }

        public String getTopic() {
            return this.topic;
        }

        public int getPartition() {
            return this.partition;
        }

        public long getNextOffset() {
            return this.nextOffset;
        }

        public long getWatermarkMillis() {
            return this.watermarkMillis;
        }

        public String toString() {
            return "PartitionMark{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", nextOffset=" + this.nextOffset + ", watermarkMillis=" + this.watermarkMillis + '}';
        }
    }
}

