/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ConsumerSpEL {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerSpEL.class);
    private SpelParserConfiguration config = new SpelParserConfiguration(true, true);
    private ExpressionParser parser = new SpelExpressionParser(this.config);
    private Expression seek2endExpression = this.parser.parseExpression("#consumer.seekToEnd(#tp)");
    private Expression assignExpression = this.parser.parseExpression("#consumer.assign(#tp)");
    private Method timestampMethod;
    private boolean hasRecordTimestamp = false;

    public ConsumerSpEL() {
        try {
            this.timestampMethod = ConsumerRecord.class.getMethod("timestamp", null);
            this.hasRecordTimestamp = this.timestampMethod.getReturnType().equals(Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Timestamp for Kafka message is not available.");
        }
    }

    public void evaluateSeek2End(Consumer consumer, TopicPartition topicPartitions) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", (Object)consumer);
        mapContext.setVariable("tp", (Object)topicPartitions);
        this.seek2endExpression.getValue((EvaluationContext)mapContext);
    }

    public void evaluateAssign(Consumer consumer, Collection<TopicPartition> topicPartitions) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", (Object)consumer);
        mapContext.setVariable("tp", topicPartitions);
        this.assignExpression.getValue((EvaluationContext)mapContext);
    }

    public long getRecordTimestamp(ConsumerRecord<byte[], byte[]> rawRecord) {
        long timestamp;
        try {
            if (!this.hasRecordTimestamp || (timestamp = ((Long)this.timestampMethod.invoke(rawRecord, new Object[0])).longValue()) <= 0L) {
                timestamp = System.currentTimeMillis();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return timestamp;
    }
}

