/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kafka.KafkaCheckpointMark;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.KafkaRecordCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.ExposedByteArrayInputStream;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaIO {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaIO.class);

    public static Read<byte[], byte[]> read() {
        return new Read<byte[], byte[]>(new ArrayList(), new ArrayList(), (Coder)ByteArrayCoder.of(), (Coder)ByteArrayCoder.of(), Read.KAFKA_9_CONSUMER_FACTORY_FN, Read.DEFAULT_CONSUMER_PROPERTIES, Long.MAX_VALUE, null);
    }

    public static Write<byte[], byte[]> write() {
        return new Write<byte[], byte[]>(null, (Coder)ByteArrayCoder.of(), (Coder)ByteArrayCoder.of(), TypedWrite.DEFAULT_PRODUCER_PROPERTIES);
    }

    private static Map<String, Object> updateKafkaProperties(Map<String, Object> currentConfig, Map<String, String> ignoredProperties, Map<String, Object> updates) {
        for (String key : updates.keySet()) {
            Preconditions.checkArgument((!ignoredProperties.containsKey(key) ? 1 : 0) != 0, (String)"No need to configure '%s'. %s", (Object[])new Object[]{key, ignoredProperties.get(key)});
        }
        HashMap<String, Object> config = new HashMap<String, Object>(currentConfig);
        config.putAll(updates);
        return config;
    }

    private KafkaIO() {
    }

    private static String configForKeySerializer() {
        return String.format("beam.coder.based.kafka.%s.serializer", "key");
    }

    private static String configForValueSerializer() {
        return String.format("beam.coder.based.kafka.%s.serializer", "value");
    }

    public static class CoderBasedKafkaSerializer<T>
    implements Serializer<T> {
        private Coder<T> coder = null;
        private static final String CONFIG_FORMAT = "beam.coder.based.kafka.%s.serializer";

        public void configure(Map<String, ?> configs, boolean isKey) {
            String configKey = isKey ? KafkaIO.configForKeySerializer() : KafkaIO.configForValueSerializer();
            this.coder = (Coder)configs.get(configKey);
            Preconditions.checkNotNull(this.coder, (Object)"could not instantiate coder for Kafka serialization");
        }

        public byte[] serialize(String topic, @Nullable T data) {
            if (data == null) {
                return null;
            }
            try {
                return CoderUtils.encodeToByteArray(this.coder, data);
            }
            catch (CoderException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
        }
    }

    private static class KafkaWriter<K, V>
    extends DoFn<KV<K, V>, Void> {
        private final String topic;
        private final Map<String, Object> producerConfig;
        private final Optional<SerializableFunction<Map<String, Object>, Producer<K, V>>> producerFactoryFnOpt;
        private transient Producer<K, V> producer = null;
        private transient Exception sendException = null;
        private transient long numSendFailures = 0L;

        @DoFn.Setup
        public void setup() {
            this.producer = this.producerFactoryFnOpt.isPresent() ? (Producer)((SerializableFunction)this.producerFactoryFnOpt.get()).apply(this.producerConfig) : new KafkaProducer(this.producerConfig);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) throws Exception {
            this.checkForFailures();
            KV kv = (KV)ctx.element();
            this.producer.send(new ProducerRecord(this.topic, kv.getKey(), kv.getValue()), (Callback)new SendCallback());
        }

        @DoFn.FinishBundle
        public void finishBundle(DoFn.Context c) throws IOException {
            this.producer.flush();
            this.checkForFailures();
        }

        @DoFn.Teardown
        public void teardown() {
            this.producer.close();
        }

        KafkaWriter(String topic, Coder<K> keyCoder, Coder<V> valueCoder, Map<String, Object> producerConfig, Optional<SerializableFunction<Map<String, Object>, Producer<K, V>>> producerFactoryFnOpt) {
            this.topic = topic;
            this.producerFactoryFnOpt = producerFactoryFnOpt;
            this.producerConfig = new HashMap<String, Object>(producerConfig);
            this.producerConfig.put(KafkaIO.configForKeySerializer(), keyCoder);
            this.producerConfig.put(KafkaIO.configForValueSerializer(), valueCoder);
        }

        private synchronized void checkForFailures() throws IOException {
            if (this.numSendFailures == 0L) {
                return;
            }
            String msg = String.format("KafkaWriter : failed to send %d records (since last report)", this.numSendFailures);
            Exception e = this.sendException;
            this.sendException = null;
            this.numSendFailures = 0L;
            LOG.warn(msg);
            throw new IOException(msg, e);
        }

        private class SendCallback
        implements Callback {
            private SendCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception == null) {
                    return;
                }
                KafkaWriter kafkaWriter = KafkaWriter.this;
                synchronized (kafkaWriter) {
                    if (KafkaWriter.this.sendException == null) {
                        KafkaWriter.this.sendException = exception;
                    }
                    KafkaWriter.this.numSendFailures++;
                }
                LOG.warn("KafkaWriter send failed : '{}'", (Object)exception.getMessage());
            }
        }
    }

    private static class KafkaValueWrite<V>
    extends PTransform<PCollection<V>, PDone> {
        private final TypedWrite<Void, V> kvWriteTransform;

        private KafkaValueWrite(TypedWrite<Void, V> kvWriteTransform) {
            this.kvWriteTransform = kvWriteTransform;
        }

        public PDone expand(PCollection<V> input) {
            return (PDone)((PCollection)input.apply("Kafka values with default key", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<V, KV<Void, V>>(){

                public KV<Void, V> apply(V element) {
                    return KV.of(null, element);
                }
            }))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), this.kvWriteTransform.valueCoder)).apply(this.kvWriteTransform);
        }
    }

    public static class TypedWrite<K, V>
    extends PTransform<PCollection<KV<K, V>>, PDone> {
        protected final String topic;
        protected final Coder<K> keyCoder;
        protected final Coder<V> valueCoder;
        protected final Optional<SerializableFunction<Map<String, Object>, Producer<K, V>>> producerFactoryFnOpt;
        protected final Map<String, Object> producerConfig;
        private static final Map<String, Object> DEFAULT_PRODUCER_PROPERTIES = ImmutableMap.of((Object)"retries", (Object)3, (Object)"key.serializer", CoderBasedKafkaSerializer.class, (Object)"value.serializer", CoderBasedKafkaSerializer.class);
        private static final Map<String, String> IGNORED_PRODUCER_PROPERTIES = ImmutableMap.of((Object)"key.serializer", (Object)"Set keyCoder instead", (Object)"value.serializer", (Object)"Set valueCoder instead", (Object)KafkaIO.access$2600(), (Object)"Reserved for internal serializer", (Object)KafkaIO.access$2700(), (Object)"Reserved for internal serializer");

        public TypedWrite<K, V> withProducerFactoryFn(SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn) {
            return new TypedWrite<K, V>(this.topic, this.keyCoder, this.valueCoder, this.producerConfig, Optional.of(producerFactoryFn));
        }

        public PTransform<PCollection<V>, PDone> values() {
            return new KafkaValueWrite(this);
        }

        public PDone expand(PCollection<KV<K, V>> input) {
            input.apply((PTransform)ParDo.of(new KafkaWriter<K, V>(this.topic, this.keyCoder, this.valueCoder, this.producerConfig, this.producerFactoryFnOpt)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void validate(PCollection<KV<K, V>> input) {
            Preconditions.checkNotNull((Object)this.producerConfig.get("bootstrap.servers"), (Object)"Kafka bootstrap servers should be set");
            Preconditions.checkNotNull((Object)this.topic, (Object)"Kafka topic should be set");
        }

        protected TypedWrite(String topic, Coder<K> keyCoder, Coder<V> valueCoder, Map<String, Object> producerConfig, Optional<SerializableFunction<Map<String, Object>, Producer<K, V>>> producerFactoryFnOpt) {
            this.topic = topic;
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
            this.producerConfig = producerConfig;
            this.producerFactoryFnOpt = producerFactoryFnOpt;
        }
    }

    public static class Write<K, V>
    extends TypedWrite<K, V> {
        public Write<K, V> withBootstrapServers(String bootstrapServers) {
            return this.updateProducerProperties((Map<String, Object>)ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers));
        }

        public Write<K, V> withTopic(String topic) {
            return new Write<K, V>(topic, this.keyCoder, this.valueCoder, this.producerConfig);
        }

        public <KeyT> Write<KeyT, V> withKeyCoder(Coder<KeyT> keyCoder) {
            return new Write<KeyT, V>(this.topic, keyCoder, this.valueCoder, this.producerConfig);
        }

        public <ValueT> Write<K, ValueT> withValueCoder(Coder<ValueT> valueCoder) {
            return new Write<K, ValueT>(this.topic, this.keyCoder, valueCoder, this.producerConfig);
        }

        public Write<K, V> updateProducerProperties(Map<String, Object> configUpdates) {
            Map config = KafkaIO.updateKafkaProperties(this.producerConfig, TypedWrite.IGNORED_PRODUCER_PROPERTIES, configUpdates);
            return new Write<K, V>(this.topic, this.keyCoder, this.valueCoder, config);
        }

        private Write(String topic, Coder<K> keyCoder, Coder<V> valueCoder, Map<String, Object> producerConfig) {
            super(topic, keyCoder, valueCoder, producerConfig, Optional.absent());
        }
    }

    private static class UnboundedKafkaReader<K, V>
    extends UnboundedSource.UnboundedReader<KafkaRecord<K, V>> {
        private final UnboundedKafkaSource<K, V> source;
        private final String name;
        private Consumer<byte[], byte[]> consumer;
        private final List<PartitionState> partitionStates;
        private KafkaRecord<K, V> curRecord;
        private Instant curTimestamp;
        private Iterator<PartitionState> curBatch = Collections.emptyIterator();
        private static final Duration KAFKA_POLL_TIMEOUT = Duration.millis((long)1000L);
        private static final Duration NEW_RECORDS_POLL_TIMEOUT = Duration.millis((long)10L);
        private final ExecutorService consumerPollThread = Executors.newSingleThreadExecutor();
        private final SynchronousQueue<ConsumerRecords<byte[], byte[]>> availableRecordsQueue = new SynchronousQueue();
        private AtomicBoolean closed = new AtomicBoolean(false);
        private Consumer<byte[], byte[]> offsetConsumer;
        private final ScheduledExecutorService offsetFetcherThread = Executors.newSingleThreadScheduledExecutor();
        private static final int OFFSET_UPDATE_INTERVAL_SECONDS = 5;
        private static final long UNINITIALIZED_OFFSET = -1L;
        private static Instant initialWatermark = new Instant(Long.MIN_VALUE);
        private static byte[] nullBytes = new byte[0];

        public String toString() {
            return this.name;
        }

        public UnboundedKafkaReader(UnboundedKafkaSource<K, V> source, @Nullable KafkaCheckpointMark checkpointMark) {
            this.source = source;
            this.name = "Reader-" + ((UnboundedKafkaSource)source).id;
            this.partitionStates = ImmutableList.copyOf((Collection)Lists.transform((List)((UnboundedKafkaSource)source).assignedPartitions, (Function)new Function<TopicPartition, PartitionState>(){

                public PartitionState apply(TopicPartition tp) {
                    return new PartitionState(tp, -1L);
                }
            }));
            if (checkpointMark != null) {
                Preconditions.checkState((checkpointMark.getPartitions().size() == ((UnboundedKafkaSource)source).assignedPartitions.size() ? 1 : 0) != 0, (Object)"checkPointMark and assignedPartitions should match");
                for (int i = 0; i < ((UnboundedKafkaSource)source).assignedPartitions.size(); ++i) {
                    KafkaCheckpointMark.PartitionMark ckptMark = checkpointMark.getPartitions().get(i);
                    TopicPartition assigned = (TopicPartition)((UnboundedKafkaSource)source).assignedPartitions.get(i);
                    TopicPartition partition = new TopicPartition(ckptMark.getTopic(), ckptMark.getPartition());
                    Preconditions.checkState((boolean)partition.equals((Object)assigned), (String)"checkpointed partition %s and assigned partition %s don't match", (Object[])new Object[]{partition, assigned});
                    this.partitionStates.get(i).nextOffset = ckptMark.getNextOffset();
                }
            }
        }

        private void consumerPollLoop() {
            while (!this.closed.get()) {
                try {
                    ConsumerRecords records = this.consumer.poll(KAFKA_POLL_TIMEOUT.getMillis());
                    if (records.isEmpty() || this.closed.get()) continue;
                    this.availableRecordsQueue.put((ConsumerRecords<byte[], byte[]>)records);
                }
                catch (InterruptedException e) {
                    LOG.warn("{}: consumer thread is interrupted", (Object)this, (Object)e);
                    break;
                }
                catch (WakeupException e) {
                    // empty catch block
                    break;
                }
            }
            LOG.info("{}: Returning from consumer pool loop", (Object)this);
        }

        private void nextBatch() {
            ConsumerRecords<byte[], byte[]> records;
            this.curBatch = Collections.emptyIterator();
            try {
                records = this.availableRecordsQueue.poll(NEW_RECORDS_POLL_TIMEOUT.getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("{}: Unexpected", (Object)this, (Object)e);
                return;
            }
            if (records == null) {
                return;
            }
            LinkedList<PartitionState> nonEmpty = new LinkedList<PartitionState>();
            for (PartitionState p : this.partitionStates) {
                p.recordIter = records.records(p.topicPartition).iterator();
                if (!p.recordIter.hasNext()) continue;
                nonEmpty.add(p);
            }
            this.curBatch = Iterators.cycle(nonEmpty);
        }

        public boolean start() throws IOException {
            this.consumer = (Consumer)((UnboundedKafkaSource)this.source).consumerFactoryFn.apply((Object)((UnboundedKafkaSource)this.source).consumerConfig);
            this.consumer.assign(((UnboundedKafkaSource)this.source).assignedPartitions);
            for (PartitionState p : this.partitionStates) {
                if (p.nextOffset != -1L) {
                    this.consumer.seek(p.topicPartition, p.nextOffset);
                } else {
                    p.nextOffset = this.consumer.position(p.topicPartition);
                }
                LOG.info("{}: reading from {} starting at offset {}", new Object[]{this.name, p.topicPartition, p.nextOffset});
            }
            this.consumerPollThread.submit(new Runnable(){

                @Override
                public void run() {
                    UnboundedKafkaReader.this.consumerPollLoop();
                }
            });
            Object groupId = ((UnboundedKafkaSource)this.source).consumerConfig.get("group.id");
            String offsetGroupId = String.format("%s_offset_consumer_%d_%s", this.name, new Random().nextInt(Integer.MAX_VALUE), groupId == null ? "none" : groupId);
            HashMap<String, Object> offsetConsumerConfig = new HashMap<String, Object>(((UnboundedKafkaSource)this.source).consumerConfig);
            offsetConsumerConfig.put("group.id", offsetGroupId);
            offsetConsumerConfig.put("enable.auto.commit", false);
            this.offsetConsumer = (Consumer)((UnboundedKafkaSource)this.source).consumerFactoryFn.apply(offsetConsumerConfig);
            this.offsetConsumer.assign(((UnboundedKafkaSource)this.source).assignedPartitions);
            this.offsetFetcherThread.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    UnboundedKafkaReader.this.updateLatestOffsets();
                }
            }, 0L, 5L, TimeUnit.SECONDS);
            this.nextBatch();
            return this.advance();
        }

        public boolean advance() throws IOException {
            while (true) {
                if (this.curBatch.hasNext()) {
                    PartitionState pState = this.curBatch.next();
                    if (!pState.recordIter.hasNext()) {
                        pState.recordIter = Collections.emptyIterator();
                        this.curBatch.remove();
                        continue;
                    }
                    ConsumerRecord rawRecord = (ConsumerRecord)pState.recordIter.next();
                    long expected = pState.nextOffset;
                    long offset = rawRecord.offset();
                    if (offset < expected) {
                        LOG.warn("{}: ignoring already consumed offset {} for {}", new Object[]{this, offset, pState.topicPartition});
                        continue;
                    }
                    if (offset != expected) {
                        LOG.warn("{}: gap in offsets for {} at {}. {} records missing.", new Object[]{this, pState.topicPartition, expected, offset - expected});
                    }
                    if (this.curRecord == null) {
                        LOG.info("{}: first record offset {}", (Object)this.name, (Object)offset);
                    }
                    this.curRecord = null;
                    KafkaRecord record = new KafkaRecord(rawRecord.topic(), rawRecord.partition(), rawRecord.offset(), UnboundedKafkaReader.decode((byte[])rawRecord.key(), ((UnboundedKafkaSource)this.source).keyCoder), UnboundedKafkaReader.decode((byte[])rawRecord.value(), ((UnboundedKafkaSource)this.source).valueCoder));
                    this.curTimestamp = (Instant)((UnboundedKafkaSource)this.source).timestampFn.apply(record);
                    this.curRecord = record;
                    int recordSize = (rawRecord.key() == null ? 0 : ((byte[])rawRecord.key()).length) + (rawRecord.value() == null ? 0 : ((byte[])rawRecord.value()).length);
                    pState.recordConsumed(offset, recordSize);
                    return true;
                }
                this.nextBatch();
                if (!this.curBatch.hasNext()) break;
            }
            return false;
        }

        private static <T> T decode(byte[] bytes, Coder<T> coder) throws IOException {
            byte[] toDecode = bytes == null ? nullBytes : bytes;
            return (T)coder.decode((InputStream)new ExposedByteArrayInputStream(toDecode), Coder.Context.OUTER);
        }

        private void updateLatestOffsets() {
            for (PartitionState p : this.partitionStates) {
                try {
                    this.offsetConsumer.seekToEnd(new TopicPartition[]{p.topicPartition});
                    long offset = this.offsetConsumer.position(p.topicPartition);
                    p.setLatestOffset(offset);
                }
                catch (Exception e) {
                    if (this.closed.get()) break;
                    LOG.warn("{}: exception while fetching latest offset for partition {}. will be retried.", new Object[]{this, p.topicPartition, e});
                    p.setLatestOffset(-1L);
                }
                LOG.debug("{}: latest offset update for {} : {} (consumer offset {}, avg record size {})", new Object[]{this, p.topicPartition, p.latestOffset, p.nextOffset, p.avgRecordSize});
            }
            LOG.debug("{}:  backlog {}", (Object)this, (Object)this.getSplitBacklogBytes());
        }

        public Instant getWatermark() {
            if (this.curRecord == null) {
                LOG.debug("{}: getWatermark() : no records have been read yet.", (Object)this.name);
                return initialWatermark;
            }
            return ((UnboundedKafkaSource)this.source).watermarkFn.isPresent() ? (Instant)((SerializableFunction)((UnboundedKafkaSource)this.source).watermarkFn.get()).apply(this.curRecord) : this.curTimestamp;
        }

        public UnboundedSource.CheckpointMark getCheckpointMark() {
            return new KafkaCheckpointMark((List<KafkaCheckpointMark.PartitionMark>)ImmutableList.copyOf((Collection)Lists.transform(this.partitionStates, (Function)new Function<PartitionState, KafkaCheckpointMark.PartitionMark>(){

                public KafkaCheckpointMark.PartitionMark apply(PartitionState p) {
                    return new KafkaCheckpointMark.PartitionMark(p.topicPartition.topic(), p.topicPartition.partition(), p.nextOffset);
                }
            })));
        }

        public UnboundedSource<KafkaRecord<K, V>, ?> getCurrentSource() {
            return this.source;
        }

        public KafkaRecord<K, V> getCurrent() throws NoSuchElementException {
            return this.curRecord;
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            return this.curTimestamp;
        }

        public long getSplitBacklogBytes() {
            long backlogBytes = 0L;
            for (PartitionState p : this.partitionStates) {
                long pBacklog = p.approxBacklogInBytes();
                if (pBacklog == -1L) {
                    return -1L;
                }
                backlogBytes += pBacklog;
            }
            return backlogBytes;
        }

        public void close() throws IOException {
            this.closed.set(true);
            this.consumerPollThread.shutdown();
            this.offsetFetcherThread.shutdown();
            boolean isShutdown = false;
            while (!isShutdown) {
                this.consumer.wakeup();
                this.offsetConsumer.wakeup();
                this.availableRecordsQueue.poll();
                try {
                    isShutdown = this.consumerPollThread.awaitTermination(10L, TimeUnit.SECONDS) && this.offsetFetcherThread.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                if (isShutdown) continue;
                LOG.warn("An internal thread is taking a long time to shutdown. will retry.");
            }
            Closeables.close(this.offsetConsumer, (boolean)true);
            Closeables.close(this.consumer, (boolean)true);
        }

        private static class PartitionState {
            private final TopicPartition topicPartition;
            private long nextOffset;
            private long latestOffset;
            private Iterator<ConsumerRecord<byte[], byte[]>> recordIter = Collections.emptyIterator();
            private double avgRecordSize = 0.0;
            private static final int movingAvgWindow = 1000;

            PartitionState(TopicPartition partition, long nextOffset) {
                this.topicPartition = partition;
                this.nextOffset = nextOffset;
                this.latestOffset = -1L;
            }

            void recordConsumed(long offset, int size) {
                this.nextOffset = offset + 1L;
                this.avgRecordSize = this.avgRecordSize <= 0.0 ? (double)size : (this.avgRecordSize += ((double)size - this.avgRecordSize) / 1000.0);
            }

            synchronized void setLatestOffset(long latestOffset) {
                this.latestOffset = latestOffset;
            }

            synchronized long approxBacklogInBytes() {
                if (this.latestOffset < 0L || this.nextOffset < 0L) {
                    return -1L;
                }
                return Math.max(0L, (long)((double)(this.latestOffset - this.nextOffset) * this.avgRecordSize));
            }
        }
    }

    private static class UnboundedKafkaSource<K, V>
    extends UnboundedSource<KafkaRecord<K, V>, KafkaCheckpointMark> {
        private final int id;
        private final List<String> topics;
        private final List<TopicPartition> assignedPartitions;
        private final Coder<K> keyCoder;
        private final Coder<V> valueCoder;
        private final SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn;
        private final Optional<SerializableFunction<KafkaRecord<K, V>, Instant>> watermarkFn;
        private SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
        private final Map<String, Object> consumerConfig;

        public UnboundedKafkaSource(int id, List<String> topics, List<TopicPartition> assignedPartitions, Coder<K> keyCoder, Coder<V> valueCoder, @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn, Optional<SerializableFunction<KafkaRecord<K, V>, Instant>> watermarkFn, SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn, Map<String, Object> consumerConfig) {
            this.id = id;
            this.assignedPartitions = assignedPartitions;
            this.topics = topics;
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
            this.timestampFn = timestampFn == null ? new NowTimestampFn() : timestampFn;
            this.watermarkFn = watermarkFn;
            this.consumerFactoryFn = consumerFactoryFn;
            this.consumerConfig = consumerConfig;
        }

        public List<UnboundedKafkaSource<K, V>> generateInitialSplits(int desiredNumSplits, PipelineOptions options) throws Exception {
            int i;
            ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>(this.assignedPartitions);
            if (partitions.isEmpty()) {
                try (Consumer consumer = (Consumer)this.consumerFactoryFn.apply(this.consumerConfig);){
                    for (String topic : this.topics) {
                        for (PartitionInfo p : consumer.partitionsFor(topic)) {
                            partitions.add(new TopicPartition(p.topic(), p.partition()));
                        }
                    }
                }
            }
            Collections.sort(partitions, new Comparator<TopicPartition>(){

                @Override
                public int compare(TopicPartition tp1, TopicPartition tp2) {
                    return ComparisonChain.start().compare((Comparable)((Object)tp1.topic()), (Comparable)((Object)tp2.topic())).compare(tp1.partition(), tp2.partition()).result();
                }
            });
            Preconditions.checkArgument((desiredNumSplits > 0 ? 1 : 0) != 0);
            Preconditions.checkState((partitions.size() > 0 ? 1 : 0) != 0, (Object)"Could not find any partitions. Please check Kafka configuration and topic names");
            int numSplits = Math.min(desiredNumSplits, partitions.size());
            ArrayList assignments = new ArrayList(numSplits);
            for (i = 0; i < numSplits; ++i) {
                assignments.add(new ArrayList());
            }
            for (i = 0; i < partitions.size(); ++i) {
                ((List)assignments.get(i % numSplits)).add(partitions.get(i));
            }
            ArrayList<UnboundedKafkaSource<K, V>> result = new ArrayList<UnboundedKafkaSource<K, V>>(numSplits);
            for (int i2 = 0; i2 < numSplits; ++i2) {
                List assignedToSplit = (List)assignments.get(i2);
                LOG.info("Partitions assigned to split {} (total {}): {}", new Object[]{i2, assignedToSplit.size(), Joiner.on((String)",").join((Iterable)assignedToSplit)});
                result.add(new UnboundedKafkaSource<K, V>(i2, this.topics, assignedToSplit, this.keyCoder, this.valueCoder, this.timestampFn, this.watermarkFn, this.consumerFactoryFn, this.consumerConfig));
            }
            return result;
        }

        public UnboundedKafkaReader<K, V> createReader(PipelineOptions options, KafkaCheckpointMark checkpointMark) {
            if (this.assignedPartitions.isEmpty()) {
                LOG.warn("Looks like generateSplits() is not called. Generate single split.");
                try {
                    return new UnboundedKafkaReader<K, V>(this.generateInitialSplits(1, options).get(0), checkpointMark);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return new UnboundedKafkaReader(this, checkpointMark);
        }

        public Coder<KafkaCheckpointMark> getCheckpointMarkCoder() {
            return AvroCoder.of(KafkaCheckpointMark.class);
        }

        public boolean requiresDeduping() {
            return false;
        }

        public void validate() {
            Preconditions.checkNotNull((Object)this.consumerConfig.get("bootstrap.servers"), (Object)"Kafka bootstrap servers should be set");
            Preconditions.checkArgument((this.topics.size() > 0 || this.assignedPartitions.size() > 0 ? 1 : 0) != 0, (Object)"Kafka topics or topic_partitions are required");
        }

        public Coder<KafkaRecord<K, V>> getDefaultOutputCoder() {
            return KafkaRecordCoder.of(this.keyCoder, this.valueCoder);
        }
    }

    private static class NowTimestampFn<T>
    implements SerializableFunction<T, Instant> {
        private NowTimestampFn() {
        }

        public Instant apply(T input) {
            return Instant.now();
        }
    }

    public static class TypedWithoutMetadata<K, V>
    extends PTransform<PBegin, PCollection<KV<K, V>>> {
        private final TypedRead<K, V> typedRead;

        TypedWithoutMetadata(TypedRead<K, V> read) {
            super("KafkaIO.Read");
            this.typedRead = read;
        }

        public PCollection<KV<K, V>> expand(PBegin begin) {
            return (PCollection)this.typedRead.expand(begin).apply("Remove Kafka Metadata", (PTransform)ParDo.of((DoFn)new DoFn<KafkaRecord<K, V>, KV<K, V>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext ctx) {
                    ctx.output(((KafkaRecord)ctx.element()).getKV());
                }
            }));
        }
    }

    public static class TypedRead<K, V>
    extends PTransform<PBegin, PCollection<KafkaRecord<K, V>>> {
        protected final List<String> topics;
        protected final List<TopicPartition> topicPartitions;
        protected final Coder<K> keyCoder;
        protected final Coder<V> valueCoder;
        @Nullable
        protected final SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn;
        @Nullable
        protected final SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn;
        protected final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
        protected final Map<String, Object> consumerConfig;
        protected final long maxNumRecords;
        protected final Duration maxReadTime;

        public TypedRead<K, V> withTimestampFn2(SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn) {
            Preconditions.checkNotNull(timestampFn);
            return new TypedRead<K, V>(this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, timestampFn, this.watermarkFn, this.consumerFactoryFn, this.consumerConfig, this.maxNumRecords, this.maxReadTime);
        }

        public TypedRead<K, V> withWatermarkFn2(SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn) {
            Preconditions.checkNotNull(watermarkFn);
            return new TypedRead<K, V>(this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, this.timestampFn, watermarkFn, this.consumerFactoryFn, this.consumerConfig, this.maxNumRecords, this.maxReadTime);
        }

        public TypedRead<K, V> withTimestampFn(SerializableFunction<KV<K, V>, Instant> timestampFn) {
            Preconditions.checkNotNull(timestampFn);
            return this.withTimestampFn2(TypedRead.unwrapKafkaAndThen(timestampFn));
        }

        public TypedRead<K, V> withWatermarkFn(SerializableFunction<KV<K, V>, Instant> watermarkFn) {
            Preconditions.checkNotNull(watermarkFn);
            return this.withWatermarkFn2(TypedRead.unwrapKafkaAndThen(watermarkFn));
        }

        public PTransform<PBegin, PCollection<KV<K, V>>> withoutMetadata() {
            return new TypedWithoutMetadata(this);
        }

        public PCollection<KafkaRecord<K, V>> expand(PBegin input) {
            Read.Unbounded unbounded;
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from(this.makeSource());
            if (this.maxNumRecords < Long.MAX_VALUE) {
                transform = unbounded.withMaxNumRecords(this.maxNumRecords);
            } else if (this.maxReadTime != null) {
                transform = unbounded.withMaxReadTime(this.maxReadTime);
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        private TypedRead(List<String> topics, List<TopicPartition> topicPartitions, Coder<K> keyCoder, Coder<V> valueCoder, @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn, @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn, SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn, Map<String, Object> consumerConfig, long maxNumRecords, @Nullable Duration maxReadTime) {
            super("KafkaIO.Read");
            this.topics = topics;
            this.topicPartitions = topicPartitions;
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
            this.timestampFn = timestampFn;
            this.watermarkFn = watermarkFn;
            this.consumerFactoryFn = consumerFactoryFn;
            this.consumerConfig = consumerConfig;
            this.maxNumRecords = maxNumRecords;
            this.maxReadTime = maxReadTime;
        }

        @VisibleForTesting
        UnboundedSource<KafkaRecord<K, V>, KafkaCheckpointMark> makeSource() {
            return new UnboundedKafkaSource<K, V>(-1, this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, this.timestampFn, Optional.fromNullable(this.watermarkFn), this.consumerFactoryFn, this.consumerConfig);
        }

        private static <KeyT, ValueT, OutT> SerializableFunction<KafkaRecord<KeyT, ValueT>, OutT> unwrapKafkaAndThen(final SerializableFunction<KV<KeyT, ValueT>, OutT> fn) {
            return new SerializableFunction<KafkaRecord<KeyT, ValueT>, OutT>(){

                public OutT apply(KafkaRecord<KeyT, ValueT> record) {
                    return fn.apply(record.getKV());
                }
            };
        }
    }

    public static class Read<K, V>
    extends TypedRead<K, V> {
        private static final Map<String, String> IGNORED_CONSUMER_PROPERTIES = ImmutableMap.of((Object)"key.deserializer", (Object)"Set keyCoder instead", (Object)"value.deserializer", (Object)"Set valueCoder instead");
        private static final Map<String, Object> DEFAULT_CONSUMER_PROPERTIES = ImmutableMap.of((Object)"key.deserializer", (Object)ByteArrayDeserializer.class.getName(), (Object)"value.deserializer", (Object)ByteArrayDeserializer.class.getName(), (Object)"receive.buffer.bytes", (Object)524288, (Object)"auto.offset.reset", (Object)"latest", (Object)"enable.auto.commit", (Object)false);
        private static final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> KAFKA_9_CONSUMER_FACTORY_FN = new SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>(){

            public Consumer<byte[], byte[]> apply(Map<String, Object> config) {
                return new KafkaConsumer(config);
            }
        };

        public Read<K, V> withBootstrapServers(String bootstrapServers) {
            return this.updateConsumerProperties((Map<String, Object>)ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers));
        }

        public Read<K, V> withTopics(List<String> topics) {
            Preconditions.checkState((boolean)this.topicPartitions.isEmpty(), (Object)"Only topics or topicPartitions can be set, not both");
            return new Read<K, V>((List<String>)ImmutableList.copyOf(topics), this.topicPartitions, this.keyCoder, this.valueCoder, (SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)this.consumerFactoryFn, this.consumerConfig, this.maxNumRecords, this.maxReadTime);
        }

        public Read<K, V> withTopicPartitions(List<TopicPartition> topicPartitions) {
            Preconditions.checkState((boolean)this.topics.isEmpty(), (Object)"Only topics or topicPartitions can be set, not both");
            return new Read<K, V>(this.topics, (List<TopicPartition>)ImmutableList.copyOf(topicPartitions), this.keyCoder, this.valueCoder, (SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)this.consumerFactoryFn, this.consumerConfig, this.maxNumRecords, this.maxReadTime);
        }

        public <KeyT> Read<KeyT, V> withKeyCoder(Coder<KeyT> keyCoder) {
            return new Read<KeyT, V>(this.topics, this.topicPartitions, keyCoder, this.valueCoder, (SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)this.consumerFactoryFn, this.consumerConfig, this.maxNumRecords, this.maxReadTime);
        }

        public <ValueT> Read<K, ValueT> withValueCoder(Coder<ValueT> valueCoder) {
            return new Read<K, ValueT>(this.topics, this.topicPartitions, this.keyCoder, valueCoder, (SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)this.consumerFactoryFn, this.consumerConfig, this.maxNumRecords, this.maxReadTime);
        }

        public Read<K, V> withConsumerFactoryFn(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn) {
            return new Read<K, V>(this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, consumerFactoryFn, this.consumerConfig, this.maxNumRecords, this.maxReadTime);
        }

        public Read<K, V> updateConsumerProperties(Map<String, Object> configUpdates) {
            Map config = KafkaIO.updateKafkaProperties(this.consumerConfig, Read.IGNORED_CONSUMER_PROPERTIES, configUpdates);
            return new Read<K, V>(this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, (SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)this.consumerFactoryFn, config, this.maxNumRecords, this.maxReadTime);
        }

        public Read<K, V> withMaxNumRecords(long maxNumRecords) {
            return new Read<K, V>(this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, (SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)this.consumerFactoryFn, this.consumerConfig, maxNumRecords, null);
        }

        public Read<K, V> withMaxReadTime(Duration maxReadTime) {
            return new Read<K, V>(this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, (SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)this.consumerFactoryFn, this.consumerConfig, Long.MAX_VALUE, maxReadTime);
        }

        private Read(List<String> topics, List<TopicPartition> topicPartitions, Coder<K> keyCoder, Coder<V> valueCoder, SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn, Map<String, Object> consumerConfig, long maxNumRecords, @Nullable Duration maxReadTime) {
            super(topics, topicPartitions, keyCoder, valueCoder, null, null, consumerFactoryFn, consumerConfig, maxNumRecords, maxReadTime);
        }
    }
}

