/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StandardCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.values.KV;

public class KafkaRecordCoder<K, V>
extends StandardCoder<KafkaRecord<K, V>> {
    private static final StringUtf8Coder stringCoder = StringUtf8Coder.of();
    private static final VarLongCoder longCoder = VarLongCoder.of();
    private static final VarIntCoder intCoder = VarIntCoder.of();
    private final KvCoder<K, V> kvCoder;

    @JsonCreator
    public static KafkaRecordCoder<?, ?> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
        KvCoder kvCoder = KvCoder.of(components);
        return KafkaRecordCoder.of(kvCoder.getKeyCoder(), kvCoder.getValueCoder());
    }

    public static <K, V> KafkaRecordCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new KafkaRecordCoder<K, V>(keyCoder, valueCoder);
    }

    public KafkaRecordCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.kvCoder = KvCoder.of(keyCoder, valueCoder);
    }

    public void encode(KafkaRecord<K, V> value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        Coder.Context nested = context.nested();
        stringCoder.encode(value.getTopic(), outStream, nested);
        intCoder.encode(Integer.valueOf(value.getPartition()), outStream, nested);
        longCoder.encode(Long.valueOf(value.getOffset()), outStream, nested);
        this.kvCoder.encode(value.getKV(), outStream, nested);
    }

    public KafkaRecord<K, V> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        Coder.Context nested = context.nested();
        return new KafkaRecord(stringCoder.decode(inStream, nested), intCoder.decode(inStream, nested), longCoder.decode(inStream, nested), this.kvCoder.decode(inStream, nested));
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return this.kvCoder.getCoderArguments();
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.kvCoder.verifyDeterministic();
    }

    public boolean isRegisterByteSizeObserverCheap(KafkaRecord<K, V> value, Coder.Context context) {
        return this.kvCoder.isRegisterByteSizeObserverCheap(value.getKV(), context);
    }

    public Object structuralValue(KafkaRecord<K, V> value) throws Exception {
        if (this.consistentWithEquals()) {
            return value;
        }
        return new KafkaRecord(value.getTopic(), value.getPartition(), value.getOffset(), (KV)this.kvCoder.structuralValue(value.getKV()));
    }

    public boolean consistentWithEquals() {
        return this.kvCoder.consistentWithEquals();
    }
}

