/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc.providers;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.List;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.sdk.io.jdbc.JdbcWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class WriteToSqlServerSchemaTransformProvider
extends JdbcWriteSchemaTransformProvider {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteToSqlServerSchemaTransformProvider.class);

    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.SQL_SERVER_WRITE);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String description() {
        return this.inheritedDescription("SQL Server", "WriteToSqlServer", "sqlserver", 1433);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String jdbcType() {
        return "mssql";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration configuration) {
        List<String> connectionInitSql;
        String jdbcType = configuration.getJdbcType();
        if (jdbcType != null && !jdbcType.isEmpty() && !jdbcType.equals(this.jdbcType())) {
            LOG.warn("Wrong JDBC type. Expected '{}' but got '{}'. Overriding with '{}'.", new Object[]{this.jdbcType(), jdbcType, this.jdbcType()});
            configuration = configuration.toBuilder().setJdbcType(this.jdbcType()).build();
        }
        if ((connectionInitSql = configuration.getConnectionInitSql()) != null && !connectionInitSql.isEmpty()) {
            throw new IllegalArgumentException("SQL Server does not support connectionInitSql.");
        }
        configuration = configuration.toBuilder().setConnectionInitSql(Collections.emptyList()).build();
        return new SqlServerWriteSchemaTransform(configuration);
    }

    public static class SqlServerWriteSchemaTransform
    extends JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransform {
        public SqlServerWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration config) {
            super(config, "mssql");
            config.validate("mssql");
        }
    }
}

