/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcReadSchemaTransformProvider_JdbcReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class JdbcReadSchemaTransformProvider
extends TypedSchemaTransformProvider<JdbcReadSchemaTransformConfiguration> {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:jdbc_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized String description() {
        return "Read from a JDBC source using a SQL query or by directly accessing a single table.\n\nThis transform can be used to read from a JDBC source using either a given JDBC driver jar and class name, or by using one of the default packaged drivers given a `jdbc_type`.\n\n#### Using a default driver\n\nThis transform comes packaged with drivers for several popular JDBC distributions. The following distributions can be declared as the `jdbc_type`: " + JdbcUtil.JDBC_DRIVER_MAP.keySet().toString().replaceAll("[\\[\\]]", "") + ".\n\nFor example, reading a MySQL source using a SQL query: ::\n    - type: ReadFromJdbc\n      config:\n        jdbc_type: mysql\n        url: \"jdbc:mysql://my-host:3306/database\"\n        query: \"SELECT * FROM table\"\n\n\n**Note**: See the following transforms which are built on top of this transform and simplify this logic for several popular JDBC distributions:\n\n - ReadFromMySql\n - ReadFromPostgres\n - ReadFromOracle\n - ReadFromSqlServer\n\n#### Declaring custom JDBC drivers\n\nIf reading from a JDBC source not listed above, or if it is necessary to use a custom driver not packaged with Beam, one must define a JDBC driver and class name.\n\nFor example, reading a MySQL source table: ::\n    - type: ReadFromJdbc\n      config:\n        driver_jars: \"path/to/some/jdbc.jar\"\n        driver_class_name: \"com.mysql.jdbc.Driver\"\n        url: \"jdbc:mysql://my-host:3306/database\"\n        table: \"my-table\"\n\n#### Connection Properties\n\nConnection properties are properties sent to the Driver used to connect to the JDBC source. For example, to set the character encoding to UTF-8, one could write: ::\n\n    - type: ReadFromJdbc\n      config:\n        connectionProperties: \"characterEncoding=UTF-8;\"\n        ...\nAll properties should be semi-colon-delimited (e.g. \"key1=value1;key2=value2;\")\n";
    }

    protected @UnknownKeyFor @NonNull @Initialized String inheritedDescription(@UnknownKeyFor @NonNull @Initialized String prettyName, @UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized String databaseSchema, @UnknownKeyFor @NonNull @Initialized int defaultJdbcPort) {
        return String.format("Read from a %s source using a SQL query or by directly accessing a single table.%n%nThis is a special case of ReadFromJdbc that includes the necessary %s Driver and classes.%n%nAn example of using %s with SQL query: ::%n%n    - type: %s%n      config:%n        url: \"jdbc:%s://my-host:%d/database\"%n        query: \"SELECT * FROM table\"%n%nIt is also possible to read a table by specifying a table name. For example, the following configuration will perform a read on an entire table: ::%n%n    - type: %s%n      config:%n        url: \"jdbc:%s://my-host:%d/database\"%n        table: \"my-table\"%n%n#### Advanced Usage%n%nIt might be necessary to use a custom JDBC driver that is not packaged with this transform. If that is the case, see ReadFromJdbc which allows for more custom configuration.", prettyName, prettyName, transformName, transformName, databaseSchema, defaultJdbcPort, transformName, databaseSchema, defaultJdbcPort);
    }

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration> configurationClass() {
        return JdbcReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized String jdbcType() {
        return "";
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration configuration) {
        configuration.validate(this.jdbcType());
        return new JdbcReadSchemaTransform(configuration, this.jdbcType());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList("output");
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class JdbcReadSchemaTransformConfiguration
    implements Serializable {
        @SchemaFieldDescription(value="Connection URL for the JDBC source.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getJdbcUrl();

        @SchemaFieldDescription(value="Sets the connection init sql statements used by the Driver. Only MySQL and MariaDB support this.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized String> getConnectionInitSql();

        @SchemaFieldDescription(value="Used to set connection properties passed to the JDBC driver not already defined as standalone parameter (e.g. username and password can be set using parameters above accordingly). Format of the string must be \"key1=value1;key2=value2;\".")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConnectionProperties();

        @SchemaFieldDescription(value="Whether to disable auto commit on read. Defaults to true if not provided. The need for this config varies depending on the database platform. Informix requires this to be set to false while Postgres requires this to be set to true.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Boolean getDisableAutoCommit();

        @SchemaFieldDescription(value="Name of a Java Driver class to use to connect to the JDBC source. For example, \"com.mysql.jdbc.Driver\".")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getDriverClassName();

        @SchemaFieldDescription(value="Comma separated path(s) for the JDBC driver jar(s). This can be a local path or GCS (gs://) path.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getDriverJars();

        @SchemaFieldDescription(value="This method is used to override the size of the data that is going to be fetched and loaded in memory per every database call. It should ONLY be used if the default value throws memory errors.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer getFetchSize();

        @SchemaFieldDescription(value="Type of JDBC source. When specified, an appropriate default Driver will be packaged with the transform. One of mysql, postgres, oracle, or mssql.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getJdbcType();

        @SchemaFieldDescription(value="Name of the table to read from.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getLocation();

        @SchemaFieldDescription(value="Whether to reshuffle the resulting PCollection so results are distributed to all workers.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Boolean getOutputParallelization();

        @SchemaFieldDescription(value="Password for the JDBC source.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getPassword();

        @SchemaFieldDescription(value="SQL query used to query the JDBC source.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getReadQuery();

        @SchemaFieldDescription(value="Username for the JDBC source.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getUsername();

        public void validate() {
            this.validate("");
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized String jdbcType) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
            boolean locationPresent;
            boolean jdbcTypePresent;
            if (Strings.isNullOrEmpty((String)this.getJdbcUrl())) {
                throw new IllegalArgumentException("JDBC URL cannot be blank");
            }
            jdbcType = !Strings.isNullOrEmpty((String)jdbcType) ? jdbcType : this.getJdbcType();
            boolean driverClassNamePresent = !Strings.isNullOrEmpty((String)this.getDriverClassName());
            boolean driverJarsPresent = !Strings.isNullOrEmpty((String)this.getDriverJars());
            boolean bl = jdbcTypePresent = !Strings.isNullOrEmpty((String)jdbcType);
            if (!(driverClassNamePresent || driverJarsPresent || jdbcTypePresent)) {
                throw new IllegalArgumentException("If JDBC type is not specified, then Driver Class Name and Driver Jars must be specified.");
            }
            if (!driverClassNamePresent && !jdbcTypePresent) {
                throw new IllegalArgumentException("One of JDBC Driver class name or JDBC type must be specified.");
            }
            if (jdbcTypePresent && !JdbcUtil.JDBC_DRIVER_MAP.containsKey(Objects.requireNonNull(jdbcType).toLowerCase())) {
                throw new IllegalArgumentException("JDBC type must be one of " + JdbcUtil.JDBC_DRIVER_MAP.keySet());
            }
            boolean readQueryPresent = this.getReadQuery() != null && !"".equals(this.getReadQuery());
            boolean bl2 = locationPresent = this.getLocation() != null && !"".equals(this.getLocation());
            if (readQueryPresent && locationPresent) {
                throw new IllegalArgumentException("Query and Table are mutually exclusive configurations");
            }
            if (!readQueryPresent && !locationPresent) {
                throw new IllegalArgumentException("Either Query or Table must be specified.");
            }
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_JdbcReadSchemaTransformProvider_JdbcReadSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDriverClassName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setJdbcType(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setJdbcUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUsername(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setPassword(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setReadQuery(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionProperties(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionInitSql(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFetchSize(@UnknownKeyFor @NonNull @Initialized Integer var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputParallelization(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDisableAutoCommit(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDriverJars(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration build();
        }
    }

    protected static class JdbcReadSchemaTransform
    extends SchemaTransform
    implements Serializable {
        @UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration config;
        private final @UnknownKeyFor @NonNull @Initialized String jdbcType;

        public JdbcReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration config, @UnknownKeyFor @NonNull @Initialized String jdbcType) {
            this.config = config;
            this.jdbcType = jdbcType;
        }

        protected @UnknownKeyFor @NonNull @Initialized JdbcIO.DataSourceConfiguration dataSourceConfiguration() {
            String driverJars;
            List<String> initialSql;
            String driverClassName = this.config.getDriverClassName();
            if (Strings.isNullOrEmpty((String)driverClassName)) {
                driverClassName = JdbcUtil.JDBC_DRIVER_MAP.get(Objects.requireNonNull(!Strings.isNullOrEmpty((String)this.jdbcType) ? this.jdbcType : this.config.getJdbcType()).toLowerCase());
            }
            JdbcIO.DataSourceConfiguration dsConfig = JdbcIO.DataSourceConfiguration.create(driverClassName, this.config.getJdbcUrl()).withUsername("".equals(this.config.getUsername()) ? null : this.config.getUsername()).withPassword("".equals(this.config.getPassword()) ? null : this.config.getPassword());
            String connectionProperties = this.config.getConnectionProperties();
            if (connectionProperties != null) {
                dsConfig = dsConfig.withConnectionProperties(connectionProperties);
            }
            if ((initialSql = this.config.getConnectionInitSql()) != null && initialSql.size() > 0) {
                dsConfig = dsConfig.withConnectionInitSqls(initialSql);
            }
            if ((driverJars = this.config.getDriverJars()) != null) {
                dsConfig = dsConfig.withDriverJars(this.config.getDriverJars());
            }
            return dsConfig;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Boolean disableAutoCommit;
            Boolean outputParallelization;
            String query = this.config.getReadQuery();
            if (query == null) {
                query = String.format("SELECT * FROM %s", this.config.getLocation());
            }
            JdbcIO.ReadRows readRows = JdbcIO.readRows().withDataSourceConfiguration(this.dataSourceConfiguration()).withQuery(query);
            Integer fetchSize = this.config.getFetchSize();
            if (fetchSize != null && fetchSize > 0) {
                readRows = readRows.withFetchSize(fetchSize);
            }
            if ((outputParallelization = this.config.getOutputParallelization()) != null) {
                readRows = readRows.withOutputParallelization(outputParallelization);
            }
            if ((disableAutoCommit = this.config.getDisableAutoCommit()) != null) {
                readRows = readRows.withDisableAutoCommit(disableAutoCommit);
            }
            return PCollectionRowTuple.of((String)"output", (PCollection)((PCollection)input.getPipeline().apply((PTransform)readRows)));
        }
    }
}

