/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import javax.sql.DataSource;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcReadWithPartitionsHelper;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

final class AutoValue_JdbcIO_ReadWithPartitions<T, PartitionColumnT>
extends JdbcIO.ReadWithPartitions<T, PartitionColumnT> {
    private final @Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn;
    private final  @Nullable JdbcIO.RowMapper<T> rowMapper;
    private final @Nullable Coder<T> coder;
    private final @Nullable Integer numPartitions;
    private final @Nullable String partitionColumn;
    private final int fetchSize;
    private final boolean useBeamSchema;
    private final PartitionColumnT lowerBound;
    private final PartitionColumnT upperBound;
    private final @Nullable String table;
    private final @Nullable TypeDescriptor<PartitionColumnT> partitionColumnType;
    private final @Nullable JdbcReadWithPartitionsHelper<PartitionColumnT> partitionsHelper;
    private final boolean disableAutoCommit;

    private AutoValue_JdbcIO_ReadWithPartitions(@Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn,  @Nullable JdbcIO.RowMapper<T> rowMapper, @Nullable Coder<T> coder, @Nullable Integer numPartitions, @Nullable String partitionColumn, int fetchSize, boolean useBeamSchema, PartitionColumnT lowerBound, PartitionColumnT upperBound, @Nullable String table, @Nullable TypeDescriptor<PartitionColumnT> partitionColumnType, @Nullable JdbcReadWithPartitionsHelper<PartitionColumnT> partitionsHelper, boolean disableAutoCommit) {
        this.dataSourceProviderFn = dataSourceProviderFn;
        this.rowMapper = rowMapper;
        this.coder = coder;
        this.numPartitions = numPartitions;
        this.partitionColumn = partitionColumn;
        this.fetchSize = fetchSize;
        this.useBeamSchema = useBeamSchema;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.table = table;
        this.partitionColumnType = partitionColumnType;
        this.partitionsHelper = partitionsHelper;
        this.disableAutoCommit = disableAutoCommit;
    }

    @Override
    @Pure
    @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn() {
        return this.dataSourceProviderFn;
    }

    @Override
    @Pure
     @Nullable JdbcIO.RowMapper<T> getRowMapper() {
        return this.rowMapper;
    }

    @Override
    @Pure
    @Nullable Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    @Pure
    @Nullable Integer getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    @Pure
    @Nullable String getPartitionColumn() {
        return this.partitionColumn;
    }

    @Override
    @Pure
    int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    @Pure
    boolean getUseBeamSchema() {
        return this.useBeamSchema;
    }

    @Override
    @Pure
    PartitionColumnT getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @Pure
    PartitionColumnT getUpperBound() {
        return this.upperBound;
    }

    @Override
    @Pure
    @Nullable String getTable() {
        return this.table;
    }

    @Override
    @Pure
    @Nullable TypeDescriptor<PartitionColumnT> getPartitionColumnType() {
        return this.partitionColumnType;
    }

    @Override
    @Pure
    @Nullable JdbcReadWithPartitionsHelper<PartitionColumnT> getPartitionsHelper() {
        return this.partitionsHelper;
    }

    @Override
    @Pure
    boolean getDisableAutoCommit() {
        return this.disableAutoCommit;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JdbcIO.ReadWithPartitions) {
            JdbcIO.ReadWithPartitions that = (JdbcIO.ReadWithPartitions)((Object)o);
            return (this.dataSourceProviderFn == null ? that.getDataSourceProviderFn() == null : this.dataSourceProviderFn.equals(that.getDataSourceProviderFn())) && (this.rowMapper == null ? that.getRowMapper() == null : this.rowMapper.equals(that.getRowMapper())) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder())) && (this.numPartitions == null ? that.getNumPartitions() == null : this.numPartitions.equals(that.getNumPartitions())) && (this.partitionColumn == null ? that.getPartitionColumn() == null : this.partitionColumn.equals(that.getPartitionColumn())) && this.fetchSize == that.getFetchSize() && this.useBeamSchema == that.getUseBeamSchema() && (this.lowerBound == null ? that.getLowerBound() == null : this.lowerBound.equals(that.getLowerBound())) && (this.upperBound == null ? that.getUpperBound() == null : this.upperBound.equals(that.getUpperBound())) && (this.table == null ? that.getTable() == null : this.table.equals(that.getTable())) && (this.partitionColumnType == null ? that.getPartitionColumnType() == null : this.partitionColumnType.equals(that.getPartitionColumnType())) && (this.partitionsHelper == null ? that.getPartitionsHelper() == null : this.partitionsHelper.equals(that.getPartitionsHelper())) && this.disableAutoCommit == that.getDisableAutoCommit();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dataSourceProviderFn == null ? 0 : this.dataSourceProviderFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowMapper == null ? 0 : this.rowMapper.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder == null ? 0 : this.coder.hashCode();
        h$ *= 1000003;
        h$ ^= this.numPartitions == null ? 0 : this.numPartitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionColumn == null ? 0 : this.partitionColumn.hashCode();
        h$ *= 1000003;
        h$ ^= this.fetchSize;
        h$ *= 1000003;
        h$ ^= this.useBeamSchema ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.lowerBound == null ? 0 : this.lowerBound.hashCode();
        h$ *= 1000003;
        h$ ^= this.upperBound == null ? 0 : this.upperBound.hashCode();
        h$ *= 1000003;
        h$ ^= this.table == null ? 0 : this.table.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionColumnType == null ? 0 : this.partitionColumnType.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionsHelper == null ? 0 : this.partitionsHelper.hashCode();
        h$ *= 1000003;
        return h$ ^= this.disableAutoCommit ? 1231 : 1237;
    }

    @Override
    JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T, PartitionColumnT>
    extends JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> {
        private @Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private  @Nullable JdbcIO.RowMapper<T> rowMapper;
        private @Nullable Coder<T> coder;
        private @Nullable Integer numPartitions;
        private @Nullable String partitionColumn;
        private Integer fetchSize;
        private Boolean useBeamSchema;
        private PartitionColumnT lowerBound;
        private PartitionColumnT upperBound;
        private @Nullable String table;
        private @Nullable TypeDescriptor<PartitionColumnT> partitionColumnType;
        private @Nullable JdbcReadWithPartitionsHelper<PartitionColumnT> partitionsHelper;
        private Boolean disableAutoCommit;

        Builder() {
        }

        private Builder(JdbcIO.ReadWithPartitions<T, PartitionColumnT> source) {
            this.dataSourceProviderFn = source.getDataSourceProviderFn();
            this.rowMapper = source.getRowMapper();
            this.coder = source.getCoder();
            this.numPartitions = source.getNumPartitions();
            this.partitionColumn = source.getPartitionColumn();
            this.fetchSize = source.getFetchSize();
            this.useBeamSchema = source.getUseBeamSchema();
            this.lowerBound = source.getLowerBound();
            this.upperBound = source.getUpperBound();
            this.table = source.getTable();
            this.partitionColumnType = source.getPartitionColumnType();
            this.partitionsHelper = source.getPartitionsHelper();
            this.disableAutoCommit = source.getDisableAutoCommit();
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setRowMapper(JdbcIO.RowMapper<T> rowMapper) {
            this.rowMapper = rowMapper;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setCoder(Coder<T> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setNumPartitions(int numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setPartitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setUseBeamSchema(boolean useBeamSchema) {
            this.useBeamSchema = useBeamSchema;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setLowerBound(PartitionColumnT lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setUpperBound(PartitionColumnT upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setTable(String table) {
            this.table = table;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setPartitionColumnType(TypeDescriptor<PartitionColumnT> partitionColumnType) {
            this.partitionColumnType = partitionColumnType;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setPartitionsHelper(JdbcReadWithPartitionsHelper<PartitionColumnT> partitionsHelper) {
            this.partitionsHelper = partitionsHelper;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T, PartitionColumnT> setDisableAutoCommit(boolean disableAutoCommit) {
            this.disableAutoCommit = disableAutoCommit;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions<T, PartitionColumnT> build() {
            if (this.fetchSize == null || this.useBeamSchema == null || this.disableAutoCommit == null) {
                StringBuilder missing = new StringBuilder();
                if (this.fetchSize == null) {
                    missing.append(" fetchSize");
                }
                if (this.useBeamSchema == null) {
                    missing.append(" useBeamSchema");
                }
                if (this.disableAutoCommit == null) {
                    missing.append(" disableAutoCommit");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JdbcIO_ReadWithPartitions(this.dataSourceProviderFn, this.rowMapper, this.coder, this.numPartitions, this.partitionColumn, this.fetchSize, this.useBeamSchema, this.lowerBound, this.upperBound, this.table, this.partitionColumnType, this.partitionsHelper, this.disableAutoCommit);
        }
    }
}

