/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;

@AutoService(value=Module.class)
public class HadoopFileSystemModule
extends SimpleModule {
    public HadoopFileSystemModule() {
        super("HadoopFileSystemModule");
        this.setMixInAnnotation(Configuration.class, ConfigurationMixin.class);
    }

    static class ConfigurationSerializer
    extends JsonSerializer<Configuration> {
        ConfigurationSerializer() {
        }

        public void serialize(Configuration configuration, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            TreeMap map = new TreeMap();
            for (Map.Entry entry : configuration) {
                map.put(entry.getKey(), entry.getValue());
            }
            jsonGenerator.writeObject(map);
        }
    }

    static class ConfigurationDeserializer
    extends JsonDeserializer<Configuration> {
        ConfigurationDeserializer() {
        }

        public Configuration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Map rawConfiguration = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            Configuration configuration = new Configuration(false);
            for (Map.Entry entry : rawConfiguration.entrySet()) {
                configuration.set((String)entry.getKey(), (String)entry.getValue());
            }
            return configuration;
        }
    }

    @JsonDeserialize(using=ConfigurationDeserializer.class)
    @JsonSerialize(using=ConfigurationSerializer.class)
    private static class ConfigurationMixin {
        private ConfigurationMixin() {
        }
    }
}

