/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreStub;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.firestore.CounterFactory;
import org.apache.beam.sdk.io.gcp.firestore.DistributionFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreOptions;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosImpl;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Immutable
class FirestoreStatefulComponentFactory
implements Serializable {
    static final @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory INSTANCE = new FirestoreStatefulComponentFactory();

    private FirestoreStatefulComponentFactory() {
    }

    @UnknownKeyFor @NonNull @Initialized FirestoreStub getFirestoreStub(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String configuredProjectId, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String configuredDatabaseId) {
        try {
            FirestoreSettings.Builder builder = FirestoreSettings.newBuilder();
            RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(1).build();
            builder.applyToAllUnaryMethods(b -> {
                b.setRetrySettings(retrySettings);
                return null;
            });
            FirestoreOptions firestoreOptions = (FirestoreOptions)options.as(FirestoreOptions.class);
            String emulatorHostPort = firestoreOptions.getEmulatorHost();
            final ImmutableMap.Builder headers = ImmutableMap.builder();
            headers.put((Object)"User-Agent", (Object)options.getUserAgent());
            if (emulatorHostPort != null) {
                ((FirestoreSettings.Builder)((FirestoreSettings.Builder)builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)new FirestoreOptions.EmulatorCredentials()))).setEndpoint(emulatorHostPort)).setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(emulatorHostPort).setChannelConfigurator(c -> c.usePlaintext()).build());
            } else {
                String projectId;
                GcpOptions gcpOptions = (GcpOptions)options.as(GcpOptions.class);
                ((FirestoreSettings.Builder)builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)gcpOptions.getGcpCredential()))).setEndpoint(firestoreOptions.getFirestoreHost());
                String string = projectId = configuredProjectId != null ? configuredProjectId : firestoreOptions.getFirestoreProject();
                if (projectId == null) {
                    projectId = gcpOptions.getProject();
                }
                String databaseId = configuredDatabaseId != null ? configuredDatabaseId : firestoreOptions.getFirestoreDb();
                headers.put((Object)"x-goog-request-params", (Object)("project_id=" + projectId + "&database_id=" + databaseId));
            }
            builder.setHeaderProvider((HeaderProvider)new FixedHeaderProvider(){

                public @UnknownKeyFor @NonNull @Initialized Map<@NonNull @UnknownKeyFor @Initialized String, @NonNull @UnknownKeyFor @Initialized String> getHeaders() {
                    return headers.build();
                }
            });
            ClientContext clientContext = ClientContext.create((ClientSettings)builder.build());
            return GrpcFirestoreStub.create((ClientContext)clientContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized RpcQos getRpcQos(@UnknownKeyFor @NonNull @Initialized RpcQosOptions options) {
        return new RpcQosImpl(options, new SecureRandom(), Sleeper.DEFAULT, CounterFactory.DEFAULT, DistributionFactory.DEFAULT);
    }
}

