/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BigQueryAvroUtils {
    private static final @UnknownKeyFor @NonNull @Initialized String VERSION_AVRO = Optional.ofNullable(Schema.class.getPackage()).map(Package::getImplementationVersion).orElse("");
    private static final @UnknownKeyFor @NonNull @Initialized String TIMESTAMP_NANOS_LOGICAL_TYPE = "timestamp-nanos";
    static final @UnknownKeyFor @NonNull @Initialized DateTimeLogicalType DATETIME_LOGICAL_TYPE = new DateTimeLogicalType();
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC);
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_MICROS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 6, 6, false).toFormatter();
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_MILLIS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, false).toFormatter();
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_SECONDS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    BigQueryAvroUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized Schema getPrimitiveType(@UnknownKeyFor @NonNull @Initialized TableFieldSchema schema, @UnknownKeyFor @NonNull @Initialized Boolean useAvroLogicalTypes) {
        String bqType;
        switch (bqType = schema.getType()) {
            case "STRING": {
                return (Schema)SchemaBuilder.builder().stringType();
            }
            case "BYTES": {
                return (Schema)SchemaBuilder.builder().bytesType();
            }
            case "INTEGER": 
            case "INT64": {
                return (Schema)SchemaBuilder.builder().longType();
            }
            case "FLOAT": 
            case "FLOAT64": {
                return (Schema)SchemaBuilder.builder().doubleType();
            }
            case "BOOLEAN": 
            case "BOOL": {
                return (Schema)SchemaBuilder.builder().booleanType();
            }
            case "TIMESTAMP": {
                if (schema.getTimestampPrecision() == null || schema.getTimestampPrecision() == 6L) {
                    return LogicalTypes.timestampMicros().addToSchema((Schema)SchemaBuilder.builder().longType());
                }
                return (Schema)((SchemaBuilder.LongBuilder)SchemaBuilder.builder().longBuilder().prop("logicalType", TIMESTAMP_NANOS_LOGICAL_TYPE)).endLong();
            }
            case "DATE": {
                if (useAvroLogicalTypes.booleanValue()) {
                    return LogicalTypes.date().addToSchema((Schema)SchemaBuilder.builder().intType());
                }
                return (Schema)((SchemaBuilder.StringBldr)SchemaBuilder.builder().stringBuilder().prop("sqlType", bqType)).endString();
            }
            case "TIME": {
                if (useAvroLogicalTypes.booleanValue()) {
                    return LogicalTypes.timeMicros().addToSchema((Schema)SchemaBuilder.builder().longType());
                }
                return (Schema)((SchemaBuilder.StringBldr)SchemaBuilder.builder().stringBuilder().prop("sqlType", bqType)).endString();
            }
            case "DATETIME": {
                if (useAvroLogicalTypes.booleanValue()) {
                    return DATETIME_LOGICAL_TYPE.addToSchema((Schema)SchemaBuilder.builder().stringType());
                }
                return (Schema)((SchemaBuilder.StringBldr)SchemaBuilder.builder().stringBuilder().prop("sqlType", bqType)).endString();
            }
            case "NUMERIC": 
            case "BIGNUMERIC": {
                LogicalTypes.Decimal logicalType = schema.getScale() != null ? LogicalTypes.decimal((int)schema.getPrecision().intValue(), (int)schema.getScale().intValue()) : (schema.getPrecision() != null ? LogicalTypes.decimal((int)schema.getPrecision().intValue()) : (bqType.equals("NUMERIC") ? LogicalTypes.decimal((int)38, (int)9) : LogicalTypes.decimal((int)77, (int)38)));
                return logicalType.addToSchema((Schema)SchemaBuilder.builder().bytesType());
            }
            case "GEOGRAPHY": 
            case "JSON": {
                return (Schema)((SchemaBuilder.StringBldr)SchemaBuilder.builder().stringBuilder().prop("sqlType", bqType)).endString();
            }
            case "RECORD": 
            case "STRUCT": {
                throw new IllegalArgumentException("RECORD/STRUCT are not primitive types");
            }
        }
        throw new IllegalArgumentException("Unknown BigQuery type: " + bqType);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String formatDatetime(@UnknownKeyFor @NonNull @Initialized Instant instant) {
        String dateTime = DATE_TIME_FORMATTER.format(instant);
        int nanos = instant.getNano();
        if (nanos == 0) {
            return dateTime;
        }
        if (nanos % 1000000 == 0) {
            return dateTime + String.format(".%03d", nanos / 1000000);
        }
        if (nanos % 1000 == 0) {
            return dateTime + String.format(".%06d", nanos / 1000);
        }
        return dateTime + String.format(".%09d", nanos);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String formatDatetime(@UnknownKeyFor @NonNull @Initialized long epochValue, @UnknownKeyFor @NonNull @Initialized TimestampPrecision precision) {
        return BigQueryAvroUtils.formatDatetime(precision.toInstant(epochValue));
    }

    static @UnknownKeyFor @NonNull @Initialized String formatTimestamp(@UnknownKeyFor @NonNull @Initialized Instant instant) {
        return BigQueryAvroUtils.formatDatetime(instant) + " UTC";
    }

    static @UnknownKeyFor @NonNull @Initialized String formatTimestamp(@UnknownKeyFor @NonNull @Initialized long epochValue, @UnknownKeyFor @NonNull @Initialized TimestampPrecision precision) {
        return BigQueryAvroUtils.formatTimestamp(precision.toInstant(epochValue));
    }

    private static @UnknownKeyFor @NonNull @Initialized String formatDate(@UnknownKeyFor @NonNull @Initialized int date) {
        return LocalDate.ofEpochDay(date).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    private static @UnknownKeyFor @NonNull @Initialized String formatTime(@UnknownKeyFor @NonNull @Initialized long timeMicros) {
        DateTimeFormatter formatter = timeMicros % 1000000L == 0L ? ISO_LOCAL_TIME_FORMATTER_SECONDS : (timeMicros % 1000L == 0L ? ISO_LOCAL_TIME_FORMATTER_MILLIS : ISO_LOCAL_TIME_FORMATTER_MICROS);
        return LocalTime.ofNanoOfDay(timeMicros * 1000L).format(formatter);
    }

    @Deprecated
    static @UnknownKeyFor @NonNull @Initialized TableRow convertGenericRecordToTableRow(@UnknownKeyFor @NonNull @Initialized GenericRecord record, @UnknownKeyFor @NonNull @Initialized TableSchema schema) {
        return BigQueryAvroUtils.convertGenericRecordToTableRow(record);
    }

    static @UnknownKeyFor @NonNull @Initialized TableRow convertGenericRecordToTableRow(@UnknownKeyFor @NonNull @Initialized GenericRecord record) {
        TableRow row = new TableRow();
        Schema schema = record.getSchema();
        for (Schema.Field field : schema.getFields()) {
            Object convertedValue = BigQueryAvroUtils.getTypedCellValue(field.name(), field.schema(), record.get(field.pos()));
            if (convertedValue == null) continue;
            row.set(field.name(), convertedValue);
        }
        return row;
    }

    private static @Nullable @UnknownKeyFor @Initialized Object getTypedCellValue(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Object v) {
        Schema.Type type = schema.getType();
        switch (type) {
            case ARRAY: {
                return BigQueryAvroUtils.convertRepeatedField(name, schema.getElementType(), v);
            }
            case UNION: {
                return BigQueryAvroUtils.convertNullableField(name, schema, v);
            }
            case MAP: {
                return BigQueryAvroUtils.convertMapField(name, schema, v);
            }
        }
        return BigQueryAvroUtils.convertRequiredField(name, schema, v);
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> convertRepeatedField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema elementType, @UnknownKeyFor @NonNull @Initialized Object v) {
        if (v == null) {
            return new ArrayList<Object>();
        }
        List elements = (List)v;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object element : elements) {
            values.add(BigQueryAvroUtils.convertRequiredField(name, elementType, element));
        }
        return values;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> convertMapField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema map, @UnknownKeyFor @NonNull @Initialized Object v) {
        if (v == null) {
            return new ArrayList<TableRow>();
        }
        Schema type = map.getValueType();
        Map elements = (Map)v;
        ArrayList<TableRow> values = new ArrayList<TableRow>();
        for (Map.Entry element : elements.entrySet()) {
            TableRow row = new TableRow().set("key", element.getKey()).set("value", BigQueryAvroUtils.convertRequiredField(name, type, element.getValue()));
            values.add(row);
        }
        return values;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertRequiredField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Object v) {
        Preconditions.checkNotNull((Object)v, (String)"REQUIRED field %s should not be null", (Object)name);
        Schema.Type type = schema.getType();
        LogicalType logicalType = schema.getLogicalType();
        switch (type) {
            case BOOLEAN: {
                return v;
            }
            case INT: {
                if (logicalType instanceof LogicalTypes.Date) {
                    return BigQueryAvroUtils.formatDate((Integer)v);
                }
                if (logicalType instanceof LogicalTypes.TimeMillis) {
                    return BigQueryAvroUtils.formatTime((long)((Integer)v).intValue() * 1000L);
                }
                return ((Integer)v).toString();
            }
            case LONG: {
                if (logicalType instanceof LogicalTypes.TimeMicros) {
                    return BigQueryAvroUtils.formatTime((Long)v);
                }
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    return BigQueryAvroUtils.formatTimestamp((Long)v, TimestampPrecision.MILLISECONDS);
                }
                if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    return BigQueryAvroUtils.formatTimestamp((Long)v, TimestampPrecision.MICROSECONDS);
                }
                if (TIMESTAMP_NANOS_LOGICAL_TYPE.equals(schema.getProp("logicalType"))) {
                    return BigQueryAvroUtils.formatTimestamp((Long)v, TimestampPrecision.NANOSECONDS);
                }
                if (!VERSION_AVRO.startsWith("1.8") && !VERSION_AVRO.startsWith("1.9") && logicalType instanceof LogicalTypes.LocalTimestampMillis) {
                    return BigQueryAvroUtils.formatDatetime((Long)v, TimestampPrecision.MILLISECONDS);
                }
                if (!VERSION_AVRO.startsWith("1.8") && !VERSION_AVRO.startsWith("1.9") && logicalType instanceof LogicalTypes.LocalTimestampMicros) {
                    return BigQueryAvroUtils.formatDatetime((Long)v, TimestampPrecision.MICROSECONDS);
                }
                return ((Long)v).toString();
            }
            case FLOAT: {
                return Double.valueOf(v.toString());
            }
            case DOUBLE: {
                return v;
            }
            case BYTES: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    return new Conversions.DecimalConversion().fromBytes((ByteBuffer)v, schema, logicalType).toString();
                }
                return BaseEncoding.base64().encode(((ByteBuffer)v).array());
            }
            case STRING: {
                return v.toString();
            }
            case ENUM: {
                return v.toString();
            }
            case FIXED: {
                return BaseEncoding.base64().encode(((ByteBuffer)v).array());
            }
            case RECORD: {
                return BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)v);
            }
        }
        throw new UnsupportedOperationException(String.format("Unexpected Avro field schema type %s for field named %s", type, name));
    }

    private static @Nullable @UnknownKeyFor @Initialized Object convertNullableField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema union, @UnknownKeyFor @NonNull @Initialized Object v) {
        Verify.verify((union.getType() == Schema.Type.UNION ? 1 : 0) != 0, (String)"Expected Avro schema type UNION, not %s, for BigQuery NULLABLE field %s", (Object)union.getType(), (Object)name);
        List unionTypes = union.getTypes();
        Verify.verify((unionTypes.size() == 2 ? 1 : 0) != 0, (String)"BigQuery NULLABLE field %s should be an Avro UNION of NULL and another type, not %s", (Object)name, (Object)union);
        Schema type = (Schema)union.getTypes().get(GenericData.get().resolveUnion(union, v));
        if (type.getType() == Schema.Type.NULL) {
            return null;
        }
        return BigQueryAvroUtils.convertRequiredField(name, type, v);
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema toGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized String schemaName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fieldSchemas, @UnknownKeyFor @NonNull @Initialized Boolean useAvroLogicalTypes, @Nullable @UnknownKeyFor @Initialized String namespace) {
        String nextNamespace = namespace == null ? null : String.format("%s.%s", namespace, schemaName);
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (TableFieldSchema bigQueryField : fieldSchemas) {
            avroFields.add(BigQueryAvroUtils.convertField(bigQueryField, useAvroLogicalTypes, nextNamespace));
        }
        return Schema.createRecord((String)schemaName, (String)("Translated Avro Schema for " + schemaName), (String)(namespace == null ? "org.apache.beam.sdk.io.gcp.bigquery" : namespace), (boolean)false, avroFields);
    }

    static @UnknownKeyFor @NonNull @Initialized Schema toGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) {
        return BigQueryAvroUtils.toGenericAvroSchema("root", tableSchema.getFields(), true);
    }

    static @UnknownKeyFor @NonNull @Initialized Schema toGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized Boolean useAvroLogicalTypes) {
        return BigQueryAvroUtils.toGenericAvroSchema("root", tableSchema.getFields(), useAvroLogicalTypes);
    }

    static @UnknownKeyFor @NonNull @Initialized Schema toGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized String schemaName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fieldSchemas, @UnknownKeyFor @NonNull @Initialized Boolean useAvroLogicalTypes) {
        String namespace = BigQueryAvroUtils.hasNamespaceCollision(fieldSchemas) ? "org.apache.beam.sdk.io.gcp.bigquery" : null;
        return BigQueryAvroUtils.toGenericAvroSchema(schemaName, fieldSchemas, useAvroLogicalTypes, namespace);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasNamespaceCollision(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fieldSchemas) {
        HashSet<String> recordTypeFieldNames = new HashSet<String>();
        ArrayList<TableFieldSchema> fieldsToCheck = new ArrayList<TableFieldSchema>();
        fieldsToCheck.addAll(fieldSchemas);
        while (!fieldsToCheck.isEmpty()) {
            TableFieldSchema field = (TableFieldSchema)fieldsToCheck.remove(0);
            if (!"STRUCT".equals(field.getType()) && !"RECORD".equals(field.getType())) continue;
            if (recordTypeFieldNames.contains(field.getName())) {
                return true;
            }
            recordTypeFieldNames.add(field.getName());
            fieldsToCheck.addAll(field.getFields());
        }
        return false;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field convertField(@UnknownKeyFor @NonNull @Initialized TableFieldSchema bigQueryField, @UnknownKeyFor @NonNull @Initialized Boolean useAvroLogicalTypes, @Nullable @UnknownKeyFor @Initialized String namespace) {
        String fieldName = bigQueryField.getName();
        String bqType = bigQueryField.getType();
        Schema fieldSchema = "RECORD".equals(bqType) || "STRUCT".equals(bqType) ? BigQueryAvroUtils.toGenericAvroSchema(fieldName, bigQueryField.getFields(), useAvroLogicalTypes, namespace) : BigQueryAvroUtils.getPrimitiveType(bigQueryField, useAvroLogicalTypes);
        String bqMode = bigQueryField.getMode();
        if (bqMode == null || "NULLABLE".equals(bqMode)) {
            fieldSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().type(fieldSchema)).endUnion();
        } else if ("REPEATED".equals(bqMode)) {
            fieldSchema = (Schema)SchemaBuilder.array().items(fieldSchema);
        } else if (!"REQUIRED".equals(bqMode)) {
            throw new IllegalArgumentException(String.format("Unknown BigQuery Field Mode: %s", bqMode));
        }
        return new Schema.Field(fieldName, fieldSchema, bigQueryField.getDescription(), null);
    }

    static @UnknownKeyFor @NonNull @Initialized TableSchema fromGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return BigQueryAvroUtils.fromGenericAvroSchema(schema, true);
    }

    static @UnknownKeyFor @NonNull @Initialized TableSchema fromGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Boolean useAvroLogicalTypes) {
        Verify.verify((schema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"Expected Avro schema type RECORD, not %s", (Object)schema.getType());
        List fields = schema.getFields().stream().map(f -> BigQueryAvroUtils.fromAvroFieldSchema(f, useAvroLogicalTypes)).collect(Collectors.toList());
        return new TableSchema().setFields(fields);
    }

    private static @UnknownKeyFor @NonNull @Initialized TableFieldSchema fromAvroFieldSchema(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field avrofield, @UnknownKeyFor @NonNull @Initialized Boolean useAvroLogicalTypes) {
        TableFieldSchema field;
        Schema fieldSchema = avrofield.schema();
        switch (fieldSchema.getType()) {
            case UNION: {
                List types = fieldSchema.getTypes();
                Verify.verify((types.size() == 2 && ((Schema)types.get(0)).getType() == Schema.Type.NULL ? 1 : 0) != 0, (String)"Avro union field %s should be of null and another type, not %s", (Object)avrofield.name(), (Object)fieldSchema);
                field = BigQueryAvroUtils.typedTableFieldSchema((Schema)types.get(1), useAvroLogicalTypes).setMode("NULLABLE");
                break;
            }
            case ARRAY: {
                field = BigQueryAvroUtils.typedTableFieldSchema(fieldSchema.getElementType(), useAvroLogicalTypes).setMode("REPEATED");
                break;
            }
            case MAP: {
                TableFieldSchema key = new TableFieldSchema().setType("STRING").setName("key").setMode("REQUIRED");
                TableFieldSchema value = BigQueryAvroUtils.typedTableFieldSchema(fieldSchema.getValueType(), useAvroLogicalTypes).setName("value").setMode("REQUIRED");
                ArrayList<TableFieldSchema> mapTableSchema = new ArrayList<TableFieldSchema>();
                mapTableSchema.add(key);
                mapTableSchema.add(value);
                field = new TableFieldSchema().setType("RECORD").setFields(mapTableSchema).setMode("REPEATED");
                break;
            }
            default: {
                field = BigQueryAvroUtils.typedTableFieldSchema(fieldSchema, useAvroLogicalTypes).setMode("REQUIRED");
            }
        }
        return field.setName(avrofield.name()).setDescription(avrofield.doc());
    }

    private static @UnknownKeyFor @NonNull @Initialized TableFieldSchema typedTableFieldSchema(@UnknownKeyFor @NonNull @Initialized Schema type, @UnknownKeyFor @NonNull @Initialized Boolean useAvroLogicalTypes) {
        TableFieldSchema fieldSchema = new TableFieldSchema();
        LogicalType logicalType = useAvroLogicalTypes != false ? type.getLogicalType() : null;
        String sqlType = useAvroLogicalTypes != false ? type.getProp("sqlType") : null;
        switch (type.getType()) {
            case INT: {
                if (logicalType instanceof LogicalTypes.Date) {
                    return fieldSchema.setType("DATE");
                }
                if (logicalType instanceof LogicalTypes.TimeMillis) {
                    return fieldSchema.setType("TIME");
                }
                return fieldSchema.setType("INTEGER");
            }
            case LONG: {
                if (useAvroLogicalTypes.booleanValue() && TIMESTAMP_NANOS_LOGICAL_TYPE.equals(type.getProp("logicalType"))) {
                    return fieldSchema.setType("TIMESTAMP").setTimestampPrecision(Long.valueOf(12L));
                }
                if (logicalType instanceof LogicalTypes.TimeMicros) {
                    return fieldSchema.setType("TIME");
                }
                if (!VERSION_AVRO.startsWith("1.8") && !VERSION_AVRO.startsWith("1.9") && (logicalType instanceof LogicalTypes.LocalTimestampMillis || logicalType instanceof LogicalTypes.LocalTimestampMicros)) {
                    return fieldSchema.setType("DATETIME");
                }
                if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
                    return fieldSchema.setType("TIMESTAMP");
                }
                return fieldSchema.setType("INTEGER");
            }
            case FLOAT: 
            case DOUBLE: {
                return fieldSchema.setType("FLOAT");
            }
            case BOOLEAN: {
                return fieldSchema.setType("BOOLEAN");
            }
            case STRING: {
                if ("GEOGRAPHY".equals(sqlType)) {
                    return fieldSchema.setType("GEOGRAPHY");
                }
                if ("JSON".equals(sqlType)) {
                    return fieldSchema.setType("JSON");
                }
                return fieldSchema.setType("STRING");
            }
            case BYTES: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                    int precision = decimal.getPrecision();
                    int scale = decimal.getScale();
                    if (scale <= 9 && precision - scale <= 29) {
                        fieldSchema.setType("NUMERIC");
                        if (precision != 38 || scale != 9) {
                            fieldSchema.setPrecision(Long.valueOf(precision));
                            if (scale != 0) {
                                fieldSchema.setScale(Long.valueOf(scale));
                            }
                        }
                    } else {
                        fieldSchema.setType("BIGNUMERIC");
                        if (precision != 77 || scale != 38) {
                            fieldSchema.setPrecision(Long.valueOf(precision));
                            if (scale != 0) {
                                fieldSchema.setScale(Long.valueOf(scale));
                            }
                        }
                    }
                    return fieldSchema;
                }
                return fieldSchema.setType("BYTES");
            }
            case ENUM: {
                return fieldSchema.setType("STRING");
            }
            case FIXED: {
                return fieldSchema.setType("BYTES");
            }
            case RECORD: {
                List recordFields = type.getFields().stream().map(f -> BigQueryAvroUtils.fromAvroFieldSchema(f, useAvroLogicalTypes)).collect(Collectors.toList());
                return new TableFieldSchema().setType("RECORD").setFields(recordFields);
            }
        }
        throw new IllegalArgumentException("Unknown Avro type: " + type.getType());
    }

    static enum TimestampPrecision {
        MILLISECONDS,
        MICROSECONDS,
        NANOSECONDS;


        @UnknownKeyFor @NonNull @Initialized Instant toInstant(@UnknownKeyFor @NonNull @Initialized long epochValue) {
            switch (this) {
                case MILLISECONDS: {
                    return Instant.ofEpochMilli(epochValue);
                }
                case MICROSECONDS: {
                    long seconds = Math.floorDiv(epochValue, 1000000L);
                    long microsOfSecond = Math.floorMod(epochValue, 1000000L);
                    return Instant.ofEpochSecond(seconds, microsOfSecond * 1000L);
                }
                case NANOSECONDS: {
                    long seconds = Math.floorDiv(epochValue, 1000000000L);
                    long nanosOfSecond = Math.floorMod(epochValue, 1000000000L);
                    return Instant.ofEpochSecond(seconds, nanosOfSecond);
                }
            }
            throw new IllegalStateException("Unknown precision: " + (Object)((Object)this));
        }
    }

    static class DateTimeLogicalType
    extends LogicalType {
        public DateTimeLogicalType() {
            super("datetime");
        }
    }
}

