/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.cache;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.cache.AsyncWatermarkCache;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.cache.NoOpWatermarkCache;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.cache.WatermarkCache;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class CacheFactory
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -8722905670370252723L;
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized WatermarkCache> WATERMARK_CACHE = new ConcurrentHashMap<Long, WatermarkCache>();
    private static final @UnknownKeyFor @NonNull @Initialized AtomicLong CACHE_ID = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized long cacheId = CACHE_ID.getAndIncrement();
    private final @UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory;
    private final @UnknownKeyFor @NonNull @Initialized Duration refreshRate;

    public CacheFactory(@UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory, @UnknownKeyFor @NonNull @Initialized Duration watermarkRefreshRate) {
        this.daoFactory = daoFactory;
        this.refreshRate = watermarkRefreshRate;
    }

    public @UnknownKeyFor @NonNull @Initialized WatermarkCache getWatermarkCache() {
        return WATERMARK_CACHE.computeIfAbsent(this.cacheId, key -> this.refreshRate.getMillis() == 0L ? new NoOpWatermarkCache(this.daoFactory.getPartitionMetadataDao()) : new AsyncWatermarkCache(this.daoFactory.getPartitionMetadataDao(), this.refreshRate));
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized long getCacheId() {
        return this.cacheId;
    }
}

