/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.WriteResult;
import com.google.protobuf.util.Timestamps;
import com.google.rpc.Status;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.sdk.io.gcp.firestore.CounterFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1WriteFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@Immutable
public final class FirestoreV1 {
    static final @UnknownKeyFor @NonNull @Initialized FirestoreV1 INSTANCE = new FirestoreV1();

    private FirestoreV1() {
    }

    public @UnknownKeyFor @NonNull @Initialized Read read() {
        return Read.INSTANCE;
    }

    public @UnknownKeyFor @NonNull @Initialized Write write() {
        return Write.INSTANCE;
    }

    private static abstract class ReadTransform<@UnknownKeyFor InT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutT extends @UnknownKeyFor @NonNull @Initialized POutput, @UnknownKeyFor TrfmT extends @UnknownKeyFor @NonNull @Initialized ReadTransform<InT, OutT, TrfmT, BldrT>, @UnknownKeyFor BldrT extends @UnknownKeyFor @NonNull @Initialized Builder<InT, OutT, TrfmT, BldrT>>
    extends Transform<InT, OutT, TrfmT, BldrT> {
        final @Nullable @UnknownKeyFor @Initialized Instant readTime;

        ReadTransform(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            this.readTime = readTime;
        }

        @Override
        public abstract BldrT toBuilder();

        static abstract class Builder<@UnknownKeyFor InT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutT extends @UnknownKeyFor @NonNull @Initialized POutput, @UnknownKeyFor TrfmT extends @UnknownKeyFor @NonNull @Initialized ReadTransform<InT, OutT, TrfmT, BldrT>, @UnknownKeyFor BldrT extends @UnknownKeyFor @NonNull @Initialized Builder<InT, OutT, TrfmT, BldrT>>
        extends Transform.Builder<InT, OutT, TrfmT, BldrT> {
            @Nullable @UnknownKeyFor @Initialized Instant readTime;

            Builder() {
                this.readTime = null;
            }

            private Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
                this.readTime = readTime;
            }

            @Override
            final TrfmT genericBuild() {
                return this.buildSafe(Objects.requireNonNull(this.clock, "clock must be non null"), Objects.requireNonNull(this.firestoreStatefulComponentFactory, "firestoreFactory must be non null"), Objects.requireNonNull(this.rpcQosOptions, "rpcQosOptions must be non null"), this.readTime);
            }

            @Override
            TrfmT buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
                throw new UnsupportedOperationException();
            }

            abstract TrfmT buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock var1, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory var2, @UnknownKeyFor @NonNull @Initialized RpcQosOptions var3, @Nullable @UnknownKeyFor @Initialized Instant var4);

            public final BldrT withReadTime(@Nullable @UnknownKeyFor @Initialized Instant readTime) {
                this.readTime = readTime;
                return (BldrT)((Builder)this.self());
            }
        }
    }

    private static abstract class Transform<@UnknownKeyFor InT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutT extends @UnknownKeyFor @NonNull @Initialized POutput, @UnknownKeyFor TrfmT extends @UnknownKeyFor @NonNull @Initialized Transform<InT, OutT, TrfmT, BldrT>, @UnknownKeyFor BldrT extends @UnknownKeyFor @NonNull @Initialized Builder<InT, OutT, TrfmT, BldrT>>
    extends PTransform<InT, OutT>
    implements HasDisplayData {
        final @UnknownKeyFor @NonNull @Initialized JodaClock clock;
        final @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory;
        final @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions;

        Transform(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
            this.clock = clock;
            this.firestoreStatefulComponentFactory = firestoreStatefulComponentFactory;
            this.rpcQosOptions = rpcQosOptions;
        }

        public final void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
        }

        public abstract BldrT toBuilder();

        static abstract class Builder<@UnknownKeyFor InT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutT extends @UnknownKeyFor @NonNull @Initialized POutput, @UnknownKeyFor TrfmT extends @UnknownKeyFor @NonNull @Initialized Transform<InT, OutT, TrfmT, BldrT>, @UnknownKeyFor BldrT extends @UnknownKeyFor @NonNull @Initialized Builder<InT, OutT, TrfmT, BldrT>> {
            @UnknownKeyFor @NonNull @Initialized JodaClock clock;
            @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory;
            @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions;

            Builder() {
                this.clock = JodaClock.DEFAULT;
                this.firestoreStatefulComponentFactory = FirestoreStatefulComponentFactory.INSTANCE;
                this.rpcQosOptions = RpcQosOptions.defaultOptions();
            }

            private Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
                this.clock = clock;
                this.firestoreStatefulComponentFactory = firestoreStatefulComponentFactory;
                this.rpcQosOptions = rpcQosOptions;
            }

            BldrT self() {
                return (BldrT)this;
            }

            public abstract TrfmT build();

            TrfmT genericBuild() {
                return this.buildSafe(Objects.requireNonNull(this.clock, "clock must be non null"), Objects.requireNonNull(this.firestoreStatefulComponentFactory, "firestoreFactory must be non null"), Objects.requireNonNull(this.rpcQosOptions, "rpcQosOptions must be non null"));
            }

            abstract TrfmT buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock var1, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory var2, @UnknownKeyFor @NonNull @Initialized RpcQosOptions var3);

            public final BldrT withRpcQosOptions(@UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
                Objects.requireNonNull(rpcQosOptions, "rpcQosOptions must be non null");
                this.rpcQosOptions = rpcQosOptions;
                return this.self();
            }
        }
    }

    public static class FailedWritesException
    extends RuntimeException {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized WriteFailure> writeFailures;

        public FailedWritesException(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized WriteFailure> writeFailures) {
            super(String.format("Not-retryable status code(s) for %d writes", writeFailures.size()));
            this.writeFailures = writeFailures;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized WriteFailure> getWriteFailures() {
            return this.writeFailures;
        }
    }

    @Immutable
    public static final class WriteFailure
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized com.google.firestore.v1.Write write;
        private final @UnknownKeyFor @NonNull @Initialized WriteResult writeResult;
        private final @UnknownKeyFor @NonNull @Initialized Status status;

        public WriteFailure(@UnknownKeyFor @NonNull @Initialized com.google.firestore.v1.Write write, @UnknownKeyFor @NonNull @Initialized WriteResult writeResult, @UnknownKeyFor @NonNull @Initialized Status status) {
            this.write = write;
            this.writeResult = writeResult;
            this.status = status;
        }

        public @UnknownKeyFor @NonNull @Initialized com.google.firestore.v1.Write getWrite() {
            return this.write;
        }

        public @UnknownKeyFor @NonNull @Initialized WriteResult getWriteResult() {
            return this.writeResult;
        }

        public @UnknownKeyFor @NonNull @Initialized Status getStatus() {
            return this.status;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WriteFailure)) {
                return false;
            }
            WriteFailure that = (WriteFailure)o;
            return this.write.equals((Object)that.write) && this.writeResult.equals((Object)that.writeResult) && this.status.equals((Object)that.status);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.write, this.writeResult, this.status);
        }
    }

    @Immutable
    public static final class WriteSuccessSummary
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized int numWrites;
        private final @UnknownKeyFor @NonNull @Initialized long numBytes;

        public WriteSuccessSummary(@UnknownKeyFor @NonNull @Initialized int numWrites, @UnknownKeyFor @NonNull @Initialized long numBytes) {
            this.numWrites = numWrites;
            this.numBytes = numBytes;
        }

        public @UnknownKeyFor @NonNull @Initialized int getNumWrites() {
            return this.numWrites;
        }

        public @UnknownKeyFor @NonNull @Initialized long getNumBytes() {
            return this.numBytes;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WriteSuccessSummary)) {
                return false;
            }
            WriteSuccessSummary that = (WriteSuccessSummary)o;
            return this.numWrites == that.numWrites && this.numBytes == that.numBytes;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.numWrites, this.numBytes);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "WriteSummary{numWrites=" + this.numWrites + ", numBytes=" + this.numBytes + '}';
        }
    }

    public static final class BatchWriteWithDeadLetterQueue
    extends Transform<PCollection<com.google.firestore.v1.Write>, PCollection<WriteFailure>, BatchWriteWithDeadLetterQueue, Builder> {
        private final @Nullable @UnknownKeyFor @Initialized String projectId;
        private final @Nullable @UnknownKeyFor @Initialized String databaseId;

        private BatchWriteWithDeadLetterQueue(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized String projectId, @Nullable @UnknownKeyFor @Initialized String databaseId) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            this.projectId = projectId;
            this.databaseId = databaseId;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized WriteFailure> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized com.google.firestore.v1.Write> input) {
            return (PCollection)input.apply("batchWrite", (PTransform)ParDo.of((DoFn)new FirestoreV1WriteFn.BatchWriteFnWithDeadLetterQueue(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, CounterFactory.DEFAULT, this.projectId, this.databaseId)));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
        }

        public static final class Builder
        extends Transform.Builder<PCollection<com.google.firestore.v1.Write>, PCollection<WriteFailure>, BatchWriteWithDeadLetterQueue, Builder> {
            private @Nullable @UnknownKeyFor @Initialized String projectId;
            private @Nullable @UnknownKeyFor @Initialized String databaseId;

            private Builder() {
            }

            private @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@Nullable @UnknownKeyFor @Initialized String projectId) {
                this.projectId = projectId;
                return this;
            }

            private @UnknownKeyFor @NonNull @Initialized Builder setDatabaseId(@Nullable @UnknownKeyFor @Initialized String databaseId) {
                this.databaseId = databaseId;
                return this;
            }

            @VisibleForTesting
            @Nullable @UnknownKeyFor @Initialized String getProjectId() {
                return this.projectId;
            }

            @VisibleForTesting
            @Nullable @UnknownKeyFor @Initialized String getDatabaseId() {
                return this.databaseId;
            }

            private Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized BatchWriteWithDeadLetterQueue build() {
                return (BatchWriteWithDeadLetterQueue)((Object)this.genericBuild());
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized BatchWriteWithDeadLetterQueue buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
                return new BatchWriteWithDeadLetterQueue(clock, firestoreStatefulComponentFactory, rpcQosOptions, this.projectId, this.databaseId);
            }
        }
    }

    public static final class BatchWriteWithSummary
    extends Transform<PCollection<com.google.firestore.v1.Write>, PCollection<WriteSuccessSummary>, BatchWriteWithSummary, Builder> {
        private final @Nullable @UnknownKeyFor @Initialized String projectId;
        private final @Nullable @UnknownKeyFor @Initialized String databaseId;

        public BatchWriteWithSummary(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized String projectId, @Nullable @UnknownKeyFor @Initialized String databaseId) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            this.projectId = projectId;
            this.databaseId = databaseId;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized WriteSuccessSummary> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized com.google.firestore.v1.Write> input) {
            return (PCollection)input.apply("batchWrite", (PTransform)ParDo.of((DoFn)new FirestoreV1WriteFn.BatchWriteFnWithSummary(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, CounterFactory.DEFAULT, this.projectId, this.databaseId)));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
        }

        public static final class Builder
        extends Transform.Builder<PCollection<com.google.firestore.v1.Write>, PCollection<WriteSuccessSummary>, BatchWriteWithSummary, Builder> {
            private @Nullable @UnknownKeyFor @Initialized String projectId;
            private @Nullable @UnknownKeyFor @Initialized String databaseId;

            private Builder() {
            }

            private Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }

            private @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@Nullable @UnknownKeyFor @Initialized String projectId) {
                this.projectId = projectId;
                return this;
            }

            private @UnknownKeyFor @NonNull @Initialized Builder setDatabaseId(@Nullable @UnknownKeyFor @Initialized String databaseId) {
                this.databaseId = databaseId;
                return this;
            }

            @VisibleForTesting
            @Nullable @UnknownKeyFor @Initialized String getProjectId() {
                return this.projectId;
            }

            @VisibleForTesting
            @Nullable @UnknownKeyFor @Initialized String getDatabaseId() {
                return this.databaseId;
            }

            public @UnknownKeyFor @NonNull @Initialized BatchWriteWithDeadLetterQueue.Builder withDeadLetterQueue() {
                return new BatchWriteWithDeadLetterQueue.Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions).setProjectId(this.projectId).setDatabaseId(this.databaseId);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized BatchWriteWithSummary build() {
                return (BatchWriteWithSummary)((Object)this.genericBuild());
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized BatchWriteWithSummary buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
                return new BatchWriteWithSummary(clock, firestoreStatefulComponentFactory, rpcQosOptions, this.projectId, this.databaseId);
            }
        }
    }

    private static final class ListDocumentsResponseToDocument
    extends DoFn<ListDocumentsResponse, Document> {
        private ListDocumentsResponseToDocument() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            ((ListDocumentsResponse)c.element()).getDocumentsList().forEach(arg_0 -> ((DoFn.ProcessContext)c).output(arg_0));
        }
    }

    private static final class FlattenListCollectionIdsResponse
    extends DoFn<ListCollectionIdsResponse, String> {
        private FlattenListCollectionIdsResponse() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            ((ListCollectionIdsResponse)c.element()).getCollectionIdsList().forEach(arg_0 -> ((DoFn.ProcessContext)c).output(arg_0));
        }
    }

    public static final class PartitionQuery
    extends ReadTransform<PCollection<PartitionQueryRequest>, PCollection<RunQueryRequest>, PartitionQuery, Builder> {
        private final @UnknownKeyFor @NonNull @Initialized boolean nameOnlyQuery;

        private PartitionQuery(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @UnknownKeyFor @NonNull @Initialized boolean nameOnlyQuery, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            this.nameOnlyQuery = nameOnlyQuery;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized RunQueryRequest> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PartitionQueryRequest> input) {
            PCollection queries = (PCollection)((PCollection)input.apply("PartitionQuery", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.PartitionQueryFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime)))).apply("expand queries", (PTransform)ParDo.of((DoFn)new PartitionQueryResponseToRunQueryRequest(this.readTime)));
            if (this.nameOnlyQuery) {
                queries = (PCollection)queries.apply("set name only query", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<RunQueryRequest, RunQueryRequest>(){

                    public @UnknownKeyFor @NonNull @Initialized RunQueryRequest apply(@UnknownKeyFor @NonNull @Initialized RunQueryRequest input) {
                        RunQueryRequest.Builder builder = input.toBuilder();
                        builder.getStructuredQueryBuilder().setSelect(StructuredQuery.Projection.newBuilder().addFields(StructuredQuery.FieldReference.newBuilder().setFieldPath("__name__").build()).build());
                        return builder.build();
                    }
                }));
            }
            return (PCollection)queries.apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.nameOnlyQuery, this.readTime);
        }

        static final class PartitionQueryResponseToRunQueryRequest
        extends DoFn<FirestoreV1ReadFn.PartitionQueryPair, RunQueryRequest> {
            private final @Nullable @UnknownKeyFor @Initialized Instant readTime;
            static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized Cursor> CURSOR_REFERENCE_VALUE_COMPARATOR;

            PartitionQueryResponseToRunQueryRequest() {
                this(null);
            }

            PartitionQueryResponseToRunQueryRequest(@Nullable @UnknownKeyFor @Initialized Instant readTime) {
                this.readTime = readTime;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                FirestoreV1ReadFn.PartitionQueryPair pair = (FirestoreV1ReadFn.PartitionQueryPair)c.element();
                PartitionQueryRequest partitionQueryRequest = pair.getRequest();
                String dbRoot = partitionQueryRequest.getParent();
                StructuredQuery structuredQuery = partitionQueryRequest.getStructuredQuery();
                PartitionQueryResponse partitionQueryResponse = pair.getResponse();
                ArrayList<Cursor> cursors = new ArrayList<Cursor>(partitionQueryResponse.getPartitionsList());
                cursors.sort(CURSOR_REFERENCE_VALUE_COMPARATOR);
                int size = cursors.size();
                if (size == 0) {
                    this.emit(c, dbRoot, structuredQuery.toBuilder());
                    return;
                }
                int lastIdx = size - 1;
                for (int i = 0; i < size; ++i) {
                    Cursor curr = (Cursor)cursors.get(i);
                    if (i == 0) {
                        this.emit(c, dbRoot, structuredQuery.toBuilder().setEndAt(curr));
                    }
                    if (0 < i && i <= lastIdx) {
                        Cursor prev = (Cursor)cursors.get(i - 1);
                        this.emit(c, dbRoot, structuredQuery.toBuilder().setStartAt(prev).setEndAt(curr));
                    }
                    if (i != lastIdx) continue;
                    this.emit(c, dbRoot, structuredQuery.toBuilder().setStartAt(curr));
                }
            }

            private void emit(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized String dbRoot, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized StructuredQuery.Builder builder) {
                RunQueryRequest.Builder runQueryRequest = RunQueryRequest.newBuilder().setParent(dbRoot).setStructuredQuery(builder.build());
                if (this.readTime != null) {
                    runQueryRequest.setReadTime(Timestamps.fromMillis((long)this.readTime.getMillis()));
                }
                c.output((Object)runQueryRequest.build());
            }

            static {
                Function<Cursor, Optional> firstReferenceValue = c -> c.getValuesList().stream().filter(v -> {
                    String referenceValue = v.getReferenceValue();
                    return !referenceValue.isEmpty();
                }).findFirst();
                Function<String, String[]> stringToPath = s -> s.split("/");
                Comparator pathWiseCompare = (path1, path2) -> {
                    int minLength = Math.min(((String[])path1).length, ((String[])path2).length);
                    for (int i = 0; i < minLength; ++i) {
                        String pathSegment1 = path1[i];
                        String pathSegment2 = path2[i];
                        int compare = pathSegment1.compareTo(pathSegment2);
                        if (compare == 0) continue;
                        return compare;
                    }
                    if (((String[])path1).length == ((String[])path2).length) {
                        return 0;
                    }
                    if (minLength == ((String[])path1).length) {
                        return -1;
                    }
                    return 1;
                };
                CURSOR_REFERENCE_VALUE_COMPARATOR = Comparator.comparing(firstReferenceValue, (o1, o2) -> {
                    if (o1.isPresent() && o2.isPresent()) {
                        return pathWiseCompare.compare((String[])stringToPath.apply(((Value)o1.get()).getReferenceValue()), (String[])stringToPath.apply(((Value)o2.get()).getReferenceValue()));
                    }
                    if (o1.isPresent()) {
                        return -1;
                    }
                    return 1;
                });
            }
        }

        public static final class Builder
        extends ReadTransform.Builder<PCollection<PartitionQueryRequest>, PCollection<RunQueryRequest>, PartitionQuery, Builder> {
            private @UnknownKeyFor @NonNull @Initialized boolean nameOnlyQuery = false;

            private Builder() {
            }

            public Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @UnknownKeyFor @NonNull @Initialized boolean nameOnlyQuery, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
                this.nameOnlyQuery = nameOnlyQuery;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PartitionQuery build() {
                return (PartitionQuery)this.genericBuild();
            }

            public @UnknownKeyFor @NonNull @Initialized Builder withNameOnlyQuery() {
                this.nameOnlyQuery = true;
                return this;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized PartitionQuery buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                return new PartitionQuery(clock, firestoreStatefulComponentFactory, rpcQosOptions, this.nameOnlyQuery, readTime);
            }
        }
    }

    public static final class BatchGetDocuments
    extends ReadTransform<PCollection<BatchGetDocumentsRequest>, PCollection<BatchGetDocumentsResponse>, BatchGetDocuments, Builder> {
        private BatchGetDocuments(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BatchGetDocumentsResponse> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BatchGetDocumentsRequest> input) {
            return (PCollection)((PCollection)input.apply("batchGetDocuments", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.BatchGetDocumentsFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime)))).apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime);
        }

        public static final class Builder
        extends ReadTransform.Builder<PCollection<BatchGetDocumentsRequest>, PCollection<BatchGetDocumentsResponse>, BatchGetDocuments, Builder> {
            private Builder() {
            }

            public Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized BatchGetDocuments build() {
                return (BatchGetDocuments)this.genericBuild();
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized BatchGetDocuments buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                return new BatchGetDocuments(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            }
        }
    }

    public static final class RunQuery
    extends ReadTransform<PCollection<RunQueryRequest>, PCollection<RunQueryResponse>, RunQuery, Builder> {
        private RunQuery(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized RunQueryResponse> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized RunQueryRequest> input) {
            return (PCollection)((PCollection)input.apply("runQuery", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.RunQueryFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime)))).apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime);
        }

        public static final class Builder
        extends ReadTransform.Builder<PCollection<RunQueryRequest>, PCollection<RunQueryResponse>, RunQuery, Builder> {
            private Builder() {
            }

            private Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized RunQuery build() {
                return (RunQuery)this.genericBuild();
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized RunQuery buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                return new RunQuery(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            }
        }
    }

    public static final class ListDocuments
    extends ReadTransform<PCollection<ListDocumentsRequest>, PCollection<Document>, ListDocuments, Builder> {
        private ListDocuments(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Document> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ListDocumentsRequest> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("listDocuments", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.ListDocumentsFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime)))).apply((PTransform)ParDo.of((DoFn)new ListDocumentsResponseToDocument()))).apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime);
        }

        public static final class Builder
        extends ReadTransform.Builder<PCollection<ListDocumentsRequest>, PCollection<Document>, ListDocuments, Builder> {
            private Builder() {
            }

            private Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ListDocuments build() {
                return (ListDocuments)this.genericBuild();
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized ListDocuments buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                return new ListDocuments(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            }
        }
    }

    public static final class ListCollectionIds
    extends ReadTransform<PCollection<ListCollectionIdsRequest>, PCollection<String>, ListCollectionIds, Builder> {
        private ListCollectionIds(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ListCollectionIdsRequest> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("listCollectionIds", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.ListCollectionIdsFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime)))).apply((PTransform)ParDo.of((DoFn)new FlattenListCollectionIdsResponse()))).apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.readTime);
        }

        public static final class Builder
        extends ReadTransform.Builder<PCollection<ListCollectionIdsRequest>, PCollection<String>, ListCollectionIds, Builder> {
            private Builder() {
            }

            private Builder(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ListCollectionIds build() {
                return (ListCollectionIds)this.genericBuild();
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized ListCollectionIds buildSafe(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                return new ListCollectionIds(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
            }
        }
    }

    @Immutable
    public static final class Write {
        private @Nullable @UnknownKeyFor @Initialized String projectId;
        private @Nullable @UnknownKeyFor @Initialized String databaseId;
        private static final @UnknownKeyFor @NonNull @Initialized Write INSTANCE = new Write();

        private Write() {
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            this.projectId = projectId;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            Preconditions.checkArgument((databaseId != null ? 1 : 0) != 0, (Object)"databaseId can not be null");
            this.databaseId = databaseId;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BatchWriteWithSummary.Builder batchWrite() {
            return new BatchWriteWithSummary.Builder().setProjectId(this.projectId).setDatabaseId(this.databaseId);
        }
    }

    @Immutable
    public static final class Read {
        private static final @UnknownKeyFor @NonNull @Initialized Read INSTANCE = new Read();

        private Read() {
        }

        public @UnknownKeyFor @NonNull @Initialized ListDocuments.Builder listDocuments() {
            return new ListDocuments.Builder();
        }

        public @UnknownKeyFor @NonNull @Initialized ListCollectionIds.Builder listCollectionIds() {
            return new ListCollectionIds.Builder();
        }

        public @UnknownKeyFor @NonNull @Initialized BatchGetDocuments.Builder batchGetDocuments() {
            return new BatchGetDocuments.Builder();
        }

        public @UnknownKeyFor @NonNull @Initialized RunQuery.Builder runQuery() {
            return new RunQuery.Builder();
        }

        public @UnknownKeyFor @NonNull @Initialized PartitionQuery.Builder partitionQuery() {
            return new PartitionQuery.Builder();
        }
    }
}

