/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_SplittingIterable_Value;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.PeekingIterator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

class SplittingIterable
implements Iterable<Value> {
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlying;
    private final @UnknownKeyFor @NonNull @Initialized long splitSize;
    private final @UnknownKeyFor @NonNull @Initialized ConcatFields concatProtoAndTableRow;
    private final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized TableRow> protoToTableRow;
    private final @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized TimestampedValue<@UnknownKeyFor @NonNull @Initialized TableRow>, @UnknownKeyFor @NonNull @Initialized String> failedRowsConsumer;
    private final @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema;
    private final @UnknownKeyFor @NonNull @Initialized Instant elementsTimestamp;

    public SplittingIterable(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlying, @UnknownKeyFor @NonNull @Initialized long splitSize, @UnknownKeyFor @NonNull @Initialized ConcatFields concatProtoAndTableRow, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized TableRow> protoToTableRow, @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized TimestampedValue<@UnknownKeyFor @NonNull @Initialized TableRow>, @UnknownKeyFor @NonNull @Initialized String> failedRowsConsumer, @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema, @UnknownKeyFor @NonNull @Initialized Instant elementsTimestamp) {
        this.underlying = underlying;
        this.splitSize = splitSize;
        this.concatProtoAndTableRow = concatProtoAndTableRow;
        this.protoToTableRow = protoToTableRow;
        this.failedRowsConsumer = failedRowsConsumer;
        this.autoUpdateSchema = autoUpdateSchema;
        this.elementsTimestamp = elementsTimestamp;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Value> iterator() {
        return new Iterator<Value>(){
            final @UnknownKeyFor @NonNull @Initialized PeekingIterator<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlyingIterator;
            {
                this.underlyingIterator = Iterators.peekingIterator(SplittingIterable.this.underlying.iterator());
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public @UnknownKeyFor @NonNull @Initialized Value next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayList timestamps = Lists.newArrayList();
                @Nullable ArrayList failsafeRows = Lists.newArrayList();
                ProtoRows.Builder inserts = ProtoRows.newBuilder();
                long bytesSize = 0L;
                while (this.underlyingIterator.hasNext() && (bytesSize + (long)((StorageApiWritePayload)this.underlyingIterator.peek()).getPayload().length <= SplittingIterable.this.splitSize || inserts.getSerializedRowsCount() <= 0)) {
                    TableRow failsafeTableRow;
                    ByteString byteString;
                    StorageApiWritePayload payload;
                    block11: {
                        payload = (StorageApiWritePayload)this.underlyingIterator.next();
                        byteString = ByteString.copyFrom((byte[])payload.getPayload());
                        failsafeTableRow = null;
                        try {
                            failsafeTableRow = payload.getFailsafeTableRow();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (SplittingIterable.this.autoUpdateSchema) {
                            try {
                                @Nullable TableRow unknownFields = payload.getUnknownFields();
                                if (unknownFields == null || unknownFields.isEmpty()) break block11;
                                try {
                                    byteString = SplittingIterable.this.concatProtoAndTableRow.concat(byteString, unknownFields);
                                }
                                catch (TableRowToStorageApiProto.SchemaConversionException e) {
                                    TableRow tableRow = failsafeTableRow != null ? failsafeTableRow : (TableRow)SplittingIterable.this.protoToTableRow.apply(byteString);
                                    Instant timestamp = payload.getTimestamp();
                                    if (timestamp == null) {
                                        timestamp = SplittingIterable.this.elementsTimestamp;
                                    }
                                    SplittingIterable.this.failedRowsConsumer.accept(TimestampedValue.of((Object)tableRow, (Instant)timestamp), e.toString());
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    inserts.addSerializedRows(byteString);
                    Instant timestamp = payload.getTimestamp();
                    if (timestamp == null) {
                        timestamp = SplittingIterable.this.elementsTimestamp;
                    }
                    timestamps.add(timestamp);
                    failsafeRows.add(failsafeTableRow);
                    bytesSize += (long)byteString.size();
                }
                return new AutoValue_SplittingIterable_Value(inserts.build(), timestamps, failsafeRows);
            }
        };
    }

    static interface ConcatFields {
        public @UnknownKeyFor @NonNull @Initialized ByteString concat(@UnknownKeyFor @NonNull @Initialized ByteString var1, @UnknownKeyFor @NonNull @Initialized TableRow var2) throws  @UnknownKeyFor @NonNull @Initialized TableRowToStorageApiProto.SchemaConversionException;
    }

    @AutoValue
    static abstract class Value {
        Value() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized ProtoRows getProtoRows();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Instant> getTimestamps();

        abstract @UnknownKeyFor @NonNull @Initialized List<@Nullable @UnknownKeyFor @Initialized TableRow> getFailsafeTableRows();
    }
}

