/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.BackOffAdapter;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteRename
extends DoFn<Iterable<KV<TableDestination, String>>, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteRename.class);
    private final BigQueryServices bqServices;
    private final PCollectionView<String> jobIdToken;
    private final BigQueryIO.Write.WriteDisposition firstPaneWriteDisposition;
    private final BigQueryIO.Write.CreateDisposition firstPaneCreateDisposition;
    private final int maxRetryJobs;

    public WriteRename(BigQueryServices bqServices, PCollectionView<String> jobIdToken, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, int maxRetryJobs) {
        this.bqServices = bqServices;
        this.jobIdToken = jobIdToken;
        this.firstPaneWriteDisposition = writeDisposition;
        this.firstPaneCreateDisposition = createDisposition;
        this.maxRetryJobs = maxRetryJobs;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        ArrayListMultimap tempTables = ArrayListMultimap.create();
        for (KV kV : (Iterable)c.element()) {
            tempTables.put((Object)((TableDestination)kV.getKey()), (Object)((String)kV.getValue()));
        }
        for (Map.Entry entry : tempTables.asMap().entrySet()) {
            this.writeRename((TableDestination)entry.getKey(), (Iterable)entry.getValue(), c);
        }
    }

    private void writeRename(TableDestination finalTableDestination, Iterable<String> tempTableNames, DoFn.ProcessContext c) throws Exception {
        BigQueryIO.Write.WriteDisposition writeDisposition = c.pane().getIndex() == 0L ? this.firstPaneWriteDisposition : BigQueryIO.Write.WriteDisposition.WRITE_APPEND;
        BigQueryIO.Write.CreateDisposition createDisposition = c.pane().getIndex() == 0L ? this.firstPaneCreateDisposition : BigQueryIO.Write.CreateDisposition.CREATE_NEVER;
        ArrayList tempTablesJson = Lists.newArrayList(tempTableNames);
        if (tempTablesJson.isEmpty()) {
            return;
        }
        ArrayList tempTables = Lists.newArrayList();
        for (String table : tempTablesJson) {
            tempTables.add(BigQueryHelpers.fromJsonString(table, TableReference.class));
        }
        String jobIdPrefix = BigQueryHelpers.createJobId((String)c.sideInput(this.jobIdToken), finalTableDestination, -1, c.pane().getIndex());
        this.copy(this.bqServices.getJobService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, finalTableDestination.getTableReference(), tempTables, writeDisposition, createDisposition, finalTableDestination.getTableDescription());
        BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class));
        WriteRename.removeTemporaryTables(tableService, tempTables);
    }

    private void copy(BigQueryServices.JobService jobService, BigQueryServices.DatasetService datasetService, String jobIdPrefix, TableReference ref, List<TableReference> tempTables, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, @Nullable String tableDescription) throws InterruptedException, IOException {
        JobConfigurationTableCopy copyConfig = new JobConfigurationTableCopy().setSourceTables(tempTables).setDestinationTable(ref).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name());
        String projectId = ref.getProjectId();
        Job lastFailedCopyJob = null;
        BigQueryHelpers.RetryJobId jobId = new BigQueryHelpers.RetryJobId(jobIdPrefix, 0);
        String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, ref.getProjectId(), ref.getDatasetId());
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.withMaxRetries(this.maxRetryJobs).withInitialBackoff(Duration.standardSeconds((long)1L)).withMaxBackoff(Duration.standardMinutes((long)1L)).backoff());
        Sleeper sleeper = Sleeper.DEFAULT;
        int i = 0;
        do {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            LOG.info("Starting copy job for table {} using  {}, attempt {}", new Object[]{ref, jobRef, ++i});
            try {
                jobService.startCopyJob(jobRef, copyConfig);
            }
            catch (IOException e) {
                LOG.warn("Copy job {} failed with {}", (Object)jobRef, (Object)e);
                BigQueryHelpers.RetryJobIdResult result = BigQueryHelpers.getRetryJobId(jobId, projectId, bqLocation, jobService);
                jobId = result.jobId;
                if (result.shouldRetry) continue;
            }
            Job copyJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
            BigQueryHelpers.Status jobStatus = BigQueryHelpers.parseStatus(copyJob);
            switch (jobStatus) {
                case SUCCEEDED: {
                    if (tableDescription != null) {
                        datasetService.patchTableDescription(ref, tableDescription);
                    }
                    return;
                }
                case UNKNOWN: {
                    LOG.info("Copy job {} finished in unknown state: {}: {}", new Object[]{jobRef, copyJob.getStatus(), i < this.maxRetryJobs - 1 ? "will retry" : "will not retry"});
                    lastFailedCopyJob = copyJob;
                    break;
                }
                case FAILED: {
                    lastFailedCopyJob = copyJob;
                    jobId = BigQueryHelpers.getRetryJobId((BigQueryHelpers.RetryJobId)jobId, (String)projectId, (String)bqLocation, (BigQueryServices.JobService)jobService).jobId;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected status [%s] of load job: %s.", new Object[]{jobStatus, BigQueryHelpers.jobToPrettyString(copyJob)}));
                }
            }
        } while (WriteRename.nextBackOff(sleeper, backoff));
        throw new RuntimeException(String.format("Failed to create copy job with id prefix %s, reached max retries: %d, last failed copy job: %s.", jobIdPrefix, this.maxRetryJobs, BigQueryHelpers.jobToPrettyString(lastFailedCopyJob)));
    }

    private static boolean nextBackOff(Sleeper sleeper, BackOff backoff) throws InterruptedException {
        try {
            return BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void removeTemporaryTables(BigQueryServices.DatasetService tableService, List<TableReference> tempTables) {
        for (TableReference tableRef : tempTables) {
            try {
                LOG.debug("Deleting table {}", (Object)BigQueryHelpers.toJsonString(tableRef));
                tableService.deleteTable(tableRef);
            }
            catch (Exception e) {
                LOG.warn("Failed to delete the table {}", (Object)BigQueryHelpers.toJsonString(tableRef), (Object)e);
            }
        }
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"firstPaneWriteDisposition", (String)this.firstPaneWriteDisposition.toString()).withLabel("Write Disposition")).add(DisplayData.item((String)"firstPaneCreateDisposition", (String)this.firstPaneCreateDisposition.toString()).withLabel("Create Disposition"));
    }
}

