/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.extensions.gcp.util.GceMetadataUtil;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class SpannerIOMetadata {
    private final @Nullable @UnknownKeyFor @Initialized String beamJobId;
    static final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized SpannerIOMetadata> INSTANCE = Suppliers.memoizeWithExpiration(() -> SpannerIOMetadata.refreshInstance(), (long)5L, (TimeUnit)TimeUnit.MINUTES);

    private SpannerIOMetadata(@Nullable @UnknownKeyFor @Initialized String beamJobId) {
        this.beamJobId = beamJobId;
    }

    public static @UnknownKeyFor @NonNull @Initialized SpannerIOMetadata create() {
        return (SpannerIOMetadata)INSTANCE.get();
    }

    private static @UnknownKeyFor @NonNull @Initialized SpannerIOMetadata refreshInstance() {
        String dataflowJobId = GceMetadataUtil.fetchDataflowJobId();
        if (Strings.isNullOrEmpty((String)dataflowJobId)) {
            return new SpannerIOMetadata(null);
        }
        return new SpannerIOMetadata(dataflowJobId);
    }

    public @Nullable @UnknownKeyFor @Initialized String getBeamJobId() {
        return this.beamJobId;
    }
}

