/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.util.Base64;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableRow;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class FakeBigQueryServices
implements BigQueryServices {
    private @UnknownKeyFor @NonNull @Initialized BigQueryServices.JobService jobService;
    private @UnknownKeyFor @NonNull @Initialized FakeDatasetService datasetService;
    private @UnknownKeyFor @NonNull @Initialized BigQueryServices.StorageClient storageClient;

    public @UnknownKeyFor @NonNull @Initialized FakeBigQueryServices withJobService(@UnknownKeyFor @NonNull @Initialized BigQueryServices.JobService jobService) {
        this.jobService = jobService;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized FakeBigQueryServices withDatasetService(@UnknownKeyFor @NonNull @Initialized FakeDatasetService datasetService) {
        this.datasetService = datasetService;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized FakeBigQueryServices withStorageClient(@UnknownKeyFor @NonNull @Initialized BigQueryServices.StorageClient storageClient) {
        this.storageClient = storageClient;
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigQueryServices.JobService getJobService(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
        return this.jobService;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService getDatasetService(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
        return this.datasetService;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigQueryServices.WriteStreamService getWriteStreamService(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
        return this.datasetService;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigQueryServices.StorageClient getStorageClient(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
        return this.storageClient;
    }

    public static @UnknownKeyFor @NonNull @Initialized String encodeQueryResult(@UnknownKeyFor @NonNull @Initialized Table table) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FakeBigQueryServices.encodeQueryResult(table, (List<TableRow>)ImmutableList.of());
    }

    public static @UnknownKeyFor @NonNull @Initialized String encodeQueryResult(@UnknownKeyFor @NonNull @Initialized Table table, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> rows) throws @UnknownKeyFor @NonNull @Initialized IOException {
        KvCoder coder = KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)ListCoder.of((Coder)TableRowJsonCoder.of()));
        KV kv = KV.of((Object)BigQueryHelpers.toJsonString(table), rows);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        coder.encode(kv, (OutputStream)outputStream);
        return Base64.encodeBase64String((byte[])outputStream.toByteArray());
    }

    public static @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Table, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow>> decodeQueryResult(@UnknownKeyFor @NonNull @Initialized String queryResult) throws @UnknownKeyFor @NonNull @Initialized IOException {
        KvCoder coder = KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)ListCoder.of((Coder)TableRowJsonCoder.of()));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.decodeBase64((String)queryResult));
        KV kv = coder.decode((InputStream)inputStream);
        Table table = BigQueryHelpers.fromJsonString((String)kv.getKey(), Table.class);
        List rows = (List)kv.getValue();
        rows.forEach(FakeBigQueryServices::convertNumbers);
        return KV.of((Object)table, (Object)rows);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableRow convertNumbers(@UnknownKeyFor @NonNull @Initialized TableRow tableRow) {
        for (Map.Entry entry : tableRow.entrySet()) {
            if (!(entry.getValue() instanceof Integer)) continue;
            entry.setValue(Long.valueOf(((Integer)entry.getValue()).intValue()));
        }
        return tableRow;
    }

    public static class FakeBigQueryServerStream<@UnknownKeyFor T>
    implements BigQueryServices.BigQueryServerStream<T> {
        private final @UnknownKeyFor @NonNull @Initialized List<T> items;

        public FakeBigQueryServerStream(@UnknownKeyFor @NonNull @Initialized List<T> items) {
            this.items = items;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterator<T> iterator() {
            return this.items.iterator();
        }

        @Override
        public void cancel() {
        }
    }
}

