/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.rpc.Code;
import io.grpc.Status;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.io.gcp.testing.TableContainer;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.junit.Assert;

@Internal
public class FakeDatasetService
implements BigQueryServices.DatasetService,
BigQueryServices.WriteStreamService,
Serializable {
    static @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableContainer>> tables;
    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Stream> writeStreams;
    @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized Boolean> shouldFailRow = (Function<TableRow, Boolean> & Serializable)tr -> false;
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> insertErrors = Maps.newHashMap();
    static @UnknownKeyFor @NonNull @Initialized AtomicInteger insertCount;

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp() {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            tables = HashBasedTable.create();
            insertCount = new AtomicInteger(0);
            writeStreams = Maps.newHashMap();
            FakeJobService.setUp();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setShouldFailRow(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized Boolean> shouldFailRow) {
        this.shouldFailRow = shouldFailRow;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table getTable(@UnknownKeyFor @NonNull @Initialized TableReference tableRef) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        if (tableRef.getProjectId() == null) {
            throw new NullPointerException(String.format("tableRef is missing projectId: %s", tableRef));
        }
        return this.getTable(tableRef, null);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table getTable(@UnknownKeyFor @NonNull @Initialized TableReference tableRef, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> selectedFields) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.getTable(tableRef, selectedFields, null);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table getTable(@UnknownKeyFor @NonNull @Initialized TableReference tableRef, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> selectedFields, @javax.annotation.Nullable  @UnknownKeyFor @Nullable @Initialized BigQueryServices.DatasetService.TableMetadataView view) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.getTableImpl(tableRef, selectedFields, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table getTableImpl(@UnknownKeyFor @NonNull @Initialized TableReference tableRef, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> selectedFields, @javax.annotation.Nullable  @UnknownKeyFor @Nullable @Initialized BigQueryServices.DatasetService.TableMetadataView view) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)tableRef.getProjectId(), (Object)tableRef.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such dataset was set", tableRef.getProjectId(), tableRef.getDatasetId());
            }
            com.google.api.services.bigquery.model.Table table = (tableContainer = (TableContainer)dataset.get(tableRef.getTableId())) == null ? null : tableContainer.getTable();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> getAllRows(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.getTableContainer(projectId, datasetId, tableId).getRows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getAllIds(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.getTableContainer(projectId, datasetId, tableId).getIds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @NonNull @Initialized TableContainer getTableContainer(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such dataset was set", projectId, datasetId);
            }
            if ((tableContainer = (TableContainer)dataset.get(tableId)) == null) {
                this.throwNotFound("Tried to get a table %s:%s.%s, but no such table was set", projectId, datasetId, tableId);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return tableContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTable(@UnknownKeyFor @NonNull @Initialized TableReference tableRef) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        FakeDatasetService.validateWholeTableReference(tableRef);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Map dataset = (Map)tables.get((Object)tableRef.getProjectId(), (Object)tableRef.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableRef.getProjectId(), tableRef.getDatasetId());
            }
            dataset.remove(tableRef.getTableId());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void validateWholeTableReference(@UnknownKeyFor @NonNull @Initialized TableReference tableReference) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Pattern tableRegexp = Pattern.compile("[-\\w]{1,1024}");
        if (!tableRegexp.matcher(tableReference.getTableId()).matches()) {
            throw new IOException(String.format("invalid table ID %s. Table IDs must be alphanumeric (plus underscores) and must be at most 1024 characters long. Also, table decorators cannot be used.", tableReference.getTableId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(@UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table table) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TableReference tableReference = table.getTableReference();
        FakeDatasetService.validateWholeTableReference(tableReference);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Map dataset = (Map)tables.get((Object)tableReference.getProjectId(), (Object)tableReference.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableReference.getProjectId(), tableReference.getDatasetId());
            }
            dataset.computeIfAbsent(tableReference.getTableId(), k -> {
                TableContainer tableContainer = new TableContainer(table);
                String streamName = String.format("projects/%s/datasets/%s/tables/%s/streams/_default", tableReference.getProjectId(), tableReference.getDatasetId(), BigQueryHelpers.stripPartitionDecorator(tableReference.getTableId()));
                writeStreams.put(streamName, new Stream(streamName, tableContainer, WriteStream.Type.COMMITTED));
                return tableContainer;
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTableSchema(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) throws @UnknownKeyFor @NonNull @Initialized IOException {
        FakeDatasetService.validateWholeTableReference(tableReference);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)tableReference.getProjectId(), (Object)tableReference.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableReference.getProjectId(), tableReference.getDatasetId());
            }
            if ((tableContainer = (TableContainer)dataset.get(tableReference.getTableId())) == null) {
                this.throwNotFound("Tried to get a table %s, but no such table existed", tableReference);
            }
            tableContainer.table.setSchema(tableSchema);
            for (Stream stream : writeStreams.values()) {
                if (stream.tableContainer != tableContainer) continue;
                stream.setUpdatedSchema(tableSchema);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimaryKey(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> columns) throws @UnknownKeyFor @NonNull @Initialized IOException {
        FakeDatasetService.validateWholeTableReference(tableReference);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)tableReference.getProjectId(), (Object)tableReference.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableReference.getProjectId(), tableReference.getDatasetId());
            }
            if ((tableContainer = (TableContainer)dataset.get(tableReference.getTableId())) == null) {
                this.throwNotFound("Tried to get a table %s, but no such table existed", tableReference);
            }
            tableContainer.setPrimaryKeyColumns(columns);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isTableEmpty(@UnknownKeyFor @NonNull @Initialized TableReference tableRef) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Long numBytes = this.getTable(tableRef).getNumBytes();
        return numBytes == null || numBytes == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized Dataset getDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Map dataset = (Map)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", projectId, datasetId);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new Dataset().setDatasetReference(new DatasetReference().setDatasetId(datasetId).setProjectId(projectId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized String description, @UnknownKeyFor @NonNull @Initialized Long defaultTableExpirationMs) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            HashMap dataset = (HashMap)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                dataset = new HashMap();
                tables.put((Object)projectId, (Object)datasetId, dataset);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            tables.remove((Object)projectId, (Object)datasetId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized int getInsertCount() {
        return insertCount.get();
    }

    public @UnknownKeyFor @NonNull @Initialized long insertAll(@UnknownKeyFor @NonNull @Initialized TableReference ref, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> rowList, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> insertIdList) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        ArrayList windowedRows = Lists.newArrayList();
        for (TableRow row : rowList) {
            windowedRows.add(FailsafeValueInSingleWindow.of((Object)row, (Instant)GlobalWindow.TIMESTAMP_MAX_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING, (Object)row));
        }
        return this.insertAll(ref, windowedRows, insertIdList, InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized long insertAll(@UnknownKeyFor @NonNull @Initialized TableReference ref, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow>> rowList, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> insertIdList, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> failedInserts, @UnknownKeyFor @NonNull @Initialized ErrorContainer<T> errorContainer, @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow>> successfulRows) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Map<TableRow, List<TableDataInsertAllResponse.InsertErrors>> insertErrors = this.getInsertErrors();
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            if (ignoreInsertIds) {
                insertIdList = null;
            }
            if (insertIdList != null) {
                Assert.assertEquals((long)rowList.size(), (long)insertIdList.size());
            }
            long dataSize = 0L;
            TableContainer tableContainer = this.getTableContainer(ref.getProjectId(), ref.getDatasetId(), BigQueryHelpers.stripPartitionDecorator(ref.getTableId()));
            for (int i = 0; i < rowList.size(); ++i) {
                TableRow row = (TableRow)rowList.get(i).getValue();
                List<TableDataInsertAllResponse.InsertErrors> allErrors = insertErrors.get(row);
                boolean shouldInsert = true;
                if (allErrors != null) {
                    for (TableDataInsertAllResponse.InsertErrors errors : allErrors) {
                        if (retryPolicy.shouldRetry(new InsertRetryPolicy.Context(errors))) continue;
                        shouldInsert = false;
                    }
                }
                if (shouldInsert) {
                    dataSize = insertIdList == null ? (dataSize += tableContainer.addRow(row, null)) : (dataSize += tableContainer.addRow(row, insertIdList.get(i)));
                    if (successfulRows == null) continue;
                    successfulRows.add((ValueInSingleWindow<TableRow>)ValueInSingleWindow.of((Object)row, (Instant)rowList.get(i).getTimestamp(), (BoundedWindow)rowList.get(i).getWindow(), (PaneInfo)rowList.get(i).getPane()));
                    continue;
                }
                errorContainer.add(failedInserts, allErrors.get(allErrors.size() - 1), ref, rowList.get(i));
            }
            insertCount.addAndGet(1);
            // ** MonitorExit[var12_12] (shouldn't be in output)
            return dataSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table patchTableDescription(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String tableDescription) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        FakeDatasetService.validateWholeTableReference(tableReference);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer = this.getTableContainer(tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId());
            tableContainer.getTable().setDescription(tableDescription);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return tableContainer.getTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized WriteStream createWriteStream(@UnknownKeyFor @NonNull @Initialized String tableUrn, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WriteStream.Type type) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        try {
            TableReference tableReference = BigQueryHelpers.parseTableUrn(BigQueryHelpers.stripPartitionDecorator(tableUrn));
            Class<FakeDatasetService> clazz = FakeDatasetService.class;
            synchronized (FakeDatasetService.class) {
                TableContainer tableContainer = this.getTableContainer(tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId());
                String streamName = UUID.randomUUID().toString();
                Stream stream = new Stream(streamName, tableContainer, type);
                writeStreams.put(streamName, stream);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return stream.toWriteStream();
            }
        }
        catch (IOException e) {
            throw new ApiException((Throwable)e, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @javax.annotation.Nullable
    public @UnknownKeyFor @Nullable @Initialized WriteStream getWriteStream(@UnknownKeyFor @NonNull @Initialized String streamName) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Stream stream = writeStreams.get(streamName);
            if (stream != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return stream.toWriteStream();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new ApiException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), false);
        }
    }

    @Override
    public  @UnknownKeyFor @NonNull @Initialized BigQueryServices.StreamAppendClient getStreamAppendClient(final @UnknownKeyFor @NonNull @Initialized String streamName, final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptor, @UnknownKeyFor @NonNull @Initialized boolean useConnectionPool, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized AppendRowsRequest.MissingValueInterpretation missingValueInterpretation) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new BigQueryServices.StreamAppendClient(){
            private // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor protoDescriptor = TableRowToStorageApiProto.wrapDescriptorProto(descriptor);
            private @UnknownKeyFor @NonNull @Initialized TableSchema currentSchema;
            @javax.annotation.Nullable
            private @UnknownKeyFor @Nullable @Initialized com.google.cloud.bigquery.storage.v1.TableSchema updatedSchema;
            private @UnknownKeyFor @NonNull @Initialized boolean usedForInsert = false;
            private @UnknownKeyFor @NonNull @Initialized boolean usedForUpdate = false;
            {
                Class<FakeDatasetService> clazz = FakeDatasetService.class;
                synchronized (FakeDatasetService.class) {
                    Stream stream = writeStreams.get(streamName);
                    if (stream == null) {
                        throw new ApiException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), false);
                    }
                    this.currentSchema = stream.tableContainer.getTable().getSchema();
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public @UnknownKeyFor @NonNull @Initialized ApiFuture<@UnknownKeyFor @NonNull @Initialized AppendRowsResponse> appendRows(@UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized ProtoRows rows) throws @UnknownKeyFor @NonNull @Initialized Exception {
                AppendRowsResponse.Builder responseBuilder = AppendRowsResponse.newBuilder();
                Class<FakeDatasetService> clazz = FakeDatasetService.class;
                synchronized (FakeDatasetService.class) {
                    Stream stream = writeStreams.get(streamName);
                    if (stream == null) {
                        throw new RuntimeException("No such stream: " + streamName);
                    }
                    ArrayList streamEntries = Lists.newArrayListWithExpectedSize((int)rows.getSerializedRowsCount());
                    HashMap rowIndexToErrorMessage = Maps.newHashMap();
                    for (int i = 0; i < rows.getSerializedRowsCount(); ++i) {
                        ByteString bytes = rows.getSerializedRows(i);
                        DynamicMessage msg = DynamicMessage.parseFrom((Descriptors.Descriptor)this.protoDescriptor, (ByteString)bytes);
                        if (msg.getUnknownFields() != null && !msg.getUnknownFields().asMap().isEmpty()) {
                            throw new RuntimeException("Unknown fields set in append! " + msg.getUnknownFields());
                        }
                        TableRow tableRow = TableRowToStorageApiProto.tableRowFromMessage((Message)DynamicMessage.parseFrom((Descriptors.Descriptor)this.protoDescriptor, (ByteString)bytes), false, (Predicate<String>)Predicates.alwaysTrue());
                        if (FakeDatasetService.this.shouldFailRow.apply(tableRow).booleanValue()) {
                            rowIndexToErrorMessage.put(i, "Failing row " + tableRow.toPrettyString());
                        }
                        String insertTypeStr = null;
                        long changeSequenceNum = -1L;
                        Descriptors.FieldDescriptor fieldDescriptor = this.protoDescriptor.findFieldByName("_CHANGE_TYPE");
                        if (fieldDescriptor != null) {
                            insertTypeStr = (String)msg.getField(fieldDescriptor);
                        }
                        if ((fieldDescriptor = this.protoDescriptor.findFieldByName("_CHANGE_SEQUENCE_NUMBER")) != null) {
                            String changeSequenceNumHex = (String)msg.getField(fieldDescriptor);
                            changeSequenceNum = Long.parseUnsignedLong(changeSequenceNumHex, 16);
                        }
                        Stream.Entry.UpdateType insertType = Stream.Entry.UpdateType.INSERT;
                        if (insertTypeStr != null) {
                            insertType = Stream.Entry.UpdateType.valueOf(insertTypeStr);
                        }
                        if (insertType == Stream.Entry.UpdateType.INSERT) {
                            Preconditions.checkArgument((!this.usedForUpdate ? 1 : 0) != 0, (Object)"Stream can't be used for update and insert.");
                            this.usedForInsert = true;
                        } else {
                            Preconditions.checkArgument((!this.usedForInsert ? 1 : 0) != 0, (Object)"Stream can't be used for update and insert.");
                            this.usedForUpdate = true;
                        }
                        streamEntries.add(new Stream.Entry(tableRow, insertType, changeSequenceNum));
                    }
                    if (!rowIndexToErrorMessage.isEmpty()) {
                        // ** MonitorExit[var5_4] (shouldn't be in output)
                        return ApiFutures.immediateFailedFuture((Throwable)new Exceptions.AppendSerializationError(Code.INVALID_ARGUMENT.getNumber(), "Append serialization failed for writer: " + streamName, stream.streamName, (Map)rowIndexToErrorMessage));
                    }
                    stream.appendRows(offset, streamEntries);
                    if (stream.getUpdatedSchema() != null) {
                        com.google.cloud.bigquery.storage.v1.TableSchema newSchema = TableRowToStorageApiProto.schemaToProtoTableSchema(stream.getUpdatedSchema());
                        responseBuilder.setUpdatedSchema(newSchema);
                        if (this.updatedSchema == null) {
                            this.updatedSchema = newSchema;
                        }
                    }
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return ApiFutures.immediateFuture((Object)responseBuilder.build());
                }
            }

            @Override
            public @Nullable @UnknownKeyFor @Initialized com.google.cloud.bigquery.storage.v1.TableSchema getUpdatedSchema() {
                return this.updatedSchema;
            }

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            }

            @Override
            public void pin() {
            }

            @Override
            public void unpin() throws @UnknownKeyFor @NonNull @Initialized Exception {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized ApiFuture<@UnknownKeyFor @NonNull @Initialized FlushRowsResponse> flush(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized long offset) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Stream stream = writeStreams.get(streamName);
            if (stream == null) {
                throw new RuntimeException("No such stream: " + streamName);
            }
            stream.flush(offset);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return ApiFutures.immediateFuture((Object)FlushRowsResponse.newBuilder().build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized ApiFuture<@UnknownKeyFor @NonNull @Initialized FinalizeWriteStreamResponse> finalizeWriteStream(@UnknownKeyFor @NonNull @Initialized String streamName) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Stream stream = writeStreams.get(streamName);
            if (stream == null) {
                throw new RuntimeException("No such stream: " + streamName);
            }
            long numRows = stream.finalizeStream();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ApiFutures.immediateFuture((Object)FinalizeWriteStreamResponse.newBuilder().setRowCount(numRows).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized ApiFuture<@UnknownKeyFor @NonNull @Initialized BatchCommitWriteStreamsResponse> commitWriteStreams(@UnknownKeyFor @NonNull @Initialized String tableUrn, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> writeStreamNames) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            for (String streamName : writeStreamNames) {
                Stream stream = writeStreams.get(streamName);
                if (stream == null) {
                    throw new RuntimeException("No such stream: " + streamName);
                }
                stream.commit();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ApiFutures.immediateFuture((Object)BatchCommitWriteStreamsResponse.newBuilder().setCommitTime(Timestamp.newBuilder().build()).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failOnInsert(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse.InsertErrors>> insertErrors) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            for (Map.Entry<TableRow, List<TableDataInsertAllResponse.InsertErrors>> entry : insertErrors.entrySet()) {
                ArrayList errorStrings = Lists.newArrayList();
                for (TableDataInsertAllResponse.InsertErrors errors : entry.getValue()) {
                    errorStrings.add(BigQueryHelpers.toJsonString(errors));
                }
                this.insertErrors.put(BigQueryHelpers.toJsonString(entry.getKey()), errorStrings);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse.InsertErrors>> getInsertErrors() {
        HashMap parsedInsertErrors = Maps.newHashMap();
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            for (Map.Entry<String, List<String>> entry : this.insertErrors.entrySet()) {
                TableRow tableRow = BigQueryHelpers.fromJsonString(entry.getKey(), TableRow.class);
                ArrayList allErrors = Lists.newArrayList();
                for (String errorsString : entry.getValue()) {
                    allErrors.add(BigQueryHelpers.fromJsonString(errorsString, TableDataInsertAllResponse.InsertErrors.class));
                }
                parsedInsertErrors.put(tableRow, allErrors);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return parsedInsertErrors;
        }
    }

    @FormatMethod
    void throwNotFound(@FormatString @UnknownKeyFor @NonNull @Initialized String format, Object ... args) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new IOException(String.format(format, args), (Throwable)new HttpResponseException.Builder(404, String.format(format, args), new HttpHeaders()).build());
    }

    static class Stream {
        final @UnknownKeyFor @NonNull @Initialized String streamName;
        final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Entry> stream;
        final @UnknownKeyFor @NonNull @Initialized TableContainer tableContainer;
        final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized WriteStream.Type type;
        @UnknownKeyFor @NonNull @Initialized long nextFlushPosition;
        @UnknownKeyFor @NonNull @Initialized boolean finalized;
        @UnknownKeyFor @NonNull @Initialized TableSchema currentSchema;
        @javax.annotation.Nullable
        @UnknownKeyFor @Nullable @Initialized TableSchema updatedSchema = null;

        Stream(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized TableContainer tableContainer, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized WriteStream.Type type) {
            this.streamName = streamName;
            this.stream = Lists.newArrayList();
            this.tableContainer = tableContainer;
            this.currentSchema = tableContainer.getTable().getSchema();
            this.type = type;
            this.finalized = false;
            this.nextFlushPosition = 0L;
        }

        void setUpdatedSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) {
            this.updatedSchema = tableSchema;
        }

        @UnknownKeyFor @NonNull @Initialized TableSchema getUpdatedSchema() {
            return this.updatedSchema;
        }

        @UnknownKeyFor @NonNull @Initialized WriteStream toWriteStream() {
            return WriteStream.newBuilder().setName(this.streamName).setType(this.type).setTableSchema(TableRowToStorageApiProto.schemaToProtoTableSchema(this.currentSchema)).build();
        }

        @UnknownKeyFor @NonNull @Initialized long finalizeStream() {
            this.finalized = true;
            return this.stream.size();
        }

        void appendRows(@UnknownKeyFor @NonNull @Initialized long position, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Entry> rowsToAppend) {
            if (this.finalized) {
                throw new RuntimeException("Stream already finalized.");
            }
            if (position != -1L && position != (long)this.stream.size()) {
                throw new RuntimeException("Bad append: " + position + " + for stream " + this.streamName + " expected " + this.stream.size());
            }
            this.stream.addAll(rowsToAppend);
            if (this.type == WriteStream.Type.COMMITTED) {
                rowsToAppend.forEach(this::applyEntry);
            }
        }

        void flush(@UnknownKeyFor @NonNull @Initialized long position) {
            Preconditions.checkState((this.type == WriteStream.Type.BUFFERED ? 1 : 0) != 0);
            Preconditions.checkState((!this.finalized ? 1 : 0) != 0);
            if (position >= (long)this.stream.size()) {
                throw new RuntimeException("");
            }
            while (this.nextFlushPosition <= position) {
                this.applyEntry(this.stream.get((int)this.nextFlushPosition));
                ++this.nextFlushPosition;
            }
        }

        void applyEntry(@UnknownKeyFor @NonNull @Initialized Entry entry) {
            switch (entry.updateType) {
                case INSERT: {
                    this.tableContainer.addRow(entry.tableRow, "");
                    break;
                }
                case UPSERT: {
                    this.tableContainer.upsertRow(entry.tableRow, entry.sqn);
                    break;
                }
                case DELETE: {
                    this.tableContainer.deleteRow(entry.tableRow, entry.sqn);
                }
            }
        }

        void commit() {
            if (!this.finalized) {
                throw new RuntimeException("Can't commit unfinalized stream.");
            }
            Preconditions.checkState((this.type == WriteStream.Type.PENDING ? 1 : 0) != 0);
            this.stream.forEach(this::applyEntry);
        }

        static class Entry {
            final @UnknownKeyFor @NonNull @Initialized TableRow tableRow;
            final @UnknownKeyFor @NonNull @Initialized UpdateType updateType;
            final @UnknownKeyFor @NonNull @Initialized long sqn;

            public Entry(@UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized UpdateType updateType, @UnknownKeyFor @NonNull @Initialized long sqn) {
                this.tableRow = tableRow;
                this.updateType = updateType;
                this.sqn = sqn;
            }

            static enum UpdateType {
                INSERT,
                UPSERT,
                DELETE;

            }
        }
    }
}

