/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOErrorCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Throwables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@DefaultCoder(value=HealthcareIOErrorCoder.class)
public class HealthcareIOError<@UnknownKeyFor T> {
    private T dataResource;
    private @UnknownKeyFor @NonNull @Initialized String errorMessage;
    private @UnknownKeyFor @NonNull @Initialized String stackTrace;
    private @UnknownKeyFor @NonNull @Initialized Instant observedTime;
    private @UnknownKeyFor @NonNull @Initialized int statusCode;

    HealthcareIOError(T dataResource, @UnknownKeyFor @NonNull @Initialized String errorMessage, @UnknownKeyFor @NonNull @Initialized String stackTrace, @Nullable @UnknownKeyFor @Initialized Instant observedTime, @Nullable @UnknownKeyFor @Initialized Integer statusCode) {
        this.dataResource = dataResource;
        this.errorMessage = errorMessage;
        this.stackTrace = stackTrace;
        if (statusCode != null) {
            this.statusCode = statusCode;
        }
        this.observedTime = observedTime != null ? observedTime : Instant.now();
    }

    public @UnknownKeyFor @NonNull @Initialized String getErrorMessage() {
        return this.errorMessage;
    }

    public @UnknownKeyFor @NonNull @Initialized String getStackTrace() {
        return this.stackTrace;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getObservedTime() {
        return this.observedTime;
    }

    public T getDataResource() {
        return this.dataResource;
    }

    public @UnknownKeyFor @NonNull @Initialized Integer getStatusCode() {
        return this.statusCode;
    }

    static <T> @UnknownKeyFor @NonNull @Initialized HealthcareIOError<T> of(T dataResource, @UnknownKeyFor @NonNull @Initialized Exception error) {
        String msg = error.getMessage();
        String stackTrace = Throwables.getStackTraceAsString((Throwable)error);
        Integer statusCode = null;
        if (error instanceof GoogleJsonResponseException) {
            statusCode = ((GoogleJsonResponseException)error).getStatusCode();
        } else if (error instanceof HttpHealthcareApiClient.HealthcareHttpException) {
            statusCode = ((HttpHealthcareApiClient.HealthcareHttpException)error).getStatusCode();
        }
        return new HealthcareIOError<T>(dataResource, msg, stackTrace, null, statusCode);
    }
}

