/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.util.Timestamps;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreDoFn;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1RpcAttemptContexts;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.QueryUtils;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

final class FirestoreV1ReadFn {
    FirestoreV1ReadFn() {
    }

    static final class PartitionQueryPair
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized PartitionQueryRequest request;
        private final @UnknownKeyFor @NonNull @Initialized PartitionQueryResponse response;

        @VisibleForTesting
        PartitionQueryPair(@UnknownKeyFor @NonNull @Initialized PartitionQueryRequest request, @UnknownKeyFor @NonNull @Initialized PartitionQueryResponse response) {
            this.request = request;
            this.response = response;
        }

        public @UnknownKeyFor @NonNull @Initialized PartitionQueryRequest getRequest() {
            return this.request;
        }

        public @UnknownKeyFor @NonNull @Initialized PartitionQueryResponse getResponse() {
            return this.response;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PartitionQueryPair)) {
                return false;
            }
            PartitionQueryPair that = (PartitionQueryPair)o;
            return this.request.equals((Object)that.request) && this.response.equals((Object)that.response);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.request, this.response);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "PartitionQueryPair{request=" + this.request + ", response=" + this.response + '}';
        }
    }

    static abstract class BaseFirestoreV1ReadFn<@UnknownKeyFor InT, @UnknownKeyFor OutT>
    extends FirestoreDoFn.ImplicitlyWindowedFirestoreDoFn<InT, OutT>
    implements FirestoreV1RpcAttemptContexts.HasRpcAttemptContext {
        protected final @UnknownKeyFor @NonNull @Initialized JodaClock clock;
        protected final @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory;
        protected final @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions;
        protected final @Nullable @UnknownKeyFor @Initialized Instant readTime;
        protected transient @UnknownKeyFor @NonNull @Initialized FirestoreStub firestoreStub;
        protected transient @UnknownKeyFor @NonNull @Initialized RpcQos rpcQos;
        protected transient @UnknownKeyFor @NonNull @Initialized String projectId;

        protected BaseFirestoreV1ReadFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            this.clock = Objects.requireNonNull(clock, "clock must be non null");
            this.firestoreStatefulComponentFactory = Objects.requireNonNull(firestoreStatefulComponentFactory, "firestoreFactory must be non null");
            this.rpcQosOptions = Objects.requireNonNull(rpcQosOptions, "rpcQosOptions must be non null");
            this.readTime = readTime;
        }

        @Override
        public void setup() {
            this.rpcQos = this.firestoreStatefulComponentFactory.getRpcQos(this.rpcQosOptions);
        }

        @Override
        public final void startBundle(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) {
            String project = ((GcpOptions)c.getPipelineOptions().as(GcpOptions.class)).getProject();
            this.projectId = Objects.requireNonNull(project, "project must be defined on GcpOptions of PipelineOptions");
            this.firestoreStub = this.firestoreStatefulComponentFactory.getFirestoreStub(c.getPipelineOptions());
        }

        @Override
        public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.projectId = null;
            this.firestoreStub.close();
        }

        @Override
        public final void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.include("rpcQosOptions", (HasDisplayData)this.rpcQosOptions);
            builder.addIfNotNull(DisplayData.item((String)"readTime", (Instant)this.readTime).withLabel("ReadTime"));
        }

        protected abstract InT setReadTime(InT var1, @UnknownKeyFor @NonNull @Initialized Instant var2);
    }

    private static abstract class PaginatedFirestoreV1ReadFn<@UnknownKeyFor RequestT extends @UnknownKeyFor @NonNull @Initialized Message, @UnknownKeyFor PagedResponseT/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized AbstractPagedListResponse<RequestT, ResponseT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, PageT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor PageT/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized AbstractPage<RequestT, ResponseT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, PageT>, @UnknownKeyFor ResponseT extends @UnknownKeyFor @NonNull @Initialized Message>
    extends BaseFirestoreV1ReadFn<RequestT, ResponseT> {
        protected PaginatedFirestoreV1ReadFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        protected abstract @UnknownKeyFor @NonNull @Initialized UnaryCallable<RequestT, PagedResponseT> getCallable(@UnknownKeyFor @NonNull @Initialized FirestoreStub var1);

        protected abstract RequestT setPageToken(RequestT var1, @UnknownKeyFor @NonNull @Initialized String var2);

        @Override
        public final void processElement(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Message element = Objects.requireNonNull((Message)c.element(), "c.element() must be non null");
            RpcQos.RpcReadAttempt attempt = this.rpcQos.newReadAttempt(this.getRpcAttemptContext());
            String nextPageToken = null;
            while (true) {
                if (!attempt.awaitSafeToProceed(this.clock.instant())) {
                    continue;
                }
                try {
                    Message request = nextPageToken == null ? element : this.setPageToken(element, nextPageToken);
                    request = this.readTime == null ? request : this.setReadTime(request, this.readTime);
                    attempt.recordRequestStart(this.clock.instant());
                    AbstractPagedListResponse pagedResponse = (AbstractPagedListResponse)this.getCallable(this.firestoreStub).call((Object)request);
                    for (AbstractPage page : pagedResponse.iteratePages()) {
                        Message response = (Message)page.getResponse();
                        attempt.recordRequestSuccessful(this.clock.instant());
                        c.output((Object)response);
                        if (!page.hasNextPage()) continue;
                        nextPageToken = page.getNextPageToken();
                        attempt.recordRequestStart(this.clock.instant());
                    }
                    attempt.completeSuccess();
                }
                catch (RuntimeException exception) {
                    Instant end = this.clock.instant();
                    attempt.recordRequestFailed(end);
                    attempt.checkCanRetry(end, exception);
                    continue;
                }
                break;
            }
        }
    }

    private static abstract class StreamingFirestoreV1ReadFn<@UnknownKeyFor InT extends @UnknownKeyFor @NonNull @Initialized Message, @UnknownKeyFor OutT extends @UnknownKeyFor @NonNull @Initialized Message>
    extends BaseFirestoreV1ReadFn<InT, OutT> {
        protected StreamingFirestoreV1ReadFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, null);
        }

        protected StreamingFirestoreV1ReadFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        protected abstract @UnknownKeyFor @NonNull @Initialized ServerStreamingCallable<InT, OutT> getCallable(@UnknownKeyFor @NonNull @Initialized FirestoreStub var1);

        protected abstract InT setStartFrom(InT var1, OutT var2);

        protected abstract @Nullable OutT resumptionValue(@Nullable OutT var1, OutT var2);

        @Override
        public final void processElement(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Message element = Objects.requireNonNull((Message)c.element(), "c.element() must be non null");
            RpcQos.RpcReadAttempt attempt = this.rpcQos.newReadAttempt(this.getRpcAttemptContext());
            Message lastReceivedValue = null;
            while (true) {
                if (!attempt.awaitSafeToProceed(this.clock.instant())) {
                    continue;
                }
                Instant start = this.clock.instant();
                Message request = lastReceivedValue == null ? element : this.setStartFrom(element, lastReceivedValue);
                request = this.readTime == null ? request : this.setReadTime(request, this.readTime);
                try {
                    attempt.recordRequestStart(start);
                    ServerStream serverStream = this.getCallable(this.firestoreStub).call((Object)request);
                    attempt.recordRequestSuccessful(this.clock.instant());
                    for (Message out : serverStream) {
                        lastReceivedValue = this.resumptionValue(lastReceivedValue, out);
                        attempt.recordStreamValue(this.clock.instant());
                        c.output((Object)out);
                    }
                    attempt.completeSuccess();
                }
                catch (RuntimeException exception) {
                    Instant end = this.clock.instant();
                    attempt.recordRequestFailed(end);
                    attempt.checkCanRetry(end, exception);
                    continue;
                }
                break;
            }
        }
    }

    static final class BatchGetDocumentsFn
    extends StreamingFirestoreV1ReadFn<BatchGetDocumentsRequest, BatchGetDocumentsResponse> {
        BatchGetDocumentsFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        BatchGetDocumentsFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.BatchGetDocuments;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized ServerStreamingCallable<@UnknownKeyFor @NonNull @Initialized BatchGetDocumentsRequest, @UnknownKeyFor @NonNull @Initialized BatchGetDocumentsResponse> getCallable(@UnknownKeyFor @NonNull @Initialized FirestoreStub firestoreStub) {
            return firestoreStub.batchGetDocumentsCallable();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized BatchGetDocumentsRequest setStartFrom(@UnknownKeyFor @NonNull @Initialized BatchGetDocumentsRequest element, @UnknownKeyFor @NonNull @Initialized BatchGetDocumentsResponse mostRecentResponse) {
            int startIndex = -1;
            ProtocolStringList documentsList = element.getDocumentsList();
            String missing = mostRecentResponse.getMissing();
            String foundName = mostRecentResponse.hasFound() ? mostRecentResponse.getFound().getName() : null;
            int maxIndex = documentsList.size() - 2;
            for (int i = 0; i <= maxIndex; ++i) {
                String docName = (String)documentsList.get(i);
                if (!docName.equals(missing) && !docName.equals(foundName)) continue;
                startIndex = i;
                break;
            }
            if (0 <= startIndex) {
                BatchGetDocumentsRequest.Builder builder = element.toBuilder().clearDocuments();
                documentsList.stream().skip(startIndex + 1).forEach(arg_0 -> ((BatchGetDocumentsRequest.Builder)builder).addDocuments(arg_0));
                return builder.build();
            }
            throw new IllegalStateException(String.format("Unable to determine BatchGet resumption point. Most recently received doc __name__ '%s'", foundName != null ? foundName : missing));
        }

        @Override
        protected @Nullable @UnknownKeyFor @Initialized BatchGetDocumentsResponse resumptionValue(@Nullable @UnknownKeyFor @Initialized BatchGetDocumentsResponse previousValue, @UnknownKeyFor @NonNull @Initialized BatchGetDocumentsResponse newValue) {
            return newValue.getResultCase() == BatchGetDocumentsResponse.ResultCase.RESULT_NOT_SET ? previousValue : newValue;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized BatchGetDocumentsRequest setReadTime(@UnknownKeyFor @NonNull @Initialized BatchGetDocumentsRequest element, @UnknownKeyFor @NonNull @Initialized Instant readTime) {
            return element.toBuilder().setReadTime(Timestamps.fromMillis((long)readTime.getMillis())).build();
        }
    }

    static final class ListCollectionIdsFn
    extends PaginatedFirestoreV1ReadFn<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse, FirestoreClient.ListCollectionIdsPage, ListCollectionIdsResponse> {
        ListCollectionIdsFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, null);
        }

        ListCollectionIdsFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.ListCollectionIds;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized UnaryCallable<@UnknownKeyFor @NonNull @Initialized ListCollectionIdsRequest, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized FirestoreClient.ListCollectionIdsPagedResponse> getCallable(@UnknownKeyFor @NonNull @Initialized FirestoreStub firestoreStub) {
            return firestoreStub.listCollectionIdsPagedCallable();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized ListCollectionIdsRequest setPageToken(@UnknownKeyFor @NonNull @Initialized ListCollectionIdsRequest element, @UnknownKeyFor @NonNull @Initialized String nextPageToken) {
            return element.toBuilder().setPageToken(nextPageToken).build();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized ListCollectionIdsRequest setReadTime(@UnknownKeyFor @NonNull @Initialized ListCollectionIdsRequest element, @UnknownKeyFor @NonNull @Initialized Instant readTime) {
            return element.toBuilder().setReadTime(Timestamps.fromMillis((long)readTime.getMillis())).build();
        }
    }

    static final class ListDocumentsFn
    extends PaginatedFirestoreV1ReadFn<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse, FirestoreClient.ListDocumentsPage, ListDocumentsResponse> {
        ListDocumentsFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, null);
        }

        ListDocumentsFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.ListDocuments;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized UnaryCallable<@UnknownKeyFor @NonNull @Initialized ListDocumentsRequest, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized FirestoreClient.ListDocumentsPagedResponse> getCallable(@UnknownKeyFor @NonNull @Initialized FirestoreStub firestoreStub) {
            return firestoreStub.listDocumentsPagedCallable();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized ListDocumentsRequest setPageToken(@UnknownKeyFor @NonNull @Initialized ListDocumentsRequest element, @UnknownKeyFor @NonNull @Initialized String nextPageToken) {
            return element.toBuilder().setPageToken(nextPageToken).build();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized ListDocumentsRequest setReadTime(@UnknownKeyFor @NonNull @Initialized ListDocumentsRequest element, @UnknownKeyFor @NonNull @Initialized Instant readTime) {
            return element.toBuilder().setReadTime(Timestamps.fromMillis((long)readTime.getMillis())).build();
        }
    }

    static final class PartitionQueryFn
    extends BaseFirestoreV1ReadFn<PartitionQueryRequest, PartitionQueryPair> {
        public PartitionQueryFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, null);
        }

        public PartitionQueryFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.PartitionQuery;
        }

        @Override
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
            PartitionQueryRequest element = Objects.requireNonNull((PartitionQueryRequest)context.element(), "c.element() must be non null");
            RpcQos.RpcReadAttempt attempt = this.rpcQos.newReadAttempt(this.getRpcAttemptContext());
            PartitionQueryResponse.Builder aggregate = null;
            while (true) {
                if (!attempt.awaitSafeToProceed(this.clock.instant())) {
                    continue;
                }
                try {
                    PartitionQueryRequest request = this.setPageToken(element, aggregate);
                    request = this.readTime == null ? request : this.setReadTime(request, this.readTime);
                    attempt.recordRequestStart(this.clock.instant());
                    FirestoreClient.PartitionQueryPagedResponse pagedResponse = (FirestoreClient.PartitionQueryPagedResponse)this.firestoreStub.partitionQueryPagedCallable().call((Object)request);
                    for (FirestoreClient.PartitionQueryPage page : pagedResponse.iteratePages()) {
                        attempt.recordRequestSuccessful(this.clock.instant());
                        PartitionQueryResponse response = (PartitionQueryResponse)page.getResponse();
                        if (aggregate == null) {
                            aggregate = response.toBuilder();
                        } else {
                            aggregate.addAllPartitions((Iterable)response.getPartitionsList());
                            if (page.hasNextPage()) {
                                aggregate.setNextPageToken(response.getNextPageToken());
                            } else {
                                aggregate.clearNextPageToken();
                            }
                        }
                        if (!page.hasNextPage()) continue;
                        attempt.recordRequestStart(this.clock.instant());
                    }
                    attempt.completeSuccess();
                }
                catch (RuntimeException exception) {
                    Instant end = this.clock.instant();
                    attempt.recordRequestFailed(end);
                    attempt.checkCanRetry(end, exception);
                    continue;
                }
                break;
            }
            if (aggregate != null) {
                context.output((Object)new PartitionQueryPair(element, aggregate.build()));
            }
        }

        private @UnknownKeyFor @NonNull @Initialized PartitionQueryRequest setPageToken(@UnknownKeyFor @NonNull @Initialized PartitionQueryRequest element, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized PartitionQueryResponse.Builder aggregate) {
            if (aggregate != null && aggregate.getNextPageToken() != null) {
                return element.toBuilder().setPageToken(aggregate.getNextPageToken()).build();
            }
            return element;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized PartitionQueryRequest setReadTime(@UnknownKeyFor @NonNull @Initialized PartitionQueryRequest element, @UnknownKeyFor @NonNull @Initialized Instant readTime) {
            return element.toBuilder().setReadTime(Timestamps.fromMillis((long)readTime.getMillis())).build();
        }
    }

    static final class RunQueryFn
    extends StreamingFirestoreV1ReadFn<RunQueryRequest, RunQueryResponse> {
        RunQueryFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        RunQueryFn(@UnknownKeyFor @NonNull @Initialized JodaClock clock, @UnknownKeyFor @NonNull @Initialized FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, @UnknownKeyFor @NonNull @Initialized RpcQosOptions rpcQosOptions, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, readTime);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.RunQuery;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized ServerStreamingCallable<@UnknownKeyFor @NonNull @Initialized RunQueryRequest, @UnknownKeyFor @NonNull @Initialized RunQueryResponse> getCallable(@UnknownKeyFor @NonNull @Initialized FirestoreStub firestoreStub) {
            return firestoreStub.runQueryCallable();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized RunQueryRequest setStartFrom(@UnknownKeyFor @NonNull @Initialized RunQueryRequest element, @UnknownKeyFor @NonNull @Initialized RunQueryResponse runQueryResponse) {
            StructuredQuery query = element.getStructuredQuery();
            StructuredQuery.Builder builder = query.toBuilder();
            builder.addAllOrderBy(QueryUtils.getImplicitOrderBy(query));
            Cursor.Builder cursor = Cursor.newBuilder().setBefore(false);
            for (StructuredQuery.Order order : builder.getOrderByList()) {
                Value value = QueryUtils.lookupDocumentValue(runQueryResponse.getDocument(), order.getField().getFieldPath());
                if (value == null) {
                    throw new IllegalStateException(String.format("Failed to build query resumption token, field '%s' not found in doc with __name__ '%s'", order.getField().getFieldPath(), runQueryResponse.getDocument().getName()));
                }
                cursor.addValues(value);
            }
            builder.setStartAt(cursor.build());
            return element.toBuilder().setStructuredQuery(builder.build()).build();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized RunQueryRequest setReadTime(@UnknownKeyFor @NonNull @Initialized RunQueryRequest element, @UnknownKeyFor @NonNull @Initialized Instant readTime) {
            return element.toBuilder().setReadTime(Timestamps.fromMillis((long)readTime.getMillis())).build();
        }

        @Override
        protected @Nullable @UnknownKeyFor @Initialized RunQueryResponse resumptionValue(@Nullable @UnknownKeyFor @Initialized RunQueryResponse previousValue, @UnknownKeyFor @NonNull @Initialized RunQueryResponse nextValue) {
            return nextValue.hasDocument() ? nextValue : previousValue;
        }
    }
}

