/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameter;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FhirSearchParameterCoder<@UnknownKeyFor T>
extends CustomCoder<FhirSearchParameter<T>> {
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T>> originalCoder;

    FhirSearchParameterCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> originalCoder) {
        this.originalCoder = NullableCoder.of((Coder)MapCoder.of(STRING_CODER, originalCoder));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized FhirSearchParameterCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> originalCoder) {
        return new FhirSearchParameterCoder<T>(originalCoder);
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized FhirSearchParameter<T> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        STRING_CODER.encode((Object)value.getResourceType(), outStream);
        STRING_CODER.encode((Object)value.getKey(), outStream);
        this.originalCoder.encode(value.getQueries(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized FhirSearchParameter<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String resourceType = (String)Preconditions.checkArgumentNotNull((Object)((String)STRING_CODER.decode(inStream)));
        String key = (String)STRING_CODER.decode(inStream);
        Map queries = (Map)this.originalCoder.decode(inStream);
        return FhirSearchParameter.of(resourceType, key, queries);
    }
}

