/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.model;

import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.NewPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@Internal
public class PartitionRecord
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -4524061648930484599L;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant startTime;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> changeStreamContinuationTokens;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime;
    private @UnknownKeyFor @NonNull @Initialized String uuid;
    private final @UnknownKeyFor @NonNull @Initialized Instant parentLowWatermark;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> parentPartitions;

    public PartitionRecord(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> changeStreamContinuationTokens, @UnknownKeyFor @NonNull @Initialized Instant parentLowWatermark, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> parentPartitions) {
        this(partition, changeStreamContinuationTokens, "", parentLowWatermark, parentPartitions, null);
    }

    public PartitionRecord(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized Instant startTime, @UnknownKeyFor @NonNull @Initialized Instant parentLowWatermark, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> parentPartitions) {
        this(partition, startTime, "", parentLowWatermark, parentPartitions, null);
    }

    public PartitionRecord(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized Instant startTime, @UnknownKeyFor @NonNull @Initialized String uuid, @UnknownKeyFor @NonNull @Initialized Instant parentLowWatermark, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> parentPartitions, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime) {
        this.partition = partition;
        this.startTime = startTime;
        this.uuid = uuid;
        this.parentLowWatermark = parentLowWatermark;
        this.endTime = endTime;
        this.parentPartitions = parentPartitions;
    }

    public PartitionRecord(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> changeStreamContinuationTokens, @UnknownKeyFor @NonNull @Initialized String uuid, @UnknownKeyFor @NonNull @Initialized Instant parentLowWatermark, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> parentPartitions, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime) {
        this.partition = partition;
        this.changeStreamContinuationTokens = changeStreamContinuationTokens;
        this.uuid = uuid;
        this.parentLowWatermark = parentLowWatermark;
        this.endTime = endTime;
        this.parentPartitions = parentPartitions;
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant getStartTime() {
        return this.startTime;
    }

    public @UnknownKeyFor @NonNull @Initialized String getUuid() {
        return this.uuid;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getParentLowWatermark() {
        return this.parentLowWatermark;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange getPartition() {
        return this.partition;
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> getChangeStreamContinuationTokens() {
        return this.changeStreamContinuationTokens;
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant getEndTime() {
        return this.endTime;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> getParentPartitions() {
        return this.parentPartitions;
    }

    public void setUuid(@UnknownKeyFor @NonNull @Initialized String uuid) {
        this.uuid = uuid;
    }

    public void setEndTime(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime) {
        this.endTime = endTime;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionRecord)) {
            return false;
        }
        PartitionRecord that = (PartitionRecord)o;
        return Objects.equals(this.getPartition(), that.getPartition()) && Objects.equals(this.getStartTime(), that.getStartTime()) && Objects.equals(this.getChangeStreamContinuationTokens(), that.getChangeStreamContinuationTokens()) && Objects.equals(this.getEndTime(), that.getEndTime()) && Objects.equals(this.getUuid(), that.getUuid()) && Objects.equals(this.getParentLowWatermark(), that.getParentLowWatermark()) && Objects.equals(this.parentPartitions, that.parentPartitions);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getPartition(), this.getStartTime(), this.getChangeStreamContinuationTokens(), this.getEndTime(), this.getUuid(), this.getParentLowWatermark(), this.parentPartitions);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "PartitionRecord{partition=" + ByteStringRangeHelper.formatByteStringRange(this.partition) + ", startTime=" + this.startTime + ", changeStreamContinuationTokens=" + this.changeStreamContinuationTokens + ", endTime=" + this.endTime + ", uuid='" + this.uuid + '\'' + ", parentLowWatermark=" + this.parentLowWatermark + ", parentPartitions=" + this.parentPartitions + '}';
    }
}

