/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableReadSchemaTransformProvider_BigtableReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class BigtableReadSchemaTransformProvider
extends TypedSchemaTransformProvider<BigtableReadSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "output";
    public static final @UnknownKeyFor @NonNull @Initialized Schema CELL_SCHEMA = Schema.builder().addByteArrayField("value").addInt64Field("timestamp_micros").build();
    public static final @UnknownKeyFor @NonNull @Initialized Schema ROW_SCHEMA = Schema.builder().addByteArrayField("key").addMapField("column_families", Schema.FieldType.STRING, Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)CELL_SCHEMA)))).build();

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration> configurationClass() {
        return BigtableReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration configuration) {
        return new BigtableReadSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:bigtable_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_TAG);
    }

    public static class BigtableRowToBeamRow
    extends SimpleFunction<Row, org.apache.beam.sdk.values.Row> {
        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row apply(@UnknownKeyFor @NonNull @Initialized Row bigtableRow) {
            HashMap families = new HashMap();
            for (Family fam : bigtableRow.getFamiliesList()) {
                HashMap columns = new HashMap();
                for (Column col : fam.getColumnsList()) {
                    ArrayList<org.apache.beam.sdk.values.Row> cells = new ArrayList<org.apache.beam.sdk.values.Row>();
                    for (Cell cell : col.getCellsList()) {
                        org.apache.beam.sdk.values.Row cellRow = org.apache.beam.sdk.values.Row.withSchema((Schema)CELL_SCHEMA).withFieldValue("value", (Object)ByteBuffer.wrap(cell.getValue().toByteArray())).withFieldValue("timestamp_micros", (Object)cell.getTimestampMicros()).build();
                        cells.add(cellRow);
                    }
                    columns.put(col.getQualifier().toStringUtf8(), cells);
                }
                families.put(fam.getName(), columns);
            }
            org.apache.beam.sdk.values.Row beamRow = org.apache.beam.sdk.values.Row.withSchema((Schema)ROW_SCHEMA).withFieldValue("key", (Object)ByteBuffer.wrap(bigtableRow.getKey().toByteArray())).withFieldValue("column_families", families).build();
            return beamRow;
        }
    }

    private static class BigtableReadSchemaTransform
    extends PTransform<PCollectionRowTuple, PCollectionRowTuple>
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration configuration;

        BigtableReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.getAll().isEmpty(), (Object)String.format("Input to %s is expected to be empty, but is not.", ((Object)((Object)this)).getClass().getSimpleName()));
            PCollection bigtableRows = (PCollection)input.getPipeline().apply((PTransform)BigtableIO.read().withTableId(this.configuration.getTableId()).withInstanceId(this.configuration.getInstanceId()).withProjectId(this.configuration.getProjectId()));
            PCollection beamRows = ((PCollection)bigtableRows.apply((PTransform)MapElements.via((SimpleFunction)new BigtableRowToBeamRow()))).setRowSchema(ROW_SCHEMA);
            return PCollectionRowTuple.of((String)BigtableReadSchemaTransformProvider.OUTPUT_TAG, (PCollection)beamRows);
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return this;
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigtableReadSchemaTransformConfiguration {
        public void validate() {
            String emptyStringMessage = "Invalid Bigtable Read configuration: %s should not be a non-empty String";
            Preconditions.checkArgument((!this.getTableId().isEmpty() ? 1 : 0) != 0, (Object)String.format(emptyStringMessage, "table"));
            Preconditions.checkArgument((!this.getInstanceId().isEmpty() ? 1 : 0) != 0, (Object)String.format(emptyStringMessage, "instance"));
            Preconditions.checkArgument((!this.getProjectId().isEmpty() ? 1 : 0) != 0, (Object)String.format(emptyStringMessage, "project"));
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigtableReadSchemaTransformProvider_BigtableReadSchemaTransformConfiguration.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getTableId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getInstanceId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getProjectId();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration build();
        }
    }
}

