/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.config.BigtableOptions;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@AutoValue
@Internal
public abstract class BigtableConfig
implements Serializable {
    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getProjectId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getInstanceId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getAppProfileId();

    @Deprecated
    abstract @Nullable @UnknownKeyFor @Initialized BigtableOptions getBigtableOptions();

    abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> getBigtableOptionsConfigurator();

    abstract @UnknownKeyFor @NonNull @Initialized boolean getValidate();

    abstract @Nullable @UnknownKeyFor @Initialized String getEmulatorHost();

    abstract @Nullable @UnknownKeyFor @Initialized String getUserAgent();

    abstract @Nullable @UnknownKeyFor @Initialized CredentialFactory getCredentialFactory();

    abstract @Nullable @UnknownKeyFor @Initialized Integer getChannelCount();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_BigtableConfig.Builder();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
        Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"Project Id of BigTable can not be null");
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"Instance Id of BigTable can not be null");
        return this.toBuilder().setInstanceId(instanceId).build();
    }

    @UnknownKeyFor @NonNull @Initialized BigtableConfig withAppProfileId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> appProfileId) {
        Preconditions.checkArgument((appProfileId != null ? 1 : 0) != 0, (Object)"App profile id can not be null");
        return this.toBuilder().setAppProfileId(appProfileId).build();
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withBigtableOptions(@UnknownKeyFor @NonNull @Initialized BigtableOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"Bigtable options can not be null");
        return this.toBuilder().setBigtableOptions(options).build();
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withBigtableOptionsConfigurator(@UnknownKeyFor @NonNull @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> configurator) {
        Preconditions.checkArgument((configurator != null ? 1 : 0) != 0, (Object)"configurator can not be null");
        return this.toBuilder().setBigtableOptionsConfigurator(configurator).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withValidate(@UnknownKeyFor @NonNull @Initialized boolean isEnabled) {
        return this.toBuilder().setValidate(isEnabled).build();
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withEmulator(@UnknownKeyFor @NonNull @Initialized String emulatorHost) {
        Preconditions.checkArgument((emulatorHost != null ? 1 : 0) != 0, (Object)"emulatorHost can not be null");
        return this.toBuilder().setEmulatorHost(emulatorHost).build();
    }

    void validate() {
        Preconditions.checkArgument((this.getProjectId() != null && (!this.getProjectId().isAccessible() || !((String)this.getProjectId().get()).isEmpty()) || this.getBigtableOptions() != null && this.getBigtableOptions().getProjectId() != null && !this.getBigtableOptions().getProjectId().isEmpty() ? 1 : 0) != 0, (Object)"Could not obtain Bigtable project id");
        Preconditions.checkArgument((this.getInstanceId() != null && (!this.getInstanceId().isAccessible() || !((String)this.getInstanceId().get()).isEmpty()) || this.getBigtableOptions() != null && this.getBigtableOptions().getInstanceId() != null && !this.getBigtableOptions().getInstanceId().isEmpty() ? 1 : 0) != 0, (Object)"Could not obtain Bigtable instance id");
    }

    void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("Bigtable Project Id")).addIfNotNull(DisplayData.item((String)"instanceId", this.getInstanceId()).withLabel("Bigtable Instance Id")).addIfNotNull(DisplayData.item((String)"appProfileId", this.getAppProfileId()).withLabel("Bigtable App Profile Id"));
        if (this.getBigtableOptions() != null) {
            builder.add(DisplayData.item((String)"bigtableOptions", (String)this.getBigtableOptions().toString()).withLabel("Bigtable Options"));
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean isDataAccessible() {
        return !(this.getProjectId() != null && !this.getProjectId().isAccessible() || this.getInstanceId() != null && !this.getInstanceId().isAccessible() || this.getAppProfileId() != null && !this.getAppProfileId().isAccessible());
    }

    @SideEffectFree
    public final @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(BigtableConfig.class).add("projectId", this.getProjectId()).add("instanceId", this.getInstanceId()).add("appProfileId", this.getAppProfileId()).add("userAgent", (Object)this.getUserAgent()).add("emulator", (Object)this.getEmulatorHost()).toString();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setAppProfileId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        @Deprecated
        abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableOptions(@UnknownKeyFor @NonNull @Initialized BigtableOptions var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setValidate(@UnknownKeyFor @NonNull @Initialized boolean var1);

        @Deprecated
        abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableOptionsConfigurator(@UnknownKeyFor @NonNull @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEmulatorHost(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setUserAgent(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCredentialFactory(@UnknownKeyFor @NonNull @Initialized CredentialFactory var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setChannelCount(@UnknownKeyFor @NonNull @Initialized int var1);

        abstract @UnknownKeyFor @NonNull @Initialized BigtableConfig build();
    }
}

