/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.WriteTables;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteRename
extends DoFn<Iterable<KV<TableDestination, WriteTables.Result>>, TableDestination> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteRename.class);
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> jobIdToken;
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition firstPaneWriteDisposition;
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition firstPaneCreateDisposition;
    private final @UnknownKeyFor @NonNull @Initialized int maxRetryJobs;
    private final @Nullable @UnknownKeyFor @Initialized String kmsKey;
    private final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId;
    private transient @Nullable @UnknownKeyFor @Initialized BigQueryServices.DatasetService datasetService;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PendingJobData> pendingJobs = Lists.newArrayList();

    public WriteRename(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> jobIdToken,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized int maxRetryJobs, @Nullable @UnknownKeyFor @Initialized String kmsKey, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId) {
        this.bqServices = bqServices;
        this.jobIdToken = jobIdToken;
        this.firstPaneWriteDisposition = writeDisposition;
        this.firstPaneCreateDisposition = createDisposition;
        this.maxRetryJobs = maxRetryJobs;
        this.kmsKey = kmsKey;
        this.loadJobProjectId = loadJobProjectId;
    }

    @DoFn.StartBundle
    public void startBundle(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) {
        this.pendingJobs.clear();
    }

    @DoFn.Teardown
    public void onTeardown() {
        try {
            if (this.datasetService != null) {
                this.datasetService.close();
                this.datasetService = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized TableDestination,  @UnknownKeyFor @NonNull @Initialized WriteTables.Result>> element, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayListMultimap tempTables = ArrayListMultimap.create();
        for (KV<TableDestination, WriteTables.Result> kV : element) {
            tempTables.put((Object)((TableDestination)kV.getKey()), (Object)((WriteTables.Result)kV.getValue()));
        }
        for (Map.Entry entry : tempTables.asMap().entrySet()) {
            if (((Collection)entry.getValue()).isEmpty()) continue;
            this.pendingJobs.add(this.startWriteRename((TableDestination)entry.getKey(), (Iterable)entry.getValue(), c, window));
        }
    }

    @DoFn.FinishBundle
    public void finishBundle(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryServices.DatasetService datasetService = this.getDatasetService(c.getPipelineOptions().as(BigQueryOptions.class));
        BigQueryHelpers.PendingJobManager jobManager = new BigQueryHelpers.PendingJobManager();
        for (PendingJobData pendingJob : this.pendingJobs) {
            jobManager.addPendingJob(pendingJob.retryJob, (SerializableFunction<BigQueryHelpers.PendingJob, Exception>)(SerializableFunction & Serializable)j -> {
                try {
                    if (pendingJob.tableDestination.getTableDescription() != null) {
                        TableReference ref = pendingJob.tableDestination.getTableReference();
                        datasetService.patchTableDescription(ref.clone().setTableId(BigQueryHelpers.stripPartitionDecorator(ref.getTableId())), pendingJob.tableDestination.getTableDescription());
                    }
                    c.output((Object)pendingJob.tableDestination, pendingJob.window.maxTimestamp(), pendingJob.window);
                    WriteRename.removeTemporaryTables(datasetService, pendingJob.tempTables);
                    return null;
                }
                catch (IOException | InterruptedException e) {
                    return e;
                }
            });
        }
        jobManager.waitForDone();
    }

    private @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService getDatasetService(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.datasetService == null) {
            this.datasetService = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
        }
        return this.datasetService;
    }

    private @UnknownKeyFor @NonNull @Initialized PendingJobData startWriteRename(@UnknownKeyFor @NonNull @Initialized TableDestination finalTableDestination, @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized WriteTables.Result> tempTableNames, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
         @Nullable WriteTables.Result firstTempTable = (WriteTables.Result)Iterables.getFirst(tempTableNames, null);
        boolean isFirstPane = firstTempTable != null && firstTempTable.isFirstPane() != false && c.pane().isFirst();
        BigQueryIO.Write.WriteDisposition writeDisposition = isFirstPane ? this.firstPaneWriteDisposition : BigQueryIO.Write.WriteDisposition.WRITE_APPEND;
        BigQueryIO.Write.CreateDisposition createDisposition = isFirstPane ? this.firstPaneCreateDisposition : BigQueryIO.Write.CreateDisposition.CREATE_NEVER;
        List<TableReference> tempTables = StreamSupport.stream(tempTableNames.spliterator(), false).map(result -> BigQueryHelpers.fromJsonString(result.getTableName(), TableReference.class)).collect(Collectors.toList());
        String jobIdPrefix = BigQueryResourceNaming.createJobIdWithDestination((String)c.sideInput(this.jobIdToken), finalTableDestination, -1, c.pane().getIndex());
        BigQueryHelpers.PendingJob retryJob = this.startCopy(this.bqServices.getJobService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), this.getDatasetService(c.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, finalTableDestination.getTableReference(), tempTables, writeDisposition, createDisposition, this.kmsKey, this.loadJobProjectId);
        return new PendingJobData(retryJob, finalTableDestination, tempTables, window);
    }

    private @UnknownKeyFor @NonNull @Initialized BigQueryHelpers.PendingJob startCopy(@UnknownKeyFor @NonNull @Initialized BigQueryServices.JobService jobService, @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService, @UnknownKeyFor @NonNull @Initialized String jobIdPrefix, @UnknownKeyFor @NonNull @Initialized TableReference ref, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableReference> tempTables,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @Nullable @UnknownKeyFor @Initialized String kmsKey, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId) {
        JobConfigurationTableCopy copyConfig = new JobConfigurationTableCopy().setSourceTables(tempTables).setDestinationTable(ref).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name());
        if (kmsKey != null) {
            copyConfig.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKey));
        }
        String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, ref.getProjectId(), ref.getDatasetId());
        String projectId = loadJobProjectId == null || loadJobProjectId.get() == null ? ref.getProjectId() : (String)loadJobProjectId.get();
        BigQueryHelpers.PendingJob retryJob = new BigQueryHelpers.PendingJob((SerializableFunction<BigQueryHelpers.RetryJobId, Void>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            LOG.info("Starting copy job for table {} using  {}, job id iteration {}", new Object[]{ref, jobRef, jobId.getRetryIndex()});
            try {
                jobService.startCopyJob(jobRef, copyConfig);
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("Copy job {} failed.", (Object)jobRef, (Object)e);
                throw new RuntimeException(e);
            }
            return null;
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.pollJob(jobRef, Integer.MAX_VALUE);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.getJob(jobRef);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.maxRetryJobs, jobIdPrefix);
        return retryJob;
    }

    static void removeTemporaryTables(@UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService tableService, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableReference> tempTables) {
        for (TableReference tableRef : tempTables) {
            try {
                LOG.debug("Deleting table {}", (Object)BigQueryHelpers.toJsonString(tableRef));
                tableService.deleteTable(tableRef);
            }
            catch (Exception e) {
                LOG.warn("Failed to delete the table {}", (Object)BigQueryHelpers.toJsonString(tableRef), (Object)e);
            }
        }
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"firstPaneWriteDisposition", (String)this.firstPaneWriteDisposition.toString()).withLabel("Write Disposition")).add(DisplayData.item((String)"firstPaneCreateDisposition", (String)this.firstPaneCreateDisposition.toString()).withLabel("Create Disposition")).add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
    }

    private static class PendingJobData {
        final @UnknownKeyFor @NonNull @Initialized BigQueryHelpers.PendingJob retryJob;
        final @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination;
        final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableReference> tempTables;
        final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;

        public PendingJobData(@UnknownKeyFor @NonNull @Initialized BigQueryHelpers.PendingJob retryJob, @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableReference> tempTables, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            this.retryJob = retryJob;
            this.tableDestination = tableDestination;
            this.tempTables = tempTables;
            this.window = window;
        }
    }
}

