/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampRangeTracker
extends RestrictionTracker<TimestampRange, Timestamp>
implements RestrictionTracker.HasProgress {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TimestampRangeTracker.class);
    protected @UnknownKeyFor @NonNull @Initialized TimestampRange range;
    protected @Nullable @UnknownKeyFor @Initialized Timestamp lastAttemptedPosition;
    protected @Nullable @UnknownKeyFor @Initialized Timestamp lastClaimedPosition;
    protected @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Timestamp> timeSupplier;

    public TimestampRangeTracker(@UnknownKeyFor @NonNull @Initialized TimestampRange range) {
        this.range = (TimestampRange)Preconditions.checkNotNull((Object)range);
        this.timeSupplier = () -> Timestamp.now();
    }

    @VisibleForTesting
    public void setTimeSupplier(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Timestamp> timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized Timestamp position) {
        Preconditions.checkArgument((this.lastAttemptedPosition == null || position.compareTo(this.lastAttemptedPosition) > 0 ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s", (Object)position, (Object)this.lastAttemptedPosition);
        Preconditions.checkArgument((position.compareTo(this.range.getFrom()) >= 0 ? 1 : 0) != 0, (String)"Trying to claim offset %s before start of the range %s", (Object)position, (Object)this.range);
        this.lastAttemptedPosition = position;
        if (position.compareTo(this.range.getTo()) >= 0) {
            return false;
        }
        this.lastClaimedPosition = position;
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized Timestamp position, @UnknownKeyFor @NonNull @Initialized PartitionMetadata partitionMetadata) {
        Preconditions.checkArgument((this.lastAttemptedPosition == null || position.compareTo(this.lastAttemptedPosition) > 0 ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s. The partition metadata: %s", (Object)position, (Object)this.lastAttemptedPosition, (Object)partitionMetadata.toString());
        Preconditions.checkArgument((position.compareTo(this.range.getFrom()) >= 0 ? 1 : 0) != 0, (String)"Trying to claim offset %s before start of the range %s. The partition metadata: %s", (Object)position, (Object)this.range, (Object)partitionMetadata.toString());
        this.lastAttemptedPosition = position;
        if (position.compareTo(this.range.getTo()) >= 0) {
            return false;
        }
        this.lastClaimedPosition = position;
        return true;
    }

    public @Nullable @UnknownKeyFor @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized TimestampRange> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        BigDecimal toInNanos;
        BigDecimal nanosOffset;
        BigDecimal fromInNanos = TimestampUtils.toNanos(this.range.getFrom());
        BigDecimal currentInNanos = this.lastAttemptedPosition == null ? fromInNanos.subtract(BigDecimal.ONE, MathContext.DECIMAL128) : TimestampUtils.toNanos(this.lastAttemptedPosition);
        BigDecimal splitPositionInNanos = currentInNanos.add(nanosOffset = (toInNanos = TimestampUtils.toNanos(this.range.getTo())).subtract(currentInNanos, MathContext.DECIMAL128).multiply(BigDecimal.valueOf(fractionOfRemainder), MathContext.DECIMAL128).max(BigDecimal.ONE), MathContext.DECIMAL128);
        Timestamp splitPosition = TimestampUtils.toTimestamp(splitPositionInNanos);
        if (splitPosition.compareTo(this.range.getTo()) >= 0) {
            return null;
        }
        TimestampRange primary = new TimestampRange(this.range.getFrom(), splitPosition);
        TimestampRange residual = new TimestampRange(splitPosition, this.range.getTo());
        this.range = primary;
        return SplitResult.of((Object)primary, (Object)residual);
    }

    public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (this.range.getFrom().compareTo(this.range.getTo()) == 0) {
            return;
        }
        Preconditions.checkState((this.lastAttemptedPosition != null ? 1 : 0) != 0, (String)"Key range is non-empty %s and no keys have been attempted.", (Object)this.range);
        Timestamp nextPosition = TimestampUtils.next(this.lastAttemptedPosition);
        if (nextPosition.compareTo(this.range.getTo()) < 0) {
            throw new IllegalStateException(String.format("Last attempted key was %s in range %s, claiming work in [%s, %s) was not attempted", this.lastAttemptedPosition, this.range, nextPosition, this.range.getTo()));
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
        BigDecimal end = this.range.getTo().compareTo(Timestamp.MAX_VALUE) == 0 ? BigDecimal.valueOf(this.timeSupplier.get().getSeconds()) : BigDecimal.valueOf(this.range.getTo().getSeconds());
        BigDecimal current = this.lastClaimedPosition == null ? BigDecimal.valueOf(this.range.getFrom().getSeconds()) : BigDecimal.valueOf(this.lastClaimedPosition.getSeconds());
        BigDecimal workRemaining = end.subtract(current).max(BigDecimal.ONE);
        LOG.debug("Reported progress current: {}, end: {}, workRemaining: {}", new Object[]{current.doubleValue(), end.doubleValue(), workRemaining.doubleValue()});
        return RestrictionTracker.Progress.from((double)current.doubleValue(), (double)workRemaining.doubleValue());
    }

    public @UnknownKeyFor @NonNull @Initialized TimestampRange currentRestriction() {
        return this.range;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.BOUNDED;
    }
}

