/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dofn;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InitializeDoFn
extends DoFn<byte[], Instant>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1868189906451252363L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(InitializeDoFn.class);
    private final @UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory;
    private final @UnknownKeyFor @NonNull @Initialized String metadataTableAppProfileId;
    private @UnknownKeyFor @NonNull @Initialized Instant startTime;

    public InitializeDoFn(@UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory, @UnknownKeyFor @NonNull @Initialized String metadataTableAppProfileId, @UnknownKeyFor @NonNull @Initialized Instant startTime) {
        this.daoFactory = daoFactory;
        this.metadataTableAppProfileId = metadataTableAppProfileId;
        this.startTime = startTime;
    }

    @DoFn.ProcessElement
    public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Instant> receiver) throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.info(this.daoFactory.getStreamTableDebugString());
        LOG.info(this.daoFactory.getMetadataTableDebugString());
        LOG.info("ChangeStreamName: " + this.daoFactory.getChangeStreamName());
        if (!this.daoFactory.getMetadataTableAdminDao().isAppProfileSingleClusterAndTransactional(this.metadataTableAppProfileId)) {
            LOG.error("App profile id '" + this.metadataTableAppProfileId + "' provided to access metadata table needs to use single-cluster routing policy and allow single-row transactions.");
            return;
        }
        if (this.daoFactory.getMetadataTableAdminDao().createMetadataTable()) {
            LOG.info("Created metadata table: " + this.daoFactory.getMetadataTableAdminDao().getTableId());
        } else {
            LOG.info("Reusing existing metadata table: " + this.daoFactory.getMetadataTableAdminDao().getTableId());
        }
        this.daoFactory.getMetadataTableDao().writeDetectNewPartitionVersion();
        receiver.output((Object)this.startTime);
    }
}

