/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.cloud.bigtable.data.v2.models.Range;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.UniqueIdGenerator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class GenerateInitialPartitionsAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GenerateInitialPartitionsAction.class);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamDao changeStreamDao;

    public GenerateInitialPartitionsAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized ChangeStreamDao changeStreamDao) {
        this.metrics = metrics;
        this.changeStreamDao = changeStreamDao;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation run(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> tracker, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, @UnknownKeyFor @NonNull @Initialized Instant startTime) {
        if (!tracker.tryClaim((Object)0L)) {
            LOG.error("Could not claim initial DetectNewPartition restriction. No partitions are outputted.");
            return DoFn.ProcessContinuation.stop();
        }
        List<Range.ByteStringRange> streamPartitions = this.changeStreamDao.generateInitialChangeStreamPartitions();
        watermarkEstimator.setWatermark(startTime);
        for (Range.ByteStringRange partition : streamPartitions) {
            this.metrics.incListPartitionsCount();
            String uid = UniqueIdGenerator.getNextId();
            PartitionRecord partitionRecord = new PartitionRecord(partition, startTime, uid, startTime);
            receiver.outputWithTimestamp((Object)partitionRecord, Instant.EPOCH);
        }
        return DoFn.ProcessContinuation.resume();
    }
}

