/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.protobuf.DynamicMessage;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.AvroGenericRecordToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class StorageApiDynamicDestinationsGenericRecord<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, @UnknownKeyFor @NonNull @Initialized GenericRecord> toGenericRecord;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@Nullable @UnknownKeyFor @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized Schema> schemaFactory;

    StorageApiDynamicDestinationsGenericRecord(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@Nullable @UnknownKeyFor @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized Schema> schemaFactory, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, @UnknownKeyFor @NonNull @Initialized GenericRecord> toGenericRecord) {
        super(inner);
        this.toGenericRecord = toGenericRecord;
        this.schemaFactory = schemaFactory;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(DestinationT destination, @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new GenericRecordConverter(destination);
    }

    class GenericRecordConverter
    implements StorageApiDynamicDestinations.MessageConverter<T> {
        final @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema protoTableSchema;
        final @UnknownKeyFor @NonNull @Initialized Schema avroSchema;
        final @UnknownKeyFor @NonNull @Initialized TableSchema bqTableSchema;
        final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor;

        GenericRecordConverter(DestinationT destination) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.avroSchema = (Schema)StorageApiDynamicDestinationsGenericRecord.this.schemaFactory.apply((Object)StorageApiDynamicDestinationsGenericRecord.this.getSchema(destination));
            this.bqTableSchema = BigQueryUtils.toTableSchema(AvroUtils.toBeamSchema((Schema)this.avroSchema));
            this.protoTableSchema = AvroGenericRecordToStorageApiProto.protoTableSchemaFromAvroSchema(this.avroSchema);
            this.descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema(this.protoTableSchema, true);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload toMessage(T element) throws @UnknownKeyFor @NonNull @Initialized Exception {
            DynamicMessage msg = AvroGenericRecordToStorageApiProto.messageFromGenericRecord(this.descriptor, (GenericRecord)StorageApiDynamicDestinationsGenericRecord.this.toGenericRecord.apply(new AvroWriteRequest(element, this.avroSchema)));
            return StorageApiWritePayload.of(msg.toByteArray(), null);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableRow toTableRow(T element) {
            return BigQueryUtils.convertGenericRecordToTableRow((GenericRecord)StorageApiDynamicDestinationsGenericRecord.this.toGenericRecord.apply(new AvroWriteRequest(element, this.avroSchema)), this.bqTableSchema);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema getTableSchema() {
            return this.protoTableSchema;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload toMessage(@UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized boolean respectRequired) throws @UnknownKeyFor @NonNull @Initialized Exception {
            throw new RuntimeException("Not supported");
        }
    }
}

