/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.ErrorProto;
import java.io.Serializable;
import java.util.Set;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class InsertRetryPolicy
implements Serializable {
    static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> PERSISTENT_ERRORS = ImmutableSet.of((Object)"invalid", (Object)"invalidQuery", (Object)"notImplemented", (Object)"row-too-large", (Object)"parseError");

    public abstract @UnknownKeyFor @NonNull @Initialized boolean shouldRetry(@UnknownKeyFor @NonNull @Initialized Context var1);

    public static @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy neverRetry() {
        return new InsertRetryPolicy(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean shouldRetry(@UnknownKeyFor @NonNull @Initialized Context context) {
                return false;
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy alwaysRetry() {
        return new InsertRetryPolicy(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean shouldRetry(@UnknownKeyFor @NonNull @Initialized Context context) {
                return true;
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryTransientErrors() {
        return new InsertRetryPolicy(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean shouldRetry(@UnknownKeyFor @NonNull @Initialized Context context) {
                if (context.getInsertErrors().getErrors() != null) {
                    for (ErrorProto error : context.getInsertErrors().getErrors()) {
                        if (error.getReason() == null || !PERSISTENT_ERRORS.contains(error.getReason())) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static class Context {
        final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse.InsertErrors errors;

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse.InsertErrors getInsertErrors() {
            return this.errors;
        }

        public Context(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse.InsertErrors errors) {
            this.errors = errors;
        }
    }
}

