/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaRetrievalException;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryTableSourceDef
implements BigQuerySourceDef {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryTableSourceDef.class);
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonTable;

    static @UnknownKeyFor @NonNull @Initialized BigQueryTableSourceDef create(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> table) {
        ValueProvider.NestedValueProvider jsonTable = ValueProvider.NestedValueProvider.of((ValueProvider)((ValueProvider)Preconditions.checkNotNull(table, (Object)"table")), (SerializableFunction)new BigQueryHelpers.TableRefToJson());
        return new BigQueryTableSourceDef(bqServices, (ValueProvider<String>)jsonTable);
    }

    private BigQueryTableSourceDef(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonTable) {
        this.bqServices = bqServices;
        this.jsonTable = jsonTable;
    }

    @UnknownKeyFor @NonNull @Initialized TableReference getTableReference(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TableReference tableReference = (TableReference)BigQueryIO.JSON_FACTORY.fromString((String)this.jsonTable.get(), TableReference.class);
        return this.setDefaultProjectIfAbsent(bqOptions, tableReference);
    }

    private @UnknownKeyFor @NonNull @Initialized TableReference setDefaultProjectIfAbsent(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions, @UnknownKeyFor @NonNull @Initialized TableReference tableReference) {
        if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)bqOptions.getProject()) ? 1 : 0) != 0, (String)"No project ID set in %s or %s, cannot construct a complete %s", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName(), (Object)TableReference.class.getSimpleName());
            LOG.info("Project ID not set in {}. Using default project from {}.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
            tableReference.setProjectId(bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject());
        }
        return tableReference;
    }

    @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonTable() {
        return this.jsonTable;
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized BigQuerySourceBase<T> toSource(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T>> readerFactory, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        return BigQueryTableSource.create(stepUuid, this, this.bqServices, coder, readerFactory, useAvroLogicalTypes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Experimental(value=Experimental.Kind.SCHEMAS)
    public @UnknownKeyFor @NonNull @Initialized Schema getBeamSchema(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
        try (BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(bqOptions);){
            TableReference tableRef = this.getTableReference(bqOptions);
            Table table = datasetService.getTable(tableRef);
            TableSchema tableSchema = ((Table)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)table)).getSchema();
            Schema schema = BigQueryUtils.fromTableSchema(tableSchema);
            return schema;
        }
        catch (Exception e) {
            throw new BigQuerySchemaRetrievalException("Exception while trying to retrieve schema", e);
        }
    }
}

