/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionRestrictionSplitter {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PartitionRestrictionSplitter.class);

    public @Nullable @UnknownKeyFor @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized PartitionRestriction> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder, @Nullable @UnknownKeyFor @Initialized PartitionPosition lastClaimedPosition, @UnknownKeyFor @NonNull @Initialized PartitionRestriction restriction) {
        SplitResult splitResult;
        if (lastClaimedPosition == null) {
            return null;
        }
        String token = Optional.ofNullable(restriction.getMetadata()).map(PartitionRestrictionMetadata::getPartitionToken).orElse("");
        PartitionMode positionMode = lastClaimedPosition.getMode();
        Timestamp startTimestamp = restriction.getStartTimestamp();
        Timestamp endTimestamp = restriction.getEndTimestamp();
        switch (positionMode) {
            case UPDATE_STATE: {
                splitResult = SplitResult.of((Object)PartitionRestriction.stop(restriction), (Object)PartitionRestriction.queryChangeStream(startTimestamp, endTimestamp).withMetadata(restriction.getMetadata()));
                break;
            }
            case QUERY_CHANGE_STREAM: {
                BigDecimal nanosOffset;
                if (token.equals("Parent0")) {
                    splitResult = null;
                    break;
                }
                BigDecimal toInNanos = TimestampUtils.toNanos(endTimestamp);
                BigDecimal currentInNanos = TimestampUtils.toNanos(lastClaimedPosition.getTimestamp().get());
                BigDecimal splitPositionInNanos = currentInNanos.add(nanosOffset = toInNanos.subtract(currentInNanos, MathContext.DECIMAL128).multiply(BigDecimal.valueOf(fractionOfRemainder), MathContext.DECIMAL128).max(BigDecimal.ONE), MathContext.DECIMAL128);
                Timestamp splitPosition = TimestampUtils.toTimestamp(splitPositionInNanos);
                if (splitPosition.compareTo(endTimestamp) >= 0) {
                    splitResult = SplitResult.of((Object)PartitionRestriction.stop(restriction), (Object)PartitionRestriction.waitForChildPartitions(startTimestamp, endTimestamp).withMetadata(restriction.getMetadata()));
                    break;
                }
                splitResult = SplitResult.of((Object)PartitionRestriction.queryChangeStream(startTimestamp, splitPosition).withMetadata(restriction.getMetadata()), (Object)PartitionRestriction.queryChangeStream(splitPosition, endTimestamp).withMetadata(restriction.getMetadata()));
                break;
            }
            case WAIT_FOR_CHILD_PARTITIONS: {
                splitResult = SplitResult.of((Object)PartitionRestriction.stop(restriction), (Object)PartitionRestriction.waitForChildPartitions(startTimestamp, endTimestamp).withMetadata(restriction.getMetadata()));
                break;
            }
            case DONE: 
            case STOP: {
                splitResult = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode " + (Object)((Object)positionMode));
            }
        }
        LOG.debug("[" + token + "] Split result for (" + fractionOfRemainder + ", " + lastClaimedPosition + ", " + restriction + ") is " + splitResult);
        return splitResult;
    }
}

